/**@file
 *
 *@brief	QRL Maker
 *@date		Sun,31 May,2015 - Tue,08 Sep,2015
 *@date		Fri,11 Sep,2015 - Tue,15 Sep,2015
 *@date		Mon,21 Sep,2015
 *@date		Sat,03 Oct,2015 - Mon,12 Oct,2015
 *@date		Tue,13 Oct,2015 - Fri,16 Oct,2015
 *@date		Fri,23 Oct,2015
 *@date		Sat,31 Oct,2015
 *@date		Sun,09 Jul,2017
 *@date		Sun,16 Jul,2017
 *@date		Sun,23 Jul,2017
 *@date		Fri,23 Nov,2017
 *@date		Fri,28 Dec,2018
 *@date		Sat,29 Dec,2018
 *@date		Mon,31 Dec,2018
 *@date		Fri,25 Jan,2019
 *@date		Sun,27 Jan,2019
 *@date		Tue,29 Jan,2019
 *@date		Fri,19 Feb,2021
 *@date		Mon,22 Feb,2021
 *@date		Tue,23 Feb,2021
 *@date		Sat,29 May,2021
 *@date		Wed,13 Jul,2022
 *@date		Sat,16 Jul,2022
 *@date		Sun,25 Jun,2023
 *
 *@author	Copyright(C)2015-2023 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <math.h>
#include "settings.h"
#include "mapeditor.h"
#include "imagebuilder.h"
#include "form_mainform.h"
#include "mytypes.h"
#include "qrl.h"
#include <QPaintEvent>
#include <QPainter>
#include <QFocusEvent>
#include "xy_.h"
#if defined(DEBUG)
# include <QDateTime>
#endif

void Form_MainForm::paintEvent(_unused QPaintEvent* const e) noexcept
{
  #if defined(DEBUG)
	interval_timer->stop();
  #endif

	const int w = this->width();
	const int h = this->height();
	if (this->needRefresh
		|| (NULL == display_img->DisplayImage())
		|| ((w != display_img->DisplayImage()->width()) || (h != display_img->DisplayImage()->height())
			|| (display_img->scaling() != this->old_screen.scaling)
			|| (this->cur_screen.ofs != this->old_screen.ofs)))
	{
		buildImage(MapEditor_Type::MOUSE_NONE);
	} else {
	  #if defined(DEBUG)
		const qint64 ct = QDateTime::currentMSecsSinceEpoch();
		const qint64 diff = ct - interval_timer_basetime;
		if (250 <= diff) {
			interval_timer_basetime = ct;

			blink_color = blink_counter * 255 / 3;
			blink_counter += blink_counter_direction;
			if (3 <= blink_counter) {
				blink_counter_direction = -1;
			} else if (blink_counter <= -2) {
				blink_counter_direction = +1;
			}

			if (-1 <= blink_counter) {
				const XY_<int_fast32_t> mouse_ptr = {
					.x = -1,
					.y = -1,
				};
				this->needRefresh = true;
				buildImage(MapEditor_Type::MOUSE_NONE, focus_addr, mouse_ptr, NULL);
			}
		}
	  #endif
	}

	if (NULL != display_img->DisplayImage()) {
		QPainter widgetPainter(this);
		widgetPainter.drawImage(0, 0, *(display_img->DisplayImage()));
	}

  #if defined(DEBUG)
	interval_timer->start(250);
  #endif
	return;
}

void Form_MainForm::focusInEvent(_unused QFocusEvent* const e) noexcept
{
	const XY_<int_fast32_t> mouse_ptr = {
		.x = -1,
		.y = -1,
	};
	this->needRefresh = true;
	buildImage(MapEditor_Type::MOUSE_NONE, focus_addr, mouse_ptr, NULL);
	return;
}

void Form_MainForm::scale_changed(float value) noexcept
{
	display_img->Set_scaling(value);
	buildImage(MapEditor_Type::MOUSE_NONE);
	return;
}

void Form_MainForm::position_changed_x(int value) noexcept
{
	this->cur_screen.ofs.x = value;
	buildImage(MapEditor_Type::MOUSE_NONE);
	return;
}

void Form_MainForm::position_changed_y(int value) noexcept
{
	this->cur_screen.ofs.y = value;
	buildImage(MapEditor_Type::MOUSE_NONE);
	return;
}

void Form_MainForm::select_form_treeitem(enum Settings::EditorCommand::EditorCommand_TYPE mode_arg, const QRL::QRLChipLibrary* const chip) noexcept
{
	mode = mode_arg;
	mapeditor->Set_SelectedLibraryChip(chip);

	const XY_<int_fast32_t> mouse_ptr = {
		.x = -1,
		.y = -1,
	};
	buildImage(MapEditor_Type::MOUSE_NONE, focus_addr, mouse_ptr, NULL);
	return;
}
// [ End of File ]
