/**@file
 *
 *@brief	QRL Maker
 *@date		Sat,17 Oct,2015
 *@date		Thu,22 Oct,2015 - Fri,23 Oct,2015
 *@date		Mon,26 Oct,2015 - Wed,28 Oct,2015
 *@date		Sat,31 Oct,2015
 *@date		Thu,11 Feb,2016
 *@date		Sun,09 Jul,2017
 *@date		Thu,27 Jul,2017
 *@date		Sat,17 Mar,2018
 *@date		Sat,24 Mar,2018
 *@date		Mon,24 Dec,2018
 *@date		Fri,28 Dec,2018
 *@date		Sat,29 Dec,2018
 *@date		Sun,30 Dec,2018
 *@date		Fri,25 Jan,2019
 *@date		Tue,29 Jan,2019
 *@date		Wed,30 Jan,2019
 *@date		Sun,27 Dec,2020
 *@date		Wed,17 Feb,2021
 *@date		Fri,19 Feb,2021
 *@date		Mon,22 Feb,2021
 *@date		Tue,23 Feb,2021
 *@date		Sat,29 May,2021
 *@date		Sun,30 May,2021
 *@date		Thu,03 Jun,2021
 *@date		Fri,04 Jun,2021
 *@date		Sat,05 Jun,2021
 *@date		Wed,13 Jul,2022
 *@date		Fri,28 Apr,2023
 *@date		Sat,29 Apr,2023
 *@date		Sun,25 Jun,2023
 *
 *@author	Copyright(C)2015-2023 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include "settings.h"
#include <cstdint>
#include "qrlmaker.h"
#include "mainwindow.h"
#include "mapeditor.h"
#include "form_mainform.h"
#include "qrl.h"
#include "qrlmap.h"
#include <QTranslator>
#include <QString>
#include <QStringList>
#include <QDateTime>
#include "xy_.h"

bool Form_MainForm::action_new(void) noexcept
{
	QString msg = tr("New");

	mapeditor->QRLMap_().clear();
	const int_fast8_t ptr = mapeditor->QRLMap_().reset_undo(msg);
	mapeditor->SelectedList_()->clear();

	mainwindow->clear_edited(ptr);
	this->needRefresh = true;
	buildImage(MapEditor_Type::MOUSE_NONE);

	{
		QDateTime dt = QDateTime::currentDateTime();
		QString str = dt.toString(QObject::tr("ddd,dd MMM,yyyy hh:mm:ss")) + " " + msg;
		mainwindow->set_statusBar1(str);
	}
	return true;
}

bool Form_MainForm::action_open(QString& filename) noexcept
{
	bool ret = true;
	try {
		ret = mapeditor->QRLMap_().load(filename);
	}
	catch (QStringList errmsg) {
		mainwindow->Write_ErrorConsole(errmsg);
		ret = false;
	}

	{
		QString msg = tr("Open");

		const int_fast8_t ptr = mapeditor->QRLMap_().reset_undo(msg);
		mapeditor->SelectedList_()->clear();

		mainwindow->clear_edited(ptr);
		this->needRefresh = true;
		buildImage(MapEditor_Type::MOUSE_NONE);

		{
			QDateTime dt = QDateTime::currentDateTime();
			QString str = dt.toString(QObject::tr("ddd,dd MMM,yyyy hh:mm:ss")) + " " + msg;
			mainwindow->set_statusBar1(str);
		}
	}
	return ret;
}

bool Form_MainForm::action_import(QString& filename) noexcept
{
	bool ret = true;
	try {
		ret = qrlmaker->Clipboard_()->load(filename);
	}
	catch (QStringList errmsg) {
		mainwindow->Write_ErrorConsole(errmsg);
		ret = false;
	}

	{
		qrlmaker->Clipboard_()->reallocate(NULL);
		qrlmaker->Clipboard_()->reset_ofs();

		mainwindow->select_form_treeitem(Settings::EditorCommand::PASTE);

		buildImage(MapEditor_Type::MOUSE_NONE);

		{
			QDateTime dt = QDateTime::currentDateTime();
			QString str = dt.toString(QObject::tr("ddd,dd MMM,yyyy hh:mm:ss")) + " " + tr("Import");
			mainwindow->set_statusBar1(str);
		}
	}
	return ret;
}

bool Form_MainForm::action_save(QString& filename) noexcept
{
	bool ret = false;
	const bool ret_saveqrlmap = mapeditor->QRLMap_().save(filename);
	if (ret_saveqrlmap) {
		{	// Save The Image
			QString image_filename = filename;
			if (image_filename.endsWith("." + Settings::QRLData.File.QRLMap_Ext)) {
				image_filename.chop(1 + Settings::QRLData.File.QRLMap_Ext.length());
			}
			image_filename += "." + Settings::QRLData.File.QRLMap_Image_Ext;

			save_img->Set_scaling(1.0);
			save_img->CalcScreenParam();
			save_img->ResetImage();
			save_img->MakeBaseImage(-1);
			save_img->MakeSaveImage();

			const bool ret_saveimage = save_img->QRLMap_SaveImage()->save(image_filename, qPrintable(Settings::QRLData.File.QRLMap_Image_Ext), 0);
			if (ret_saveimage) {
				ret = true;
				mainwindow->clear_edited(mapeditor->QRLMap_().get_undo_ptr());

				QDateTime dt = QDateTime::currentDateTime();
				QString str = dt.toString(QObject::tr("ddd,dd MMM,yyyy hh:mm:ss")) + " " + tr("Save");
				mainwindow->set_statusBar1(str);

			} else {
				QDateTime dt = QDateTime::currentDateTime();
				QString str = dt.toString(QObject::tr("ddd,dd MMM,yyyy hh:mm:ss")) + " " + tr("Failed to save image.");
				mainwindow->set_statusBar1(str);
			}
		}
	} else {
		QDateTime dt = QDateTime::currentDateTime();
		QString str = dt.toString(QObject::tr("ddd,dd MMM,yyyy hh:mm:ss")) + " " + tr("Failed to save QRL map.");
		mainwindow->set_statusBar1(str);
	}
	return ret;
}
// [ End of File ]
