/**@file
 *
 *@brief	QRL Maker
 *@date		Fri,28 Dec,2018
 *@date		Sat,29 Dec,2018
 *@date		Sun,27 Jan,2019
 *@date		Tue,29 Jan,2019
 *@date		Fri,19 Feb,2021
 *@date		Tue,23 Feb,2021
 *@date		Sat,29 May,2021
 *@date		Fri,28 Apr,2023
 *
 *@author	Copyright(C)2018-2023 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <cstdint>
#include <math.h>
#include "settings.h"
#include "form_mainform.h"
#include "mytypes.h"
#include <QScrollBar>
#include "xy_.h"

void Form_MainForm::relocation_scrollbar(void) noexcept
{
	const XY_<int> sp = {
		.x = mainwindow->get_horizontalScrollBar(),
		.y = mainwindow->get_verticalScrollBar(),
	};

	if (this->focus_addr.y < sp.y) {
		mainwindow->set_verticalScrollBar(this->focus_addr.y);
	}

	const int_fast16_t limit_y = ((this->height() - display_img->ScreenParam()->bs.y) / display_img->ScreenParam()->scs.y - 1);
	if ((sp.y + limit_y) <= this->focus_addr.y) {
		mainwindow->set_verticalScrollBar(this->focus_addr.y - limit_y);
	}

	if (this->focus_addr.x < sp.x) {
		mainwindow->set_horizontalScrollBar(this->focus_addr.x);
	}

	const int_fast16_t limit_x = ((this->width() - display_img->ScreenParam()->bs.x) / display_img->ScreenParam()->scs.x - 1);
	if ((sp.x + limit_x) <= this->focus_addr.x) {
		mainwindow->set_horizontalScrollBar(this->focus_addr.x - limit_x);
	}

	return;
}
// [ End of File ]
