/**@file
 *
 *@brief	QRL Maker
 *@date		Sun,31 May,2015 - Tue,08 Sep,2015
 *@date		Fri,11 Sep,2015 - Sat,19 Sep,2015
 *@date		Sun,20 Sep,2015
 *@date		Sat,03 Oct,2015 - Sat,10 Oct,2015
 *@date		Tue,13 Oct,2015 - Thu,15 Oct,2015
 *@date		Sun,18 Oct,2015
 *@date		Thu,22 Oct,2015 - Sun,25 Oct,2015
 *@date		Mon,26 Oct,2015
 *@date		Wed,28 Oct,2015
 *@date		Sat,31 Oct,2015
 *@date		Sat,07 Nov,2015
 *@date		Mon,11 Jan,2016
 *@date		Thu,11 Feb,2016 - Sun,14 Feb,2016
 *@date		Sun,16 Apr,2017
 *@date		Sun,09 Jul,2017
 *@date		Sat,15 Jul,2017
 *@date		Sun,16 Jul,2017 - Mon,17 Jul,2017
 *@date		Sun,23 Jul,2017
 *@date		Wed,26 Jul,2017
 *@date		Thu,27 Jul,2017
 *@date		Sat,05 Aug,2017
 *@date		Sat,17 Mar,2018
 *@date		Mon,16 Jul,2018
 *@date		Sat,21 Jul,2018
 *@date		Sat,27 Oct,2018
 *@date		Fri,23 Nov,2018
 *@date		Tue,27 Nov,2018 - Thu,29 Nov,2018
 *@date		Sat,15 Dec,2018
 *@date		Fri,21 Dec,2018
 *@date		Sat,22 Dec,2018
 *@date		Mon,24 Dec,2018
 *@date		Fri,28 Dec,2018
 *@date		Sat,29 Dec,2018
 *@date		Sun,30 Dec,2018
 *@date		Mon,31 Dec,2018
 *@date		Mon,21 Jan,2019
 *@date		Fri,25 Jan,2019
 *@date		Sun,27 Jan,2019
 *@date		Tue,29 Jan,2019
 *@date		Thu,31 Jan,2019
 *@date		Wed,17 Feb,2021
 *@date		Tue,23 Feb,2021
 *@date		Sat,29 May,2021
 *@date		Thu,07 Jul,2022
 *@date		Wed,13 Jul,2022
 *@date		Sat,29 Apr,2023
 *@date		Sun,25 Jun,2023
 *
 *@author	Copyright(C)2015-2023 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <assert.h>
#include <cstdint>
#include <stdio.h>
#include "settings.h"
#include "mapeditor.h"
#include "imagebuilder.h"
#include "qrl.h"
#include "qrlmap.h"
#include <QPainter>
#include <QImage>
#include <QRgb>
#include <QPen>
#include <QColor>
#include <QFont>

void ImageBuilder_QRLMap_Base::ResetImage(void) noexcept
{
	if (NULL != img_base) {
		delete img_base;
		img_base = NULL;
	}

	return;
}

void ImageBuilder_QRLMap_Base::MakeBaseImage(const int blink_color) noexcept
{
	const int_fast32_t mrw = (static_cast<int_fast32_t>(ScreenParam()->scs.x) * Settings::BuildImage.Chip.Count.x + static_cast<int_fast32_t>(Settings::BuildImage.Chip.GapSize * scaling()));
	const int_fast32_t mrh = (static_cast<int_fast32_t>(ScreenParam()->scs.y) * Settings::BuildImage.Chip.Count.y + static_cast<int_fast32_t>(Settings::BuildImage.Chip.GapSize * scaling()));
	if (NULL == img_base) {
	  #if Q_PROCESSOR_WORDSIZE < 8
		img_base = new(std::nothrow) QImage((mrw + 1), (mrh + 1), QImage::Format_RGB444);
	  #else
		img_base = new(std::nothrow) QImage((mrw + 1), (mrh + 1), QImage::Format_RGB32);
	  #endif
		assert (NULL != img_base);
	}

	QPainter painter(img_base);
	painter.setRenderHint(QPainter::Antialiasing, false);

	{
		const uint_fast8_t r = Settings::BuildImage.Color.Background.R;
		const uint_fast8_t g = Settings::BuildImage.Color.Background.G;
		const uint_fast8_t b = Settings::BuildImage.Color.Background.B;
		const QRgb color = qRgb(r, g, b);
		img_base->fill(color);
	}

	{
		const uint_fast8_t r = Settings::BuildImage.Color.Line.R;
		const uint_fast8_t g = Settings::BuildImage.Color.Line.G;
		const uint_fast8_t b = Settings::BuildImage.Color.Line.B;
		painter.setPen(QPen(QColor(r, g, b), 1, Qt::SolidLine));

		int_fast32_t lx = 0;
		for (int_fast16_t nx = 0; nx <= Settings::BuildImage.Chip.Count.x; ++nx) {
			painter.drawLine(lx, 0, lx, mrh);
			painter.drawLine((lx + ScreenParam()->gap.x), 0, (lx + ScreenParam()->gap.x), mrh);
			lx += ScreenParam()->scs.x;
		}
		int_fast32_t ly = 0;
		for (int_fast16_t ny = 0; ny <= Settings::BuildImage.Chip.Count.y; ++ny) {
			painter.drawLine(0, ly, mrw, ly);
			painter.drawLine(0, (ly + ScreenParam()->gap.y), mrw, (ly + ScreenParam()->gap.y));
			ly += ScreenParam()->scs.y;
		}
	}

	{
		const uint_fast8_t r = Settings::BuildImage.Color.ChipText.R;
		const uint_fast8_t g = Settings::BuildImage.Color.ChipText.G;
		const uint_fast8_t b = Settings::BuildImage.Color.ChipText.B;
		painter.setPen(QPen(QColor(r, g, b), 1, Qt::SolidLine));
		QFont ft = painter.font();
		ft.setPointSizeF(Settings::BuildImage.Font.ChipTextPointSize * scaling());
		painter.setFont(ft);
	}
	const struct QRL::ChipAddrXY ofs = {
		.x = 0,
		.y = 0,
	};
	for (QRL::QRLChipNumber i = 0; i < mapeditor->QRLMap().maxlist(); ++i) {
		const QRL::QRLChip* const ptr = mapeditor->QRLMap().ptr(i);
		if (NULL == ptr) {
			break;
		}
		if (ptr->chip_number <= 0) {
			continue;
		}

		draw_chip_wo_arrow(painter, blink_color, ofs, ptr);
	}
	for (QRL::QRLChipNumber i = 0; i < mapeditor->QRLMap().maxlist(); ++i) {
		const QRL::QRLChip* const ptr = mapeditor->QRLMap().ptr(i);
		if (NULL == ptr) {
			break;
		}
		if (ptr->chip_number <= 0) {
			continue;
		}

		draw_chip_only_arrow(painter, ofs, ptr);
	}

	return;
}

// [ End of File ]
