/**@file
 *
 *@brief	QRL Maker
 *@date		Wed,30 Jan,2019
 *@date		Tue,23 Feb,2021
 *@date		Sat,29 May,2021
 *@date		Thu,07 Jul,2022
 *@date		Wed,13 Jul,2022
 *@date		Sat,29 Apr,2023
 *
 *@author	Copyright(C)2019-2023 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <assert.h>
#include <cstdint>
#include <stdio.h>
#include "settings.h"
#include "imagebuilder.h"
#include <QPainter>
#include <QImage>
#include <QRgb>
#include <QPen>
#include <QColor>
#include <QFont>
#include "xy_.h"

void ImageBuilder_QRLMap_SaveImage::MakeSaveImage(void) noexcept
{
	if ((NULL != img_save) && ((img_base->width() != img_save->width()) || (img_base->height() != img_save->height()))) {
		delete img_save;
		img_save = NULL;
	}
	if (NULL == img_save) {
		const XY_<int_fast32_t> screen_size = {
			.x = (ScreenParam()->gauge.x + img_base->width()),
			.y = (ScreenParam()->gauge.y + img_base->height()),
		};
	  #if Q_PROCESSOR_WORDSIZE < 8
		img_save = new(std::nothrow) QImage(screen_size.x, screen_size.y, QImage::Format_RGB444);
	  #else
		img_save = new(std::nothrow) QImage(screen_size.x, screen_size.y, QImage::Format_RGB32);
	  #endif
		assert (NULL != img_save);
	}

	QPainter imagePainter(img_save);
	{
		const uint_fast8_t r = Settings::BuildImage.Color.Background.R;
		const uint_fast8_t g = Settings::BuildImage.Color.Background.G;
		const uint_fast8_t b = Settings::BuildImage.Color.Background.B;
		const QRgb color = qRgb(r, g, b);
		img_save->fill(color);
	}

	{ // Show Chip-Map Image
		imagePainter.drawImage(ScreenParam()->gauge.x, ScreenParam()->gauge.y, *img_base);
	}

	{ // Show Gauge
		const uint_fast8_t r = Settings::BuildImage.Color.GaugeText.R;
		const uint_fast8_t g = Settings::BuildImage.Color.GaugeText.G;
		const uint_fast8_t b = Settings::BuildImage.Color.GaugeText.B;
		imagePainter.setPen(QPen(QColor(r, g, b), 1, Qt::SolidLine));
		QFont ft = imagePainter.font();
		ft.setPointSize(Settings::BuildImage.Font.GaugeTextPointSize);
		const QFontMetrics fm(ft);
		imagePainter.setFont(ft);

		const int_fast16_t sizex = (fm.maxWidth() * Settings::BuildImage.Font.GaugeTextLength);
		const int_fast16_t sizey = (fm.height() * 1);
		const int_fast16_t ofs_x = (ScreenParam()->gap.x + ScreenParam()->core.x / 2) - (sizex / 2);
		const int_fast16_t ofs_y = (ScreenParam()->gap.y + ScreenParam()->core.y / 2) - (sizey / 2);
		const int_fast16_t bs_x = static_cast<int_fast16_t>(ScreenParam()->bs.x * scaling());
		const int_fast16_t bs_y = static_cast<int_fast16_t>(ScreenParam()->bs.y * scaling());
		const int_fast16_t step_nx = (1.0 < scaling()) ? 1 : static_cast<int_fast16_t>(nearbyint(1.0 / scaling()));
		const int_fast16_t step_ny = (1.0 < scaling()) ? 1 : static_cast<int_fast16_t>(nearbyint(1.0 / scaling()));
		for (int_fast16_t nx = 0; nx < Settings::BuildImage.Chip.Count.x; nx += step_nx) {
			const int_fast32_t px = static_cast<int_fast32_t>(ScreenParam()->gauge.x) + (nx * bs_x) + ofs_x;
			const int_fast32_t py = 0;
			const QString text = QString("%1").arg((nx + 1), Settings::BuildImage.Font.GaugeTextLength, 10, QChar(' '));
			imagePainter.drawText(px, py, sizex, ScreenParam()->gauge.x, (Qt::AlignBottom | Qt::AlignHCenter), text);
		}
		for (int_fast16_t ny = 0; ny < Settings::BuildImage.Chip.Count.y; ny += step_ny) {
			const int_fast32_t px = 0;
			const int_fast32_t py = static_cast<int_fast32_t>(ScreenParam()->gauge.y) + (ny * bs_y) + ofs_y;
			const QString text = QString("%1").arg((ny + 1), Settings::BuildImage.Font.GaugeTextLength, 10, QChar(' '));
			imagePainter.drawText(px, py, ScreenParam()->gauge.y, sizey, (Qt::AlignVCenter | Qt::AlignRight), text);
		}
	}

	return;
}
// [ End of File ]
