/**@file
 *
 *@brief	QRL Maker
 *@date		Sun,10 Aug,2014
 *@date		Fri,11 Sep,2015
 *@date		Sun,11 Oct,2015
 *@date		Sun,18 Oct,2020
 *@date		Mon,16 Nov,2020
 *@date		Tue,17 Nov,2020
 *@date		Wed,18 Nov,2020
 *@date		Thu,19 Nov,2020
 *@date		Sun,27 Dec,2020
 *@date		Thu,18 Feb,2021
 *@date		Fri,28 May,2021
 *@date		Sat,29 May,2021
 *@date		Sat,18 Feb,2023
 *@date		Sat,22 Apr,2023
 *@date		Sat,27 May,2023
 *
 *@author	Copyright(C)2014-2023 G-HAL. All rights reserved.
 *@note	Bibliography: Copyright(C)2015 soramimi. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <assert.h>
#include "settings.h"
#include "mystyle.h"
#include "qrlmaker.h"
#include <QCoreApplication>
#include <QApplication>
#include <QSettings>
#include <QDir>
#if QT_VERSION >= QT_VERSION_CHECK(6, 0, 0)
#else
# include <QTextCodec>
#endif
#include <QStringList>
#include <QTranslator>
#include <QLibraryInfo>
#include <QLocale>
#include <QFileInfo>
#include <QStandardPaths>



#if defined(DEBUG)
QRLMaker* debug_class = NULL;
#endif

int main(int argc, char *argv[]) noexcept
{
	QApplication app(argc, argv);

	QStringList filelist;
	filelist.clear();

	{
	  #if defined(Q_OS_WIN)
		Settings::AppConfig.set_HomePath(QStandardPaths::writableLocation(QStandardPaths::HomeLocation) + "/" + Settings::AppConfig.get_OrgName() + "/");
	  #else
		QSettings cfg(QSettings::IniFormat, QSettings::UserScope, Settings::AppConfig.get_OrgName(), Settings::AppConfig.get_AppName());
		Settings::AppConfig.set_HomePath(QFileInfo(cfg.fileName()).absolutePath() + "/");
	  #endif
		if (2 <= argc) {
			int i = 1;

			QDir dir1(argv[i]);
			if (dir1.exists()) {
				Settings::AppConfig.set_HomePath(QString(argv[i]));
				++i;
			}

			for (; i < argc; ++i) {
				filelist.append(argv[i]);
			}
		}

		Settings::AppConfig.set_DefaultPath(Settings::AppConfig.get_HomePath() + "/" + Settings::QRLData.File.DataDir);
		QDir dir_d(Settings::AppConfig.get_DefaultPath());
		if (!dir_d.exists()) {
			if (argc <= 1) {
				dir_d.mkdir(Settings::AppConfig.get_DefaultPath());
			}
		}
		if (!dir_d.exists()) {
			Settings::AppConfig.set_DefaultPath(Settings::AppConfig.get_HomePath());
		}
	}

	{
		QCoreApplication::setOrganizationName(Settings::AppConfig.get_OrgName());
		QCoreApplication::setApplicationName(Settings::AppConfig.get_AppName());
		Settings::ini = new(std::nothrow) QSettings(Settings::AppConfig.get_HomePath() + Settings::AppConfig.get_AppName() + ".ini", QSettings::IniFormat);
		assert (NULL != Settings::ini);
	  #if QT_VERSION >= QT_VERSION_CHECK(6, 0, 0)
	  #else
		Settings::ini->setIniCodec(QTextCodec::codecForName("UTF-8"));
	  #endif

		bool sync = false;

		const QString author_key = "Author";
		const QString author_value = "Copyright(C)2014 G-HAL, Copyright(C)1999 THM, All rights reserved.";

		Settings::ini->beginGroup(Settings::AppConfig.get_AppName());

		const QString msg = Settings::ini->value(author_key, "").toString();
		if (msg != author_value) {
			Settings::ini->setValue(author_key, author_value);
			sync = true;
		}

		Settings::ini->endGroup();

		if (sync) {
			Settings::ini->sync();
		}
	}

	QTranslator default_translator;
	QTranslator translator;
	{
		bool ret_tr = false;

		ret_tr = default_translator.load(QLocale::system(), "qt", "_");
		if (!ret_tr) {
			ret_tr = default_translator.load(QLocale::system(), "qt", "_", "translations");
		}
		if (!ret_tr) {
			ret_tr = default_translator.load(QLocale::system(), "qt", "_", QApplication::applicationDirPath());
		}
		if (!ret_tr) {
			ret_tr = default_translator.load(QLocale::system(), "qt", "_", QApplication::applicationDirPath() + "/translations");
		}
		if (!ret_tr) {
			ret_tr = default_translator.load(QLocale::system(), "qt", "_", QLibraryInfo::location(QLibraryInfo::TranslationsPath));
		}
		if (!ret_tr) {
		} else {
			app.installTranslator(&default_translator);
		}
	}
	{
		bool ret_tr = false;

		ret_tr = translator.load(QLocale::system(), Settings::AppConfig.get_AppName(), "_");
		if (!ret_tr) {
			ret_tr = translator.load(QLocale::system(), Settings::AppConfig.get_AppName(), "_", "translations");
		}
		if (!ret_tr) {
			ret_tr = translator.load(QLocale::system(), Settings::AppConfig.get_AppName(), "_", QApplication::applicationDirPath());
		}
		if (!ret_tr) {
			ret_tr = translator.load(QLocale::system(), Settings::AppConfig.get_AppName(), "_", QApplication::applicationDirPath() + "/translations");
		}
		if (!ret_tr) {
		} else {
			app.installTranslator(&translator);
		}
	}

	QStyle* const style = new(std::nothrow) MyStyle();
	assert (NULL != style);
	QApplication::setStyle(style);

	QRLMaker* qrlmaker;
	try {
		qrlmaker = new(std::nothrow) QRLMaker(&filelist);
		assert (NULL != qrlmaker);
	  #if defined(DEBUG)
		debug_class = qrlmaker;
	  #endif
	}
	catch (QStringList msg) {
		return -1;
	}

	const bool ret = app.exec();

	delete qrlmaker;

	delete Settings::ini;
	return ret;
}
// [ End of File ]
