/**@file
 *
 *@brief	QRL Maker
 *@date		Sun,10 Aug,2014
 *@date		Thu,28 May,2015 - Sun,31 May,2015
 *@date		Tue,08 Sep,2015
 *@date		Fri,11 Sep,2015 - Tue,15 Sep,2015
 *@date		Sun,20 Sep,2015 - Mon,21 Sep,2015
 *@date		Mon,19 Oct,2015
 *@date		Thu,22 Oct,2015
 *@date		Sat,31 Oct,2015
 *@date		Sun,10 Jan,2016
 *@date		Sun,16 Apr,2017
 *@date		Sat,03 Mar,2018
 *@date		Sat,24 Nov,2018
 *@date		Tue,01 Jan,2019
 *@date		Sat,25 Jan,2020
 *@date		Sun,27 Dec,2020
 *@date		Sat,30 Jan,2021
 *@date		Mon,22 Feb,2021
 *@date		Tue,23 Feb,2021
 *@date		Thu,25 Feb,2021
 *@date		Fri,26 Feb,2021
 *@date		Sat,29 May,2021
 *@date		Thu,03 Jun,2021
 *@date		Sun,12 Dec,2021
 *
 *@author	Copyright(C)2014-2021 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <assert.h>
#include <string.h>
#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "form_mainform.h"
#include <QCoreApplication>
#include <QString>
#include <QTranslator>
#include <QMessageBox>
#include "revision_header.h"

void MainWindow::on_action_About_triggered(void) noexcept
{
	const QString qMsg = tr("<H3>QRL Maker</H3><BR>"
							"Copyright(C)2014 G-HAL<BR>"
							"Copyright(C)1999 THM<BR>"
							"License : 3terms BSD License<BR>"
							"All rights reserved.<BR>");
	const QString about_msg = QString("%1<BR>%2<BR>").arg(qMsg).arg(rcsid);
	QMessageBox::about(this, tr("QRL Maker"), about_msg);
	return;
}

void MainWindow::on_action_AboutQt_triggered(void) noexcept
{
	QMessageBox::aboutQt(this);
	return;
}

bool MainWindow::question_triggered(void) noexcept
{
	QMessageBox msgBox;
	msgBox.setTextFormat(Qt::RichText);
	msgBox.setText(tr("These changes will be lost.<BR><H3>Are you sure you want to do?</H3>"));
	msgBox.setStandardButtons(QMessageBox::Ok | QMessageBox::Cancel);
	msgBox.setDefaultButton(QMessageBox::Cancel);

	const int ret = msgBox.exec();

	return (QMessageBox::Ok == ret);
}

void MainWindow::on_action_Close_triggered(void) noexcept
{
	if (is_edited()) {
		const bool ret = question_triggered();
		if (!ret) {
			return;
		}
	} else if (qrlmaker->num_of_window() <= 1) {
		QMessageBox msgBox;
		msgBox.setTextFormat(Qt::RichText);
		msgBox.setText(tr("<H3>Really Quit?</H3>"));
		msgBox.setStandardButtons(QMessageBox::Ok | QMessageBox::Cancel);
		msgBox.setDefaultButton(QMessageBox::Ok);

		const int ret = msgBox.exec();

		if (QMessageBox::Ok != ret) {
			return;
		}
	}
	this->close();
	return;
}

void MainWindow::on_action_Quit_triggered(void) noexcept
{
	bool e = false;
	for (auto itr = qrlmaker->window_begin(); itr != qrlmaker->window_end(); ++itr) {
		if ((*itr)->is_edited()) {
			e = true;
			break;
		}
	}
	if (e) {
		const bool ret = question_triggered();
		if (!ret) {
			return;
		}
	} else {
		QMessageBox msgBox;
		msgBox.setTextFormat(Qt::RichText);
		msgBox.setText(tr("<H3>Really Quit?</H3>"));
		msgBox.setStandardButtons(QMessageBox::Ok | QMessageBox::Cancel);
		msgBox.setDefaultButton(QMessageBox::Ok);

		const int ret = msgBox.exec();

		if (QMessageBox::Ok != ret) {
			return;
		}
	}
	QCoreApplication::quit();
	return;
}
// [ End of File ]
