/**@file
 *
 *@brief	QRL Maker
 *@date		Thu,19 Nov,2020 - Fri,20 Nov,2020
 *@date		Sat,21 Nov,2020
 *@date		Wed,02 Dec,2020
 *@date		Tue,23 Feb,2021
 *@date		Thu,25 Feb,2021
 *@date		Sat,29 May,2021
 *@date		Wed,13 Jul,2022
 *@date		Sat,16 Jul,2022
 *@date		Sat,18 Feb,2023
 *@date		Sat,25 Feb,2023
 *
 *@author	Copyright(C)2020-2023 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <assert.h>
#include "settings.h"
#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <QSettings>
#include <QString>
#include <QList>
#include <QPoint>
#include <QSize>

void MainWindow::on_actionSave_Settings_triggered(void) noexcept
{
	Settings::ini->beginGroup(Settings::AppConfig.get_AppName());

	Settings::ini->setValue(Settings::SettingsKey.mainwindow_settings, true);

	Settings::ini->setValue(Settings::SettingsKey.mainwindow_DoubleClickInterval, Settings::Mouse.get_DoubleClickInterval());
	Settings::ini->setValue(Settings::SettingsKey.mainwindow_DragScrollTimer, Settings::Mouse.get_DragScrollTimer());

	// Settings::ini->setValue(Settings::SettingsKey.mainwindow_geometry, saveGeometry());
	Settings::ini->setValue(Settings::SettingsKey.mainwindow_pos, pos());
	Settings::ini->setValue(Settings::SettingsKey.mainwindow_size, size());

	Settings::ini->setValue(Settings::SettingsKey.mainwindow_centralwidget_size      , ui->centralwidget      ->size());
	//Settings::ini->setValue(Settings::SettingsKey.mainwindow_gridLayout              , ui->gridLayout         ->size());
	//Settings::ini->setValue(Settings::SettingsKey.mainwindow_gridLayout_0G           , ui->gridLayout_0G      ->size());
	Settings::ini->setValue(Settings::SettingsKey.mainwindow_splitter_1V_size        , ui->splitter_1V        ->size());
	Settings::ini->setValue(Settings::SettingsKey.mainwindow_splitter_2H_size        , ui->splitter_2H        ->size());
	Settings::ini->setValue(Settings::SettingsKey.mainwindow_Form_TreeWidget_size    , ui->form_treewidget    ->size());
	Settings::ini->setValue(Settings::SettingsKey.mainwindow_layoutWidget            , ui->layoutWidget       ->size());
	//Settings::ini->setValue(Settings::SettingsKey.mainwindow_gridLayout_3G           , ui->gridLayout_3G      ->size());
	Settings::ini->setValue(Settings::SettingsKey.mainwindow_form_mainform_size      , ui->form_mainform      ->size());
	//Settings::ini->setValue(Settings::SettingsKey.mainwindow_horizontalLayout        , ui->horizontalLayout   ->size());
	Settings::ini->setValue(Settings::SettingsKey.mainwindow_horizontalSlider_size   , ui->horizontalSlider   ->size());
	Settings::ini->setValue(Settings::SettingsKey.mainwindow_verticalScrollBar_size  , ui->verticalScrollBar  ->size());
	Settings::ini->setValue(Settings::SettingsKey.mainwindow_horizontalScrollBar_size, ui->horizontalScrollBar->size());
	Settings::ini->setValue(Settings::SettingsKey.mainwindow_listWidget_size         , ui->listWidget         ->size());
	Settings::ini->setValue(Settings::SettingsKey.mainwindow_menubar_size            , ui->menubar            ->size());
	Settings::ini->setValue(Settings::SettingsKey.mainwindow_statusbar_size          , ui->statusbar          ->size());
	//Settings::ini->setValue(Settings::SettingsKey.mainwindow_splitter_1V_state, ui->splitter_1V        ->saveState());
	{
		int i = 0;
		for (int size : ui->splitter_1V->sizes() ) {
			Settings::ini->setValue(Settings::SettingsKey.mainwindow_splitter_1V_sizes + QString::number(i), size);
			++i;
		}
	}
	//Settings::ini->setValue(Settings::SettingsKey.mainwindow_splitter_2H_state, ui->splitter_2H        ->saveState());
	{
		int i = 0;
		for (int size : ui->splitter_2H->sizes() ) {
			Settings::ini->setValue(Settings::SettingsKey.mainwindow_splitter_2H_sizes + QString::number(i), size);
			++i;
		}
	}

	Settings::ini->setValue(Settings::SettingsKey.mainwindow_form_mainform_scaling_dB, ui->horizontalSlider->value());

	Settings::ini->setValue(Settings::SettingsKey.dialog_inputdialog_pos , Settings::SettingsCandidates.dialog_inputdialog_pos );
	Settings::ini->setValue(Settings::SettingsKey.dialog_inputdialog_size, Settings::SettingsCandidates.dialog_inputdialog_size);

	Settings::ini->setValue(Settings::SettingsKey.dialog_listdialog_pos , Settings::SettingsCandidates.dialog_listdialog_pos );
	Settings::ini->setValue(Settings::SettingsKey.dialog_listdialog_size, Settings::SettingsCandidates.dialog_listdialog_size);

	{
		const QList<QTreeWidgetItem*> items = ui->form_treewidget->findItems(QString("*"), Qt::MatchWrap | Qt::MatchWildcard | Qt::MatchRecursive);
		for (QList<QTreeWidgetItem*>::const_iterator itr = items.begin(); itr != items.end(); ++itr) {
			if ((*itr)->isExpanded()) {
				Settings::ini->setValue(Settings::SettingsKey.mainwindow_Form_TreeWidget_expanded + (*itr)->data(1, Qt::DisplayRole).toString(), true);
			} else {
				Settings::ini->setValue(Settings::SettingsKey.mainwindow_Form_TreeWidget_expanded + (*itr)->data(1, Qt::DisplayRole).toString(), false);
			}
		}
	}

	Settings::ini->endGroup();

	Settings::ini->sync();
	return;
}

void MainWindow::on_actionReload_Settings_triggered(void) noexcept
{
	Settings::ini->beginGroup(Settings::AppConfig.get_AppName());

	if (Settings::ini->value(Settings::SettingsKey.mainwindow_settings).toBool()) {

		Settings::Mouse.set_DoubleClickInterval(Settings::ini->value(Settings::SettingsKey.mainwindow_DoubleClickInterval).toInt());
		Settings::Mouse.set_DragScrollTimer(Settings::ini->value(Settings::SettingsKey.mainwindow_DragScrollTimer).toInt());

		// restoreGeometry(Settings::ini->value(Settings::SettingsKey.mainwindow_geometry).toByteArray());
		this->resize(Settings::ini->value(Settings::SettingsKey.mainwindow_size).toSize());
		if (qrlmaker->num_of_window() <= 0) {
			this->move(Settings::ini->value(Settings::SettingsKey.mainwindow_pos).toPoint());
		}

		ui->centralwidget      ->resize(Settings::ini->value(Settings::SettingsKey.mainwindow_centralwidget_size      ).toSize());
		//ui->gridLayout         ->resize(Settings::ini->value(Settings::SettingsKey.mainwindow_gridLayout              ).toSize());
		//ui->gridLayout_0G      ->resize(Settings::ini->value(Settings::SettingsKey.mainwindow_gridLayout_0G           ).toSize());
		ui->splitter_1V        ->resize(Settings::ini->value(Settings::SettingsKey.mainwindow_splitter_1V_size        ).toSize());
		ui->splitter_2H        ->resize(Settings::ini->value(Settings::SettingsKey.mainwindow_splitter_2H_size        ).toSize());
		ui->form_treewidget    ->resize(Settings::ini->value(Settings::SettingsKey.mainwindow_Form_TreeWidget_size    ).toSize());
		ui->layoutWidget       ->resize(Settings::ini->value(Settings::SettingsKey.mainwindow_layoutWidget            ).toSize());
		//ui->gridLayout_3G      ->resize(Settings::ini->value(Settings::SettingsKey.mainwindow_gridLayout_3G           ).toSize());
		ui->form_mainform      ->resize(Settings::ini->value(Settings::SettingsKey.mainwindow_form_mainform_size      ).toSize());
		//ui->horizontalLayout   ->resize(Settings::ini->value(Settings::SettingsKey.mainwindow_horizontalLayout        ).toSize());
		ui->horizontalSlider   ->resize(Settings::ini->value(Settings::SettingsKey.mainwindow_horizontalSlider_size   ).toSize());
		ui->verticalScrollBar  ->resize(Settings::ini->value(Settings::SettingsKey.mainwindow_verticalScrollBar_size  ).toSize());
		ui->horizontalScrollBar->resize(Settings::ini->value(Settings::SettingsKey.mainwindow_horizontalScrollBar_size).toSize());
		ui->listWidget         ->resize(Settings::ini->value(Settings::SettingsKey.mainwindow_listWidget_size         ).toSize());
		ui->menubar            ->resize(Settings::ini->value(Settings::SettingsKey.mainwindow_menubar_size            ).toSize());
		ui->statusbar          ->resize(Settings::ini->value(Settings::SettingsKey.mainwindow_statusbar_size          ).toSize());
		//ui->splitter_1V->restoreState(Settings::ini->value(Settings::SettingsKey.mainwindow_splitter_1V_state).toByteArray());
		{
			QList<int> sizes = {};
			for (int i = 0; ; ++i) {
				const int size = Settings::ini->value(Settings::SettingsKey.mainwindow_splitter_1V_sizes + QString::number(i), -1).toInt();
				if (-1 == size) {
					break;
				}
				sizes += size;
			}
			ui->splitter_1V->setSizes(sizes);
		}
		//ui->splitter_2H->restoreState(Settings::ini->value(Settings::SettingsKey.mainwindow_splitter_2H_state).toByteArray());
		{
			QList<int> sizes = {};
			for (int i = 0; ; ++i) {
				const int size = Settings::ini->value(Settings::SettingsKey.mainwindow_splitter_2H_sizes + QString::number(i), -1).toInt();
				if (-1 == size) {
					break;
				}
				sizes += size;
			}
			ui->splitter_2H->setSizes(sizes);
		}

		const double scaling_dB = Settings::ini->value(Settings::SettingsKey.mainwindow_form_mainform_scaling_dB).toDouble();
		{
			ui->horizontalSlider->setValue(scaling_dB);
		}

		Settings::SettingsCandidates.dialog_inputdialog_pos  = Settings::ini->value(Settings::SettingsKey.dialog_inputdialog_pos ).toPoint();
		Settings::SettingsCandidates.dialog_inputdialog_size = Settings::ini->value(Settings::SettingsKey.dialog_inputdialog_size).toSize();

		Settings::SettingsCandidates.dialog_listdialog_pos  = Settings::ini->value(Settings::SettingsKey.dialog_listdialog_pos ).toPoint();
		Settings::SettingsCandidates.dialog_listdialog_size = Settings::ini->value(Settings::SettingsKey.dialog_listdialog_size).toSize();

		{
			const QList<QTreeWidgetItem*> items = ui->form_treewidget->findItems(QString("*"), Qt::MatchWrap | Qt::MatchWildcard | Qt::MatchRecursive);
			for (QList<QTreeWidgetItem*>::const_iterator itr = items.begin(); itr != items.end(); ++itr) {
				if (Settings::ini->value(Settings::SettingsKey.mainwindow_Form_TreeWidget_expanded + (*itr)->data(1, Qt::DisplayRole).toString()).toBool()) {
					(*itr)->setExpanded(true);
				} else {
					(*itr)->setExpanded(false);
				}
			}
		}
	}

	Settings::ini->endGroup();

	return;
}
// [ End of File ]
