/**@file
 *
 *@brief	QRL Maker
 *@date		Thu,02 Nov,2023
 *
 *@author	Copyright(C)2023 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <assert.h>
#include "qrlmaker.h"
#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <QAction>
#include <QString>
#include <QMenu>
#include <QTranslator>
#include "mytypes.h"

void MainWindow::menu_UndoHistory_do(int_fast8_t ptr) noexcept
{
	if (ptr < 0) {
		for (int_fast8_t i = (- ptr); 0 < i; --i) {
			on_action_Undo_triggered();
		}
	} else if (0 < ptr) {
		for (int_fast8_t i = (+ ptr); 0 < i; --i) {
			on_action_Redo_triggered();
		}
	} else {
	}
	return;
}

void MainWindow::menu_UndoHistory_show(void) noexcept
{
	ui->menu_UndoHistory->clear();

	const int_fast8_t undo_count = ui->form_mainform->get_undo_count();
	const int_fast8_t redo_count = ui->form_mainform->get_redo_count();

	for (int_fast8_t ptr = MIN(redo_count, 16); 0 < ptr; --ptr) {
		const QString str = "+ " + ui->form_mainform->get_redo_msg(ptr);
		ui->menu_UndoHistory->addAction(str, this, [=]() {this->menu_UndoHistory_do(+ ptr);} );
	}

	{
		const QString str = "  ";
		ui->menu_UndoHistory->addAction(str, this, [=]() {this->menu_UndoHistory_do(0);} );
	}

	for (int_fast8_t ptr = 1; ptr <= MIN(undo_count, 16); ++ptr) {
		const QString str = "- " + ui->form_mainform->get_undo_msg(ptr);
		ui->menu_UndoHistory->addAction(str, this, [=]() {this->menu_UndoHistory_do(- ptr);} );
	}

	return;
}
// [ End of File ]
