/**@file
 *
 *@brief	QRL Maker
 *@date		Sun,31 May,2015 - Tue,08 Sep,2015
 *@date		Fri,11 Sep,2015
 *@date		Mon,21 Sep,2015
 *@date		Sat,03 Oct,2015 - Mon,12 Oct,2015
 *@date		Tue,13 Oct,2015 - Sun,18 Oct,2015
 *@date		Thu,22 Oct,2015 - Sun,25 Oct,2015
 *@date		Thu,29 Oct,2015
 *@date		Sat,31 Oct,2015
 *@date		Sun,10 Jan,2016 - Mon,11 Jan,2016
 *@date		Thu,11 Feb,2016
 *@date		Sun,09 Jul,2017
 *@date		Sun,16 Jul,2017
 *@date		Sun,23 Jul,2017
 *@date		Wed,26 Jul,2017
 *@date		Thu,27 Jul,2017
 *@date		Sat,17 Mar,2018
 *@date		Fri,23 Nov,2018
 *@date		Tue,27 Nov,2018 - Thu,29 Nov,2018
 *@date		Sat,15 Dec,2018
 *@date		Mon,24 Dec,2018
 *@date		Fri,28 Dec,2018
 *@date		Sat,29 Dec,2018 - Sun,30 Dec,2018
 *@date		Mon,31 Dec,2018
 *@date		Sat,19 Jan,2019
 *@date		Mon,21 Jan,2019
 *@date		Fri,25 Jan,2019
 *@date		Sun,27 Jan,2019
 *@date		Wed,17 Feb,2021
 *@date		Fri,19 Feb,2021
 *@date		Sat,20 Feb,2021
 *@date		Mon,22 Feb,2021
 *@date		Tue,23 Feb,2021
 *@date		Sat,29 May,2021
 *@date		Thu,03 Jun,2021
 *
 *@author	Copyright(C)2015-2021 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef MAPEDITOR_H
#define MAPEDITOR_H

#include <cstdint>
#include "settings.h"
#include "qrlmaker.h"
#include "mapeditor_clipboard.h"
#include "mapeditor_base.h"
#include "qrl.h"
#include "qrlmap.h"
#include "mainwindow.h"

class MapEditor_Base
{
public:
	explicit MapEditor_Base(QRLMaker* const q, MainWindow* const mw) noexcept;
	virtual ~MapEditor_Base(void) noexcept = 0;

	bool edit_argument_of_chip(QRL::QRLChip* const ptr, const QRL::QRLChipLibrary* const chip, uint_fast8_t num) noexcept;

	QRL::QRLChipArrowAddress make_arrowaddress(const QRL::QRLChipLibrary* const chip, const QRL::ChipAddrXY& cur, const QRL::ChipArrow arrow) const noexcept;
	bool set_arrow(QRL::QRLChip* const ptr, const QRL::ChipAddrXY& ofs, const QRL::ChipArrow arrow, bool arrow_mode) noexcept;

protected:
	QRLMaker* qrlmaker;
	MainWindow* mainwindow;

private:
};

class MapEditor : public virtual MapEditor_Base
{
	Q_DECLARE_TR_FUNCTIONS(MapEditor)

public:
	explicit MapEditor(QRLMaker* const q, MainWindow* const mw) noexcept;
	~MapEditor(void) noexcept;

	bool EditCommand(enum Settings::EditorCommand::EditorCommand_TYPE edit_mode, enum MapEditor_Type::MouseMode edit_type, const struct QRL::ChipAddrXY& cur_chipaddr, QRL::ChipArrow arrow, int_fast8_t pointed_argument_num, QString* const msg) noexcept;

	const QRL::QRLMap& QRLMap(void) const noexcept;
	QRL::QRLMap& QRLMap_(void) noexcept;
	enum MapEditor_Type::SimpleCommand SimpleCommandMode(void) const noexcept;
	void Set_SimpleCommand(enum MapEditor_Type::SimpleCommand newmode) noexcept;
	const QRL::QRLChipLibrary* SelectedLibraryChip(void) const noexcept;
	void Set_SelectedLibraryChip(const QRL::QRLChipLibrary* const slc) noexcept;
	const QRL::ChipAddrXY Drag_ChipAddr(void) const noexcept;
	void Set_Drag_ChipAddr(const QRL::ChipAddrXY& newaddr) noexcept;
	void Reset_Drag_ChipAddr(void) noexcept;
	const QRL::QRLChipList* SelectedList(void) const noexcept;
	QRL::QRLChipList* SelectedList_(void) noexcept;
	const MapEditor_ClipBoard* Clipboard4drag(void) const noexcept;
	MapEditor_ClipBoard* Clipboard4drag_(void) noexcept;

protected:

private:
	QRL::QRLMap* qrlmap;

	enum MapEditor_Type::SimpleCommand mode_simplecommand;

	const QRL::QRLChipLibrary* selected_library_chip;

	struct QRL::ChipAddrXY drag_chipaddr;

	QRL::QRLChipList* selected_list;
	QRL::QRLChipList* selected_list_bak;

	MapEditor_ClipBoard* clipboard4drag;
};



inline enum MapEditor_Type::SimpleCommand MapEditor::SimpleCommandMode(void) const noexcept
{
	return mode_simplecommand;
}

inline void MapEditor::Set_SimpleCommand(enum MapEditor_Type::SimpleCommand newmode) noexcept
{
	mode_simplecommand = newmode;
	return;
}

inline const QRL::QRLChipLibrary* MapEditor::SelectedLibraryChip(void) const noexcept
{
	return selected_library_chip;
}
inline void MapEditor::Set_SelectedLibraryChip(const QRL::QRLChipLibrary* const slc) noexcept
{
	selected_library_chip = slc;
	return;
}

inline const QRL::QRLMap& MapEditor::QRLMap(void) const noexcept
{
	return *qrlmap;
}

inline QRL::QRLMap& MapEditor::QRLMap_(void) noexcept
{
	return *qrlmap;
}

inline const QRL::ChipAddrXY MapEditor::Drag_ChipAddr(void) const noexcept
{
	return drag_chipaddr;
}

inline void MapEditor::Set_Drag_ChipAddr(const QRL::ChipAddrXY& newaddr) noexcept
{
	drag_chipaddr.x = newaddr.x;
	drag_chipaddr.y = newaddr.y;
	return;
}

inline void MapEditor::Reset_Drag_ChipAddr(void) noexcept
{
	drag_chipaddr.x = -1;
	drag_chipaddr.y = -1;
	return;
}

inline const QRL::QRLChipList* MapEditor::SelectedList(void) const noexcept
{
	return selected_list;
}

inline QRL::QRLChipList* MapEditor::SelectedList_(void) noexcept
{
	return selected_list;
}

inline const MapEditor_ClipBoard* MapEditor::Clipboard4drag(void) const noexcept
{
	return clipboard4drag;
}

inline MapEditor_ClipBoard* MapEditor::Clipboard4drag_(void) noexcept
{
	return clipboard4drag;
}

#endif // MAPEDITOR_H
// [ End of File ]
