/**@file
 *
 *@brief	G-HAL's library
 *@date		Fri,17 Mar,2000 - Thu,29 Nov,2018
 *@date		Thu,02 Nov,2023
 *@author	Copyright(C)2000-2023 G-HAL. All rights reserved.
 *
 *@note
 *@verbatim
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

* Redistributions of source code must retain the above copyright
notice, this list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

* Neither the name of the copyright holders nor the names of its contributors
may be used to endorse or promote products derived from this software
without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
SUCH DAMAGE.
 *@endverbatim
 */
#ifndef MYTYPES_H
#define MYTYPES_H

#if defined(HAVE_CONFIG_H)
# include	"config.h"
#endif
#include <math.h>



///@name define		ѥ¸
//@{

#define	SLASH()			/

#if defined(__GNUC__)

# if (3 < __GNUC__) || ((3 == __GNUC__) && (1 <= __GNUC_MINOR__))
#  define	COMPILER_SUPPORT_NRVO		///< Named Return Value Optimization б
#  define	COMPILER_NRV(arg)		
#  define	COMPILER_NRVO(arg)		arg
# elif (2 == __GNUC__)
#  define	COMPILER_SUPPORT_NRV		///< Named Return Value б
#  define	COMPILER_NRV(arg)		arg
#  define	COMPILER_NRVO(arg)		
# else
#  define	COMPILER_NRV(arg)		
#  define	COMPILER_NRVO(arg)		arg
# endif

# if !defined(ATTRIBUTE_USED)
#  if !defined(HAVE_CONFIG_H)
#   if (3 < __GNUC__) || ((3 == __GNUC__) && (3 <= __GNUC_MINOR__))
#    define	ATTRIBUTE_USED	__attribute__((used))	///< used б
#   else
#    define	ATTRIBUTE_USED							///< used б
#   endif
#  else
#   if defined(HAVE___ATTRIBUTE__USED)
#    define	ATTRIBUTE_USED	__attribute__((used))	///< used б
#   else
#    define	ATTRIBUTE_USED							///< used б
#   endif
#  endif
# endif

# if !defined(__unused)
#  if !defined(HAVE_CONFIG_H)
#   if (3 < __GNUC__) || ((3 == __GNUC__) && (3 <= __GNUC_MINOR__))
#    define	__unused	__attribute__((__unused__))	///< __unused__ б
#   else
#    define	__unused								///< __unused__ б
#   endif
#  else
#   if defined(HAVE___ATTRIBUTE__UNUSED)
#    define	__unused	__attribute__((__unused__))	///< __unused__ б
#   else
#    define	__unused								///< __unused__ б
#   endif
#  endif
# endif

# if !defined(_unused)
#  if !defined(HAVE_CONFIG_H)
#   if (3 < __GNUC__) || ((3 == __GNUC__) && (4 <= __GNUC_MINOR__))
#    define	_unused	__attribute__((__unused__))	///< ؿΰ __unused__ б
#   else
#    define	_unused								///< ؿΰ __unused__ б
#   endif
#  else
#   if defined(HAVE___ATTRIBUTE__UNUSED_ARG)
#    define	_unused	__attribute__((__unused__))	///< ؿΰ __unused__ б
#   else
#    define	_unused								///< ؿΰ __unused__ б
#   endif
#  endif
# endif

#else	/* defined(__GNUC__) */

# define	COMPILER_NRV(arg)		/* not supported */
# define	COMPILER_NRVO(arg)		arg

# if !defined(HAVE_CONFIG_H)
#  if !defined(__attribute__)
#   define	__attribute__(x)		/* not supported */
#  endif
#  if !defined(__unused)
#   define	__unused				/* not supported */
#  endif
#  if !defined(_unused)
#   define	_unused					/* not supported */
#  endif
# else

#  if !defined(__attribute__)
#   if defined(HAVE___ATTRIBUTE__)
#   else
#    define	__attribute__(x)		/* not supported */
#   endif
#  endif

#  if !defined(__unused)
#   if defined(HAVE___ATTRIBUTE__UNUSED)
#    define	__unused	__attribute__((__unused__))	///< __unused__ б
#   else
#    define	__unused								///< __unused__ б
#   endif
#  endif

#  if !defined(_unused)
#   if defined(HAVE___ATTRIBUTE__UNUSED_ARG)
#    define	_unused	__attribute__((__unused__))	///< ؿΰ __unused__ б
#   else
#    define	_unused								///< ؿΰ __unused__ б
#   endif
#  endif

# endif

#endif	/* defined(__GNUC__) else */


# if !defined(__printflike)
#  if defined(HAVE___ATTRIBUTE____FORMAT____PRINTF__)
#   define __printflike(fmtarg, firstvararg)	__attribute__((__format__ (__printf__, fmtarg, firstvararg)))
#  else
#   define __printflike(fmtarg, firstvararg)
#  endif
# endif

# if !defined(__scanflike)
#  if defined(HAVE___ATTRIBUTE____FORMAT____SCANF__)
#   define __scanflike(fmtarg, firstvararg)		__attribute__((__format__ (__scanf__, fmtarg, firstvararg)))
#  else
#   define __scanflike(fmtarg, firstvararg)
#  endif
# endif

# if !defined(__bounded__)
#  if !defined(HAVE_CONFIG_H)
#   if defined(__OpenBSD__) && ((3 < __GNUC__) || ((3 == __GNUC__) && (2 < __GNUC_MINOR__)) || ((3 == __GNUC__) && (2 == __GNUC_MINOR__) && (3 <= __GNUC_PATCHLEVEL__)))
     // OpenBSD 3.4 ʹߤ __attribute__((__bounded__(,,))) б
     // ޥ OpenBSD ΥСľΤˡĤʤäΤǡ
#   else
#    define	__bounded__(a,b,c)		///< ХåեСեŪ̵
#   endif
#  else
#   if defined(HAVE___ATTRIBUTE__BOUNDED)
#   else
#    define	__bounded__(a,b,c)		///< ХåեСեŪ̵
#   endif
#  endif
# endif

//@}



///@name define		ƥ¸
//@{

	// Хꥢ
	// ա
	//	Ȥ߹߷ϤΣϣӡBSDȤLinuxȤˤǻȤä餱Ȼפ
	// ͡
	//	http://www.nminoru.jp/~nminoru/diary/2006/12.html#2006-12-15
		/**@def MEMORYBARRIER()
		 *	򵡳٥ǽ
		 *@attention
		 *	黻˥åȥ٥ʣʣץ٥ǤϽʤΤա
		 */
		/**@def MEMORYBARRIER_SYNC()
		 *	򵡳٥ǽ  ƤΥ黻˥åñΥ٥ǽ
		 *@attention
		 *	ʣ֡ʣץ֤ǤϽʤΤա
		 */
		/**@def MEMORYBARRIER_READSYNC()
		 *	򵡳٥ǽ  Load  Load 黻˥åñΥ٥ǽ
		 *@attention
		 *	ʣ֡ʣץ֤ǤϽʤΤա
		 */
		/**@def MEMORYBARRIER_WRITESYNC()
		 *	򵡳٥ǽ  Store  Store 黻˥åñΥ٥ǽ
		 *@attention
		 *	ʣ֡ʣץ֤ǤϽʤΤա
		 */
#if defined(__GNUC__)
# define	MEMORYBARRIER()				asm volatile ("" : : : "memory");
# if defined(__i386__) || defined(__amd64__) || defined(__x86_64__) || defined(__ia64__)
#  if defined(__SSE2__) || defined(__amd64__) || defined(__x86_64__) || defined(__ia64__)
#   define	MEMORYBARRIER_SYNC()		asm volatile ("mfence" : : : "memory");
#   define	MEMORYBARRIER_READSYNC()	asm volatile ("lfence" : : : "memory");
#  else
#   define	MEMORYBARRIER_SYNC()		asm volatile ("lock; addl $0,0(%%esp)" : : : "memory");
#   define	MEMORYBARRIER_READSYNC()	asm volatile ("lock; addl $0,0(%%esp)" : : : "memory");
#  endif
#  if defined(__SSE__) || defined(__amd64__) || defined(__x86_64__) || defined(__ia64__)
#   define	MEMORYBARRIER_WRITESYNC()	asm volatile ("sfence" : : : "memory");
#  else
#   define	MEMORYBARRIER_WRITESYNC()	asm volatile ("lock; addl $0,0(%%esp)" : : : "memory");
#  endif
# elif defined(__alpha__)
#   define	MEMORYBARRIER_SYNC()		asm volatile ("mb" : : : "memory");
#   define	MEMORYBARRIER_READSYNC()	asm volatile ("rmb" : : : "memory");
#   define	MEMORYBARRIER_WRITESYNC()	asm volatile ("wmb" : : : "memory");
# elif defined(__sparc64__)
#   define	MEMORYBARRIER_SYNC()		asm volatile ("membar #LoadLoad | #LoadStore | #StoreLoad | #StoreStore" : : : "memory");
#   define	MEMORYBARRIER_READSYNC()	asm volatile ("membar #LoadLoad | #LoadStore" : : : "memory");
#   define	MEMORYBARRIER_WRITESYNC()	asm volatile ("membar #StoreLoad | #StoreStore" : : : "memory");
# elif defined(__sparc__) || defined(__sparc32__)
#   define	MEMORYBARRIER_SYNC()		asm volatile ("stbar" : : : "memory");
#   define	MEMORYBARRIER_READSYNC()	asm volatile ("stbar" : : : "memory");
#   define	MEMORYBARRIER_WRITESYNC()	asm volatile ("stbar" : : : "memory");
# elif defined(__powerpc__) || defined(__powerpc32__) || defined(__powerpc64__)
#   define	MEMORYBARRIER_SYNC()		asm volatile ("sync" : : : "memory");
#   define	MEMORYBARRIER_READSYNC()	asm volatile ("sync" : : : "memory");
#   define	MEMORYBARRIER_WRITESYNC()	asm volatile ("sync" : : : "memory");
# else
#  define	MEMORYBARRIER()				#error "Can't support memory fence."
#  define	MEMORYBARRIER_SYNC()		#error "Can't support memory fence."
#  define	MEMORYBARRIER_READSYNC()	#error "Can't support memory fence."
#  define	MEMORYBARRIER_WRITESYNC()	#error "Can't support memory fence."
# endif
#else	/* defined(__GNUC__) */
# define	MEMORYBARRIER()				#error "Can't support memory fence."
# define	MEMORYBARRIER_SYNC()		#error "Can't support memory fence."
# define	MEMORYBARRIER_READSYNC()	#error "Can't support memory fence."
# define	MEMORYBARRIER_WRITESYNC()	#error "Can't support memory fence."
#endif	/* defined(__GNUC__) else */

//@}



///@name boolean	֡뷿
//@{

#if 0 /* defined(TRUE) */
# undef	TRUE
# undef	FALSE
#endif

#if !defined(FALSE)
# define	FALSE	(0)
# define	TRUE	(~FALSE)
#endif

#if !defined(__cplusplus) && !defined(false)
# define	false	FALSE
# define	true	(~false)
#endif

#if !defined(CORBA_TRUE)
# if defined(__cplusplus)
#  define	CORBA_TRUE	(static_cast<CORBA::Boolean>(1))
#  define	CORBA_FALSE	(static_cast<CORBA::Boolean>(0))
# else
#  define	CORBA_TRUE	(1)
#  define	CORBA_FALSE	(0)
# endif
#endif

//@}



///@name unit	ñ̷
//@{

#if !defined(M_PI)
# if defined(HAVE_MATH_H) || (!defined(HAVE_CONFIG_H) && !defined(_WIN32))
#  include <math.h>
# else
#  define	M_PI		3.141592653589793238
# endif
#endif
#if !defined(M_2PI)
# define		M_2PI	(M_PI * 2.0)
#endif

#if !defined(M_DEGREE)
# define		M_DEGREE	180.0		///< (degree) ȾʬM_PI Ȥ
#endif
#if !defined(M_2DEGREE)
# define		M_2DEGREE	(M_DEGREE * 2.0)	///< (degree)M_2PI Ȥ
#endif

//@}



///@name type	
//@{

#if (!defined(HAVE_BOOL) && defined(HAVE_CONFIG_H)) || (!defined(HAVE_CONFIG_H) && !defined(__cplusplus))
	typedef	int			bool;
#endif

typedef	char			STRING;
typedef	char*			String;
typedef	const char*		constString;

typedef	enum { T = -1, H = -1, X = 1, Z = 1, F = 0, L = 0, } TRISTATE;

#if 0
#if (!defined(__RT_TIME_H__) && defined(HAVE_CONFIG_H))
	typedef	long long	RTIME;
#endif
#endif
#if (!defined(HAVE_SOCKLEN_T) && defined(SIZEOF_SOCKLEN_T) && (SIZEOF_SOCKLEN_T == 0) && defined(HAVE_CONFIG_H)) || (!defined(HAVE_CONFIG_H) && defined(__sun__))
	typedef	size_t	socklen_t
#endif
#if (!defined(HAVE_USECONDS_T) && defined(SIZEOF_USECONDS_T) && (SIZEOF_USECONDS_T == 0) && defined(HAVE_CONFIG_H))
	typedef	long	useconds_t
#endif

	// pthread_t  printf() η
#if defined(HAVE_CONFIG_H) && defined(PRIuMAX)
# if defined(AX_CV__PRINTF__PTHREAD_T__POINTER)
#  define	PRIpthread_t	"p"
# elif defined(AX_CV__PRINTF__PTHREAD_T__UINTMAX)
#  define	PRIpthread_t	PRIuMAX
# elif defined(AX_CV__PRINTF__PTHREAD_T__UINT64)
#  define	PRIpthread_t	PRIu64
# elif defined(AX_CV__PRINTF__PTHREAD_T__UINT32)
#  define	PRIpthread_t	PRIu32
# elif defined(AX_CV__PRINTF__PTHREAD_T__UINT32LONG)
#  define	PRIpthread_t	"l"PRIu32
# elif defined(AX_CV__PRINTF__PTHREAD_T__UINT16)
#  define	PRIpthread_t	PRIu16
# elif defined(AX_CV__PRINTF__PTHREAD_T__UINT8)
#  define	PRIpthread_t	PRIu8
# endif
#endif

//@}



///@name function_alias	ؿ̾
//@{

#if (!defined(HAVE_STRICMP) && defined(HAVE_CONFIG_H)) || (!defined(HAVE_CONFIG_H) && !defined(MSDOS))
# define	stricmp		strcasecmp
# define	strnicmp	strncasecmp
#endif

#if (!defined(HAVE_MERGESORT) && defined(HAVE_CONFIG_H))
# if defined(HAVE_G_MERGESORT)
#  define	mergesort	g_mergesort
# elif defined(HAVE_ALTERNATIVE_MERGESORT)
#  include <stddef.h>
#  if defined(__cplusplus)
extern "C" {
#  endif /* defined(__cplusplus) */
size_t	mergesort(void *, size_t, size_t, int (*)(const void *, const void *));
#  if defined(__cplusplus)
}
#  endif /* defined(__cplusplus) */
#  define	ENABLE_ALTERNATIVE_MERGESORT
# else
#  error("A function mergesort() or alternative function is required.")
# endif
#endif
#if (!defined(HAVE_STRLCPY) && defined(HAVE_CONFIG_H))
# if defined(HAVE_G_STRLCPY)
#  define	strlcpy	g_strlcpy
# elif defined(HAVE_ALTERNATIVE_STRLCPY)
#  include <stddef.h>
#  if defined(__cplusplus)
extern "C" {
#  endif /* defined(__cplusplus) */
size_t	strlcpy(char *, const char *, size_t)
		__attribute__ ((__bounded__(__string__,1,3)));
#  if defined(__cplusplus)
}
#  endif /* defined(__cplusplus) */
#  define	ENABLE_ALTERNATIVE_STRLCPY
# else
#  error("A function strlcpy() or alternative function is required.")
# endif
#endif
#if (!defined(HAVE_STRLCAT) && defined(HAVE_CONFIG_H))
# if defined(HAVE_G_STRLCAT)
#  define	strlcat	g_strlcat
# elif defined(HAVE_ALTERNATIVE_STRLCAT)
#  include <stddef.h>
#  if defined(__cplusplus)
extern "C" {
#  endif /* defined(__cplusplus) */
size_t	strlcat(char *, const char *, size_t)
	__attribute__ ((__bounded__(__string__,1,3)));
#  if defined(__cplusplus)
}
#  endif /* defined(__cplusplus) */
#  define	ENABLE_ALTERNATIVE_STRLCAT
# else
#  error("A function strlcat() or alternative function is required.")
# endif
#endif

#if (!defined(HAVE_USLEEP) && defined(HAVE_CONFIG_H)) || (!defined(HAVE_CONFIG_H) && !defined(_WIN32))
# if (defined(QT_VERSION) && (QT_VERSION >= QT_VERSION_CHECK(6, 0, 0)))
# else
#  define	usleep(t)	Sleep(t/1000)
# endif
#endif

#if (!defined(HAVE_PTHREAD_STARTROUTINE_T) && defined(HAVE_CONFIG_H)) || (!defined(HAVE_CONFIG_H) && (defined(__sun__) || (defined(_WIN32) && defined(_POSIX_THREADS))))
	typedef void *(*pthread_startroutine_t)(void *);
#endif
#if defined(HAVE_PTHREAD_SETCONCURRENCY) || (!defined(HAVE_CONFIG_H) && defined(__sun__))
# define	pthread_setconcurrency	thr_setconcurrency
#endif
typedef void (*pthread_cleanuproutine_t)(void *);
// ʤ cleanup ؿη̵

//@}



///@name tips	äΤʤޥ
//@{

/* Obsolete by std::size */
/* #if !defined(number) */
/* # define		number(arr)			(sizeof(arr)/sizeof((arr)[0])) */
/* #endif */
/* Obsolete by offsetof() */
/* #define		offset(p_type,field)	((unsigned int)&(((p_type)NULL)->field)) */

#if !defined(CHARBITS) && defined(CHAR_BIT)
# define	BITS(type)	(CHAR_BIT * (int)sizeof(type))
# define	CHARBITS	BITS(char)
# define	SHORTBITS	BITS(short)
# define	INTBITS		BITS(int)
# define	LONGBITS	BITS(long)
# define	PTRBITS		BITS(char*)
# define	DOUBLEBITS	BITS(double)
# define	FLOATBITS	BITS(float)
#endif



/*#if defined(_MATH_H_) || defined(_MATH_H)*/		/* DEBUG: */

# define	get_sign( a )		( (0 <= (a)) ? (0) : (-1) )
# define	set_sign( a, sign )	( (a) ^ (sign) - (sign) )

# if 0 // defined(__cplusplus)

inline	bool isdigitsignpoint( const char c ) { return (('0' <= c) && (c <= '9')) || ('-' == c) || ('+' == c) || ('.' == c);}
inline	bool isdigitsign( const char c ) { return (('0' <= c) && (c <= '9')) || ('-' == c) || ('+' == c);}
inline	bool isdigitpoint( const char c ) { return (('0' <= c) && (c <= '9')) || ('.' == c);}

inline	double SIGN( double a, double b )
	{	return (b >= 0.0) ? (fabs(a)) : (-fabs(a));	}

template<typename TY> inline TY copysigni( TY x, TY y ) { return (0 <= y) ? abs(x) : -abs(x); }
template<typename TY> inline TY MAX( TY a, TY b ) { return (a > b) ? a : b; }
template<typename TY> inline TY MIN( TY a, TY b ) { return (a < b) ? a : b; }

inline double FMAX( double a, double b )	{ return MAX( a, b ); }
inline double FMIN( double a, double b )	{ return MIN( a, b ); }
inline long LMAX( long a, long b )	{ return MAX( a, b ); }
inline long LMIN( long a, long b )	{ return MIN( a, b ); }
inline int IMAX( int a, int b )	{ return MAX( a, b ); }
inline int IMIN( int a, int b )	{ return MIN( a, b ); }

inline double SQR( double a )	{ return a * a; }

template<typename TY> inline bool MAX_UPDATE( TY& dst, TY var )
			{ return (dst < var) ? ((dst = var), true) : false; }
template<typename TY> inline bool MIN_UPDATE( TY& dst, TY var )
			{ return (dst > var) ? ((dst = var), true) : false; }

inline double radian2degree( double a ) { return (a * M_2DEGREE / M_2PI); }
inline double degree2radian( double a ) { return (a * M_2PI / M_2DEGREE); }

/**  x  y ǳä;롣λ -y/2 礭 +y/2 ʲǤ롣
 *@param			x		
 *@param			y		
 *@return					;
 *@attention
 *		C99
 *		TY ξư̤
 *		y ξư̤
 */
template<typename TY> inline TY remainderi( TY x, TY y ) {
	if (x <= -(y/2)) { x += static_cast<TY>((-x + y/2) / y) * y; }
	else if (+(y/2) < x) { x -= static_cast<TY>((x + y/2) / y) * y; }
	return x;
}

/**  x  y ǳä;롣λ 0 ʾ y ̤Ǥ롣
 *@param			x		
 *@param			y		
 *@return					;
 *@attention
 *		C99
 *		TY ξư̤
 *		y ξư̤
 */
template<typename TY> inline TY remainderi_0toy( TY x, TY y ) {
	if (x < 0) { x += static_cast<TY>((-x + y -1) / y) * y; }
	else if (y <= x) { x -= static_cast<TY>((x) / y) * y; }
	return x;
}

/**  x  y ǳä;롣λ 0 ʾ y ̤Ǥ롣
 *@param			x		
 *@param			y		
 *@return					;
 *@attention
 *		C99
 *		TY ưξ
 *		y ξư̤
 */
template<typename TY> inline TY remainder_0toy( TY x, TY y ) {
	if (x < 0) { x += ceil((-x) / y) * y; }
	else if (y <= x) { x -= floor((x) / y) * y; }
	return x;
}

# else

#  define	isdigitsignpoint( c )	((('0' <= (c)) && ((c) <= '9')) || ('-' == (c)) || ('+' == (c)) || ('.' == (c)))
#  define	isdigitsign( c )		((('0' <= (c)) && ((c) <= '9')) || ('-' == (c)) || ('+' == (c)))
#  define	isdigitpoint( c )		((('0' <= (c)) && ((c) <= '9')) || ('.' == (c)))
#  define	SIGN( a, b )	( ((b) >= 0.0) ? (fabs(a)) : (-fabs(a)) )
#  define	copysigni( x, y ) ( (0 <= y) ? abs(x) : -abs(x) )
#  define	MAX( a, b )	( ((a) > (b)) ? (a) : (b) )
#  define	MIN( a, b )	( ((a) < (b)) ? (a) : (b) )
#  define	FMAX( a, b )	(MAX(a,b))
#  define	FMIN( a, b )	(MIN(a,b))
#  define	LMAX( a, b )	(MAX(a,b))
#  define	LMIN( a, b )	(MIN(a,b))
#  define	IMAX( a, b )	(MAX(a,b))
#  define	IMIN( a, b )	(MIN(a,b))
#  define	SQR( a )		( ((a) == 0.0) ? 0.0 : ((a) * (a)) )

# define	MAX_UPDATE( dst, var )	\
			( ((dst) < (var)) ? (((dst) = (var)), TRUE) : (FALSE) )
# define	MIN_UPDATE( dst, var )	\
			( ((dst) > (var)) ? (((dst) = (var)), TRUE) : (FALSE) )

# define	radian2degree( a )	((a) * M_2DEGREE / M_2PI)
# define	degree2radian( a )	((a) * M_2PI / M_2DEGREE)

# endif
/*#endif*/

//@}



///@name debug	ʰץǥХå
//@{

#if !defined(_WIN32)

# if defined(DEBUG)

#  if (3)<=(DEBUG)
#    define	pr_debug3(fmt,arg...)	pr_debug(fmt ,##arg)
#    define	pr_debug3k(fmt,arg...)	pr_debugk(fmt ,##arg)
#  else
#   define	pr_debug3(fmt,arg...)	do{}while(FALSE)
#   define	pr_debug3k(fmt,arg...)	do{}while(FALSE)
#  endif

#  if (2)<=(DEBUG)
#   define	pr_debug2(fmt,arg...)	pr_debug(fmt ,##arg)
#   define	pr_debug2k(fmt,arg...)	pr_debugk(fmt ,##arg)
#  else
#   define	pr_debug2(fmt,arg...)	do{}while(FALSE)
#   define	pr_debug2k(fmt,arg...)	do{}while(FALSE)
#  endif

#  if (1)<=(DEBUG)
#   define	pr_debug1(fmt,arg...)	pr_debug(fmt ,##arg)
#   define	pr_debug1k(fmt,arg...)	pr_debugk(fmt ,##arg)
#  else
#   define	pr_debug1(fmt,arg...)	do{}while(FALSE)
#   define	pr_debug1k(fmt,arg...)	do{}while(FALSE)
#  endif

# else

#  define	pr_debug3(fmt,arg...)	do{}while(FALSE)
#  define	pr_debug3k(fmt,arg...)	do{}while(FALSE)
#  define	pr_debug2(fmt,arg...)	do{}while(FALSE)
#  define	pr_debug2k(fmt,arg...)	do{}while(FALSE)
#  define	pr_debug1(fmt,arg...)	do{}while(FALSE)
#  define	pr_debug1k(fmt,arg...)	do{}while(FALSE)

# endif

# define	pr_debug9(fmt,arg...)	do{}while(FALSE)
# define	pr_debug9t(fmt,arg...)	do{}while(FALSE)


# ifdef __KERNEL__

#  if defined(DEBUG)
#   define	pr_debug0k(fmt,arg...)	printk(fmt ,##arg)
#   define	pr_debugk(fmt,arg...)	printk(fmt ,##arg)
#  else
#   define	pr_debug0k(fmt,arg...)	do{}while(FALSE)
#   define	pr_debugk(fmt,arg...)	do{}while(FALSE)
#  endif

# else

#  if defined(DEBUG)
#   define	pr_debug0(fmt,arg...)	fprintf(stderr,fmt ,##arg)
#   define	pr_debug0k(fmt,arg...)	fprintf(stderr,fmt ,##arg)
#   define	pr_debug(fmt,arg...)	fprintf(stderr,fmt ,##arg)
#   define	pr_debugk(fmt,arg...)	fprintf(stderr,fmt ,##arg)
#  else
#   define	pr_debug0(fmt,arg...)	do{}while(FALSE)
#   define	pr_debug0k(fmt,arg...)	do{}while(FALSE)
#   define	pr_debug(fmt,arg...)	do{}while(FALSE)
#   define	pr_debugk(fmt,arg...)	do{}while(FALSE)
#  endif
#  define	pr_info(fmt,arg...)		fprintf(stderr,fmt ,##arg)

# endif

#else		/* !defined(_WIN32) */

# if defined(DEBUG)
#  if (3)<=(DEBUG)
#   define	pr_debug3		printf
#   define	pr_debug3k		printf
#  else
#   define	pr_debug3		SLASH()SLASH()
#   define	pr_debug3k		SLASH()SLASH()
#  endif
#  if (2)<=(DEBUG)
#   define	pr_debug2		printf
#   define	pr_debug2k		printf
#  else
#   define	pr_debug2		SLASH()SLASH()
#   define	pr_debug2k		SLASH()SLASH()
#  endif
#  if (1)<=(DEBUG)
#   define	pr_debug1		printf
#   define	pr_debug1k		printf
#  else
#   define	pr_debug1		SLASH()SLASH()
#   define	pr_debug1k		SLASH()SLASH()
#  endif
#  define	pr_debug0		printf
#  define	pr_debug0k		printf
#  define	pr_debug		printf
#  define	pr_debugk		printf
# else
#  define	pr_debug3		SLASH()SLASH()
#  define	pr_debug3k		SLASH()SLASH()
#  define	pr_debug2		SLASH()SLASH()
#  define	pr_debug2k		SLASH()SLASH()
#  define	pr_debug1		SLASH()SLASH()
#  define	pr_debug1k		SLASH()SLASH()
#  define	pr_debug0		SLASH()SLASH()
#  define	pr_debug0k		SLASH()SLASH()
#  define	pr_debug		SLASH()SLASH()
#  define	pr_debugk		SLASH()SLASH()
# endif
# define	pr_info		printf

# define	pr_debug9		SLASH()SLASH()
# define	pr_debug9t		SLASH()SLASH()

#endif		/* !defined(_WIN32) */


#if (2 <= (__GNUC__ +0))
# define	pr_debug3t(fmt,arg...)	pr_debug3("%s:%d:%s: " fmt,__FILE__,__LINE__,__func__ ,##arg)
# define	pr_debug3kt(fmt,arg...)	pr_debug3k("%s:%d:%s: " fmt,__FILE__,__LINE__,__func__ ,##arg)
# define	pr_debug2t(fmt,arg...)	pr_debug2("%s:%d:%s: " fmt,__FILE__,__LINE__,__func__ ,##arg)
# define	pr_debug2kt(fmt,arg...)	pr_debug2k("%s:%d:%s: " fmt,__FILE__,__LINE__,__func__ ,##arg)
# define	pr_debug1t(fmt,arg...)	pr_debug1("%s:%d:%s: " fmt,__FILE__,__LINE__,__func__ ,##arg)
# define	pr_debug1kt(fmt,arg...)	pr_debug1k("%s:%d:%s: " fmt,__FILE__,__LINE__,__func__ ,##arg)
# define	pr_debug0t(fmt,arg...)	pr_debug0("%s:%d:%s: " fmt,__FILE__,__LINE__,__func__ ,##arg)
# define	pr_debug0kt(fmt,arg...)	pr_debug0k("%s:%d:%s: " fmt,__FILE__,__LINE__,__func__ ,##arg)
# define	pr_debugt(fmt,arg...)	pr_debug("%s:%d:%s: " fmt,__FILE__,__LINE__,__func__ ,##arg)
# define	pr_debugkt(fmt,arg...)	pr_debugk("%s:%d:%s: " fmt,__FILE__,__LINE__,__func__ ,##arg)
# define	pr_infot(fmt,arg...)	pr_info("%s:%d:%s: " fmt,__FILE__,__LINE__,__func__ ,##arg)
#elif (199901L <= (__STDC_VERSION__ +0L))
# define	pr_debug3t(fmt,...)		pr_debug3("%s:%d:%s: " fmt,__FILE__,__LINE__,__FUNCTION__ ,__VA_ARGS__)
# define	pr_debug3kt(fmt,...)	pr_debug3k("%s:%d:%s: " fmt,__FILE__,__LINE__,__FUNCTION__ ,__VA_ARGS__)
# define	pr_debug2t(fmt,...)		pr_debug2("%s:%d:%s: " fmt,__FILE__,__LINE__,__FUNCTION__ ,__VA_ARGS__)
# define	pr_debug2kt(fmt,...)	pr_debug2k("%s:%d:%s: " fmt,__FILE__,__LINE__,__FUNCTION__ ,__VA_ARGS__)
# define	pr_debug1t(fmt,...)		pr_debug1("%s:%d:%s: " fmt,__FILE__,__LINE__,__FUNCTION__ ,__VA_ARGS__)
# define	pr_debug1kt(fmt,...)	pr_debug1k("%s:%d:%s: " fmt,__FILE__,__LINE__,__FUNCTION__ ,__VA_ARGS__)
# define	pr_debug0t(fmt,...)		pr_debug0("%s:%d:%s: " fmt,__FILE__,__LINE__,__FUNCTION__ ,__VA_ARGS__)
# define	pr_debug0kt(fmt,...)	pr_debug0k("%s:%d:%s: " fmt,__FILE__,__LINE__,__FUNCTION__ ,__VA_ARGS__)
# define	pr_debugt(fmt,...)		pr_debug("%s:%d:%s: " fmt,__FILE__,__LINE__,__FUNCTION__ ,__VA_ARGS__)
# define	pr_debugkt(fmt,...)		pr_debugk("%s:%d:%s: " fmt,__FILE__,__LINE__,__FUNCTION__ ,__VA_ARGS__)
# define	pr_infot(fmt,...)		pr_info("%s:%d:%s: " fmt,__FILE__,__LINE__,__FUNCTION__ ,__VA_ARGS__)
#else
# define	pr_debug3t(fmt,arg...)	pr_debug3("%s:%d: " fmt,__FILE__,__LINE__ ,##arg)
# define	pr_debug3kt(fmt,arg...)	pr_debug3k("%s:%d: " fmt,__FILE__,__LINE__ ,##arg)
# define	pr_debug2t(fmt,arg...)	pr_debug2("%s:%d: " fmt,__FILE__,__LINE__ ,##arg)
# define	pr_debug2kt(fmt,arg...)	pr_debug2k("%s:%d: " fmt,__FILE__,__LINE__ ,##arg)
# define	pr_debug1t(fmt,arg...)	pr_debug1("%s:%d: " fmt,__FILE__,__LINE__ ,##arg)
# define	pr_debug1kt(fmt,arg...)	pr_debug1k("%s:%d: " fmt,__FILE__,__LINE__ ,##arg)
# define	pr_debug0t(fmt,arg...)	pr_debug0("%s:%d: " fmt,__FILE__,__LINE__ ,##arg)
# define	pr_debug0kt(fmt,arg...)	pr_debug0k("%s:%d: " fmt,__FILE__,__LINE__ ,##arg)
# define	pr_debugt(fmt,arg...)	pr_debug("%s:%d: " fmt,__FILE__,__LINE__ ,##arg)
# define	pr_debugkt(fmt,arg...)	pr_debugk("%s:%d: " fmt,__FILE__,__LINE__ ,##arg)
# define	pr_infot(fmt,arg...)	pr_info("%s:%d: " fmt,__FILE__,__LINE__ ,##arg)
#endif

//@}



#endif	// MYTYPES_H
/* [ End of File ] */
