/**@file
 *
 *@brief	QRL Maker
 *@date		Thu,17 Sep,2015 - Sat,19 Sep,2015
 *@date		Sun,20 Sep,2015
 *@date		Sat,03 Oct,2015
 *@date		Tue,13 Oct,2015
 *@date		Sun,18 Oct,2015 - Mon,19 Oct,2015
 *@date		Mon,26 Oct,2015
 *@date		Sun,10 Jan,2016 - Mon,11 Jan,2016
 *@date		Thu,11 Feb,2016
 *@date		Fri,04 Aug,2017
 *@date		Fri,18 Aug,2017
 *@date		Sat,03 Mar,2018
 *@date		Sat,27 Oct,2018
 *@date		Thu,29 Nov,2018
 *@date		Sun,20 Jan,2019
 *@date		Sat,16 Feb,2019
 *@date		Sun,13 Sep,2020
 *@date		Mon,16 Nov,2020
 *@date		Sun,27 Dec,2020
 *@date		Tue,16 Feb,2021
 *@date		Thu,18 Feb,2021
 *@date		Fri,19 Feb,2021
 *@date		Sat,20 Feb,2021
 *@date		Mon,22 Feb,2021
 *@date		Mon,24 May,2021
 *@date		Sat,29 May,2021
 *
 *@author	Copyright(C)2015-2021 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <assert.h>
#include "settings.h"
#include "qrl.h"
#include <QVector>

QRL::QRLLibrary::QRLLibrary(QRLMaker* const q) noexcept :
	qrlmaker(NULL)
{
	assert (NULL != q);

	qrlmaker = q;

	this->compile_container.header = NULL;
	this->compile_container.stamp = NULL;
	this->compile_container.footer = NULL;

	return;
}

QRL::QRLLibrary::~QRLLibrary(void) noexcept
{
	assert (NULL != qrlmaker);
	assert (NULL != compile_container.header);
	assert (NULL != compile_container.stamp);
	assert (NULL != compile_container.footer);

	if (NULL != this->compile_container.header) {
		delete this->compile_container.header;
	}
	if (NULL != this->compile_container.stamp) {
		delete this->compile_container.stamp;
	}
	if (NULL != this->compile_container.footer) {
		delete this->compile_container.footer;
	}

	for (QVector<QRL::QRLChipLibrary_List>::iterator itr = library.begin(); itr != library.end(); ++itr) {
		switch (itr->type) {
		case QRL::QRLChipLibrary_List::NONE:
			break;

		case QRL::QRLChipLibrary_List::LABEL:
			assert (NULL != itr->data.label.basename);
			assert (NULL != itr->data.label.filename);
			assert (NULL != itr->data.label.label);
			delete itr->data.label.basename;
			delete itr->data.label.filename;
			delete itr->data.label.label;
			break;

		case QRL::QRLChipLibrary_List::CHIP:
			assert (NULL != itr->data.chip.basename);
			assert (NULL != itr->data.chip.filename);
			assert (NULL != itr->data.chip.header);
			assert (NULL != itr->data.chip.body);
			assert (NULL != itr->data.chip.name);
			assert (NULL != itr->data.chip.footprint);
			assert (NULL != itr->data.chip.image_name);
			assert (NULL != itr->data.chip.image);
			assert (NULL != itr->data.chip.chip_coordinates_tag);
			assert (NULL != itr->data.chip.chip_number_tag);
			assert (NULL != itr->data.chip.chip_number);
			assert (NULL != itr->data.chip.chip_footprint_tag);
			// assert (NULL != itr->data.chip.next_address_condition_true_coordinates_tag); // Allocate only when using.
			// assert (NULL != itr->data.chip.next_address_condition_true_tag); // Allocate only when using.
			// assert (NULL != itr->data.chip.next_address_condition_true); // Allocate only when using.
			// assert (NULL != itr->data.chip.next_address_condition_false_coordinates_tag); // Allocate only when using.
			// assert (NULL != itr->data.chip.next_address_condition_false_tag); // Allocate only when using.
			// assert (NULL != itr->data.chip.next_address_condition_false); // Allocate only when using.
			assert (NULL != itr->data.chip.argument);
			delete itr->data.chip.basename;
			delete itr->data.chip.filename;
			delete itr->data.chip.header;
			delete itr->data.chip.body;
			delete itr->data.chip.name;
			delete itr->data.chip.footprint;
			delete itr->data.chip.image_name;
			delete itr->data.chip.image;
			delete itr->data.chip.chip_coordinates_tag;
			delete itr->data.chip.chip_number_tag;
			delete itr->data.chip.chip_number;
			delete itr->data.chip.chip_footprint_tag;
			delete itr->data.chip.next_address_condition_true_coordinates_tag;
			delete itr->data.chip.next_address_condition_true_tag;
			delete itr->data.chip.next_address_condition_true;
			delete itr->data.chip.next_address_condition_false_coordinates_tag;
			delete itr->data.chip.next_address_condition_false_tag;
			delete itr->data.chip.next_address_condition_false;
			for (uint_fast8_t i = 0; i < itr->data.chip.argument_num; ++i) {
				assert (NULL != itr->data.chip.argument[i].comment);
				assert (NULL != itr->data.chip.argument[i].arg);
				assert (NULL != itr->data.chip.argument[i].tag);
				// assert (NULL != itr->data.chip.argument[i].tag_raw); // Allocate only when using.
				// assert (NULL != itr->data.chip.argument[i].list); // Allocate only when using.
				// assert (NULL != itr->data.chip.argument[i].type_selected); // Allocate only when using.
				delete itr->data.chip.argument[i].comment;
				delete itr->data.chip.argument[i].arg;
				delete itr->data.chip.argument[i].tag;
				delete itr->data.chip.argument[i].tag_raw;
				delete itr->data.chip.argument[i].list;
				delete itr->data.chip.argument[i].type_selected;
			}
			delete[] itr->data.chip.argument;
			break;
		}
	}

	return;
}
// [ End of File ]
