/**@file
 *
 *@brief	QRL Maker
 *@date		Mon,21 Sep,2015
 *@date		Sat,03 Oct,2015 - Wed,07 Oct,2015
 *@date		Tue,13 Oct,2015
 *@date		Mon,19 Oct,2015
 *@date		Thu,22 Oct,2015
 *@date		Mon,26 Oct,2015
 *@date		Wed,17 Feb,2021
 *@date		Sat,29 May,2021
 *
 *@author	Copyright(C)2015-2021 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <assert.h>
#include "qrl.h"
#include <QString>
#include <QVector>

const QRL::QRLChipLibrary* QRL::QRLLibrary::chipSearch(const QString& chip_name) const noexcept
{
	QVector<QRL::QRLChipLibrary_List>::const_iterator itr;
	for (itr = libraryBegin(); itr != libraryEnd(); ++itr) {
		if (QRL::QRLChipLibrary_List::CHIP == itr->type) {
			if (*(itr->data.chip.name) == chip_name) {
				return &(itr->data.chip);
			}
		}
	}
	return NULL;
}

const QRL::QRLChipLibrary* QRL::QRLLibrary::chipSearch(const QString* const chip_name) const noexcept
{
	assert (NULL != chip_name);
	return chipSearch(*chip_name);
}
// [ End of File ]
