/**@file
 *
 *@brief	QRL Maker
 *@date		Thu,17 Sep,2015 - Sat,19 Sep,2015
 *@date		Sun,20 Sep,2015 - Tue,29 Sep,2015
 *@date		Sat,03 Oct,2015 - Mon,12 Oct,2015
 *@date		Tue,13 Oct,2015 - Thu,15 Oct,2015
 *@date		Sun,18 Oct,2015 - Mon,19 Oct,2015
 *@date		Thu,22 Oct,2015 - Sun,25 Oct,2015
 *@date		Wed,28 Oct,2015
 *@date		Sun,10 Jan,2016
 *@date		Thu,11 Feb,2016 - Sun,14 Feb,2016
 *@date		Sun,16 Apr,2017
 *@date		Sun,23 Jul,2017
 *@date		Fri,04 Aug,2017
 *@date		Fri,18 Aug,2017
 *@date		Sat,03 Mar,2018
 *@date		Sat,27 Oct,2018
 *@date		Tue,27 Nov,2018 - Thu,29 Nov,2018
 *@date		Fri,28 Dec,2018
 *@date		Mon,31 Dec,2018
 *@date		Thu,18 Feb,2021
 *@date		Sat,29 May,2021
 *
 *@author	Copyright(C)2015-2021 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef QRL_TYPE_H
#define QRL_TYPE_H

#include <cstdint>

namespace QRL {

typedef int_fast16_t QRLChipNumber;
typedef uint_fast32_t QRLChipArrowAddress;

typedef int_fast16_t ChipAddr;

/**<
 *  6  7  8
 *   \ | /
 *    \|/
 *  5--*--1
 *    /|\
 *   / | \
 *  4  3  2
 */
enum ChipArrow_DIR {
	ChipArrow_MIN = 0,
	ChipArrow_RIGHT,
	ChipArrow_DOWNRIGHT,
	ChipArrow_DOWN,
	ChipArrow_DOWNLEFT,
	ChipArrow_LEFT,
	ChipArrow_UPLEFT,
	ChipArrow_UP,
	ChipArrow_UPRIGHT,
	ChipArrow_MAX,
};
typedef enum ChipArrow_DIR ChipArrow;


struct ChipAddrXY {
	ChipAddr x;
	ChipAddr y;
	ChipAddrXY operator +( const ChipAddrXY& arg ) const noexcept;
	ChipAddrXY operator -( const ChipAddrXY& arg ) const noexcept;
	bool operator ==(const ChipAddrXY& arg) const noexcept;
	bool operator !=(const ChipAddrXY& arg) const noexcept;
};

};



inline QRL::ChipAddrXY QRL::ChipAddrXY::operator +( const QRL::ChipAddrXY& arg ) const noexcept
{
	QRL::ChipAddrXY dst;
	dst.x = (*this).x + arg.x;
	dst.y = (*this).y + arg.y;
	return dst;
}

inline QRL::ChipAddrXY QRL::ChipAddrXY::operator -( const QRL::ChipAddrXY& arg ) const noexcept
{
	QRL::ChipAddrXY dst;
	dst.x = (*this).x - arg.x;
	dst.y = (*this).y - arg.y;
	return dst;
}

inline bool QRL::ChipAddrXY::operator ==(const QRL::ChipAddrXY& arg) const noexcept
{
	if (this->x != arg.x) {
		return false;
	}
	if (this->y != arg.y) {
		return false;
	}
	return true;
}
inline bool QRL::ChipAddrXY::operator !=(const QRL::ChipAddrXY& arg) const noexcept
{
	return !((*this) == arg);
}

#endif // QRL_TYPE_H
// [ End of File ]
