#
#@brief	QRL Maker
#@date	Thu,28 May,2015
#@date	Fri,11 Sep,2015
#@date	Wed,16 Sep,2015
#@date	Thu,17 Sep,2015
#@date	Mon,05 Oct,2015 - Mon,12 Oct,2015
#@date	Thu,15 Oct,2015
#@date	Fri,16 Oct,2015
#@date	Sat,17 Oct,2015
#@date	Fri,23 Oct,2015
#@date	Sun,25 Oct,2015
#@date	Wed,28 Oct,2015 - Sat,31 Oct,2015
#@date	Thu,11 Feb,2016
#@date	Sun,25 Jun,2017
#@date	Fri,21 Jul,2017
#@date	Sun,23 Jul,2017
#@date	Thu,27 Jul,2017
#@date	Sat,05 Aug,2017
#@date	Sat,10 Mar,2018
#@date	Sat,17 Mar,2018
#@date	Sat,27 Oct,2018
#@date	Tue,27 Nov,2018
#@date	Fri,28 Dec,2018
#@date	Sat,29 Dec,2018
#@date	Sun,30 Dec,2018
#@date	Mon,31 Dec,2018
#@date	Sat,19 Jan,2019
#@date	Fri,25 Jan,2019
#@date	Sat,26 Jan,2019
#@date	Sun,27 Jan,2019
#@date	Wed,30 Jan,2019
#@date	Thu,19 Nov,2020
#@date	Wed,17 Feb,2021 - Thu,18 Feb,2021
#@date	Sat,20 Feb,2021
#@date	Tue,23 Feb,2021
#@date	Sat,27 Feb,2021
#@date	Sun,06 Jun,2021
#@date	Tue,28 Jun,2022
#@date	Thu,02 Nov,2023
#@author	Copyright(C)2014-2023 G-HAL. All rights reserved.

load(configure)

CONFIG(debug, debug|release) {
DEFINES="DEBUG"
QMAKE_CFLAGS="-g3 -O0"
QMAKE_CXXFLAGS+="-g3 -O0"
QMAKE_LFLAGS="-g3 -O0"
message("DEBUG")
} else {
DEFINES="RELEASE"
QMAKE_CFLAGS="-g0 -O3"
QMAKE_CXXFLAGS+="-g0 -O3"
QMAKE_LFLAGS="-g0 -O3"
message("RELEASE")
}


unix {
revision_id.target = $$absolute_path("../revision_id.h")
revision_id.depends = FORCE
revision_id.commands = -$$absolute_path("../src/revision_id.sh") $$revision_id.target
QMAKE_CLEAN += $$revision_id.target
QMAKE_EXTRA_TARGETS += revision_id
PRE_TARGETDEPS += $$revision_id.target
} else {
revision_id.target = $$absolute_path("../revision_id.h")
revision_id.depends = FORCE
#revision_id.commands = -$$absolute_path("../src/revision_id.sh") $$revision_id.target
#QMAKE_CLEAN += $$revision_id.target
QMAKE_EXTRA_TARGETS += revision_id
PRE_TARGETDEPS += $$revision_id.target
}


#qtCompileTest(have_strlcpy)
#contains( CONFIG, config_have_strlcpy ) {
#  DISTFILES += \
#      alternative/alternative_strlcpy.h \
#      alternative/strlcpy.c \
#      alternative/strlcat.c
#} else {
#  DEFINES += \
#      NEED_ALTERNATIVE_STRLCPY \
#      NEED_ALTERNATIVE_STRLCAT
#  HEADERS += \
#      alternative/alternative_strlcpy.h
#
#  SOURCES += \
#      alternative/strlcpy.c \
#      alternative/strlcat.c
#}
#
#qtCompileTest(have_mergesort)
#contains( CONFIG, config_have_mergesort ) {
#  DISTFILES += \
#      alternative/alternative_mergesort.h \
#      alternative/mergesort.c
#} else {
#  DEFINES += \
#      NEED_ALTERNATIVE_MERGESORT
#  HEADERS += \
#      alternative/alternative_mergesort.h
#
#  SOURCES += \
#      alternative/mergesort.c
#}


QT       += core gui

greaterThan(QT_MAJOR_VERSION, 4): QT += widgets

TARGET = qrlmaker
TEMPLATE = app

TRANSLATIONS += qrlmaker_ja.ts

SOURCES += \
    main.cpp\
    settings.cpp \
    qrlmaker.cpp \
    mystyle.cpp \
    mainwindow.cpp \
    mainwindow_title.cpp \
    mainwindow_settings.cpp \
    mainwindow_dialog.cpp \
    mainwindow_event.cpp \
    mainwindow_filemenu.cpp \
    mainwindow_editmenu.cpp \
    mainwindow_undohistory.cpp \
    mainwindow_viewmenu.cpp \
    mainwindow_windowsmenu.cpp \
    form_mainform.cpp \
    form_mainform_event.cpp \
    form_mainform_mouse_eventhandler.cpp \
    form_mainform_mouse_singleclick.cpp \
    form_mainform_mouse_doubleclick.cpp \
    form_mainform_mouse_release.cpp \
    form_mainform_mouse_move.cpp \
    form_mainform_mouse_wheel.cpp \
    form_mainform_key.cpp \
    form_mainform_timer.cpp \
    form_mainform_action.cpp \
    form_mainform_filemenu.cpp \
    form_mainform_editmenu.cpp \
    form_mainform_scrollbar.cpp \
    form_mainform_drawingarea_statusmsg.cpp \
    form_mainform_drawingarea_mouseptr.cpp \
    form_mainform_drawingarea_editargument.cpp \
    form_mainform_buildimage.cpp \
    form_mainform_contextmenu.cpp \
    form_treeview.cpp \
    form_treeview_contextmenu.cpp \
    form_treeview_delegate.cpp \
    qrl.cpp \
    qrl_check.cpp \
    qrl_readlib.cpp \
    qrl_libsearch.cpp \
    qrl_container.cpp \
    qrlmap.cpp \
    qrlmap_check.cpp \
    qrlmap_put.cpp \
    qrlmap_remove.cpp \
    qrlmap_rebuild.cpp \
    qrlmap_reallocation.cpp \
    qrlmap_undo.cpp \
    qrlmap_save.cpp \
    qrlmap_load.cpp \
    mapeditor_clipboard.cpp \
    mapeditor_base.cpp \
    mapeditor_editargument.cpp \
    mapeditor_arrow.cpp \
    mapeditor_editcommand.cpp \
    mapeditor.cpp \
    dialog_inputdialog.cpp \
    dialog_listdialog.cpp \
    imagebuilder.cpp \
    imagebuilder_rawdraw.cpp \
    imagebuilder_makebaseimage.cpp \
    imagebuilder_makeoverlayimage.cpp \
    imagebuilder_makedisplayimage.cpp \
    imagebuilder_makesaveimage.cpp \

HEADERS  += \
    $$revision_id.target revision_header.h \
    mytypes.h \
    xy_.h \
    settings.h \
    qrlmaker.h \
    mystyle.h \
    mainwindow.h \
    form_treeview.h \
    form_mainform.h \
    qrl_type.h \
    qrl.h \
    qrlmap.h \
    mapeditor_clipboard.h \
    mapeditor_base.h \
    mapeditor.h \
    dialog_inputdialog.h \
    dialog_listdialog.h \
    imagebuilder.h \

FORMS    += \
    mainwindow.ui \
    dialog_inputdialog.ui \
    dialog_listdialog.ui \

# [ End of File ]
