/**@file
 *
 *@brief	QRL Maker
 *@date		Mon,05 Oct,2015 - Mon,12 Oct,2015
 *@date		Tue,13 Oct,2015 - Thu,15 Oct,2015
 *@date		Sat,17 Oct,2015
 *@date		Mon,26 Oct,2015 - Sat,31 Oct,2015
 *@date		Sun,10 Jan,2016
 *@date		Thu,11 Feb,2016
 *@date		Sun,09 Jul,2017
 *@date		Fri,28 Jul,2017
 *@date		Tue,27 Nov,2018
 *@date		Fri,28 Dec,2018
 *@date		Wed,17 Feb,2021
 *@date		Fri,19 Feb,2021
 *@date		Mon,24 May,2021
 *@date		Sat,29 May,2021
 *@date		Sun,30 May,2021
 *@date		Sat,05 Jun,2021
 *
 *@author	Copyright(C)2015-2021 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <assert.h>
#include <vector>
#include <cstdint>
#include "settings.h"
#include "qrlmaker.h"
#include "qrlmap.h"
#include <QString>

void QRL::QRLChip::clear(void) noexcept
{
	this->chip_number = QRLChipEmptyFlag;
	this->addr.x = 0;
	this->addr.y = 0;
	this->next_address_condition_true = 0;
	this->next_address_condition_false = 0;

	return;
}

QRL::QRLChip::QRLChip(void) noexcept
{
	this->chip_number = QRLChipEmptyFlag;
	this->addr.x = 0;
	this->addr.y = 0;
	this->next_address_condition_true = 0;
	this->next_address_condition_false = 0;

	return;
}

QRL::QRLChip::~QRLChip(void) noexcept
{
	return;
}

void QRL::QRLChipList::clear(void) noexcept
{
	for (QRL::QRLChipNumber i = 0; i < this->listsize; ++i) {
		qrlchips[i].clear();
	}
	return;
}

QRL::QRLChipList::QRLChipList(const QRLMaker* const q, QRL::QRLChipNumber size_num) noexcept :
	qrlmaker(NULL),
	qrlchips(NULL)
{
	assert (NULL != q);

	qrlmaker = q;

	qrlchips = new(std::nothrow) QRL::QRLChip[size_num];
	assert (NULL != this->qrlchips);
	this->listsize = size_num;

	return;
}

QRL::QRLChipList::QRLChipList(const QRLMaker* const q) noexcept :
	qrlmaker(NULL),
	qrlchips(NULL)
{
	assert (NULL != q);

	qrlmaker = q;

	this->listsize = 0;

	return;
}

QRL::QRLChipList::~QRLChipList(void) noexcept
{
	assert (NULL != qrlmaker);
	assert (NULL != qrlchips);

	delete[] qrlchips;

	return;
}

void QRL::QRLMap::clear(void) noexcept
{
	qrlchiplist->clear();
	rebuild_map();
	return;
}

QRL::QRLMap::QRLMap(const QRLMaker* const q, const QRL::ChipAddrXY& size, QRL::QRLChipNumber size_num) noexcept :
	qrlmaker(NULL),
	qrlchiplist(NULL),
	qrlchiplist_undobuf_memo(NULL),
	qrlchipmap(NULL)
{
	assert (NULL != q);
	assert (0 < size.x);
	assert (0 < size.y);
	assert (0 < size_num);

	qrlmaker = q;

	qrlchiplist = new(std::nothrow) QRL::QRLChipList(qrlmaker, size_num);
	assert (NULL != qrlchiplist);

	this->undo_size = Settings::QRLChipLibrary.Limit.Undo;
	qrlchiplist_undobuf.reserve(this->undo_size);
	for (int_fast8_t i = 0; i < this->undo_size; ++i) {
		qrlchiplist_undobuf.emplace_back(qrlmaker, size_num);
	}
	qrlchiplist_undobuf_memo = new(std::nothrow) QString[this->undo_size];
	assert (NULL != qrlchiplist_undobuf_memo);
	this->undo_ptr = 0;
	this->undo_limit = 0;
	this->redo_limit = 0;

	qrlchipmap = new(std::nothrow) QRL::QRLChipNumber[size.x * size.y];
	assert (NULL != qrlchipmap);
	this->mapsize = size;
	for (QRL::ChipAddr y = 0; y < this->mapsize.y; ++y) {
		for (QRL::ChipAddr x = 0; x < this->mapsize.x; ++x) {
			const QRL::ChipAddrXY ptr = {
				.x = x,
				.y = y,
			};
			set_map(ptr, QRLChipEmptyFlag);
		}
	}

	return;
}

QRL::QRLMap::~QRLMap(void) noexcept
{
	assert (NULL != qrlmaker);
	assert (NULL != qrlchiplist);
	assert (NULL != qrlchiplist_undobuf_memo);
	assert (NULL != qrlchipmap);

	if (NULL != qrlchipmap) {
		delete[] qrlchipmap;
	}

	if (NULL != qrlchiplist_undobuf_memo) {
		delete[] qrlchiplist_undobuf_memo;
	}

	if (NULL != qrlchiplist) {
		delete qrlchiplist;
	}
	return;
}
// [ End of File ]
