/**@file
 *
 *@brief	QRL Maker
 *@date		Mon,12 Oct,2015
 *@date		Tue,13 Oct,2015 - Fri,16 Oct,2015
 *@date		Sun,16 Apr,2017
 *@date		Sun,09 Jul,2017
 *@date		Sat,15 Jul,2017
 *@date		Mon,21 Jan,2019
 *@date		Sun,27 Dec,2020
 *@date		Sat,29 May,2021
 *@date		Fri,04 Jun,2021
 *@date		Sat,05 Jun,2021
 *@date		Sun,06 Jun,2021
 *
 *@author	Copyright(C)2015-2021 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <assert.h>
#include <cstdint>
#include "qrlmap.h"
#include <QString>
#include <QTranslator>
#include <QDateTime>

int_fast8_t QRL::QRLMap::reset_undo(const QString& msg) noexcept
{
	this->undo_ptr = 0;
	this->redo_limit = 0;
	this->undo_limit = 0;

	qrlchiplist_undobuf[this->undo_ptr] = (*qrlchiplist);
	if (!msg.isEmpty()) {
		QDateTime dt = QDateTime::currentDateTime();
		const QString str = dt.toString(QObject::tr("ddd,dd MMM,yyyy hh:mm:ss")) + " " + msg;
		qrlchiplist_undobuf_memo[this->undo_ptr] = str;
	} else {
		qrlchiplist_undobuf_memo[this->undo_ptr] = "";
	}

	return 0;
}

int_fast8_t QRL::QRLMap::push_undo(const QString& msg) noexcept
{
	if (qrlchiplist_undobuf[this->undo_ptr] == (*qrlchiplist)) {
		return -1;
	}

	int_fast8_t next_ptr = this->undo_ptr;
	++next_ptr;
	if (this->undo_size <= next_ptr) {
		next_ptr = 0;
	}

	this->redo_limit = next_ptr;
	if (this->undo_limit == next_ptr) {
		++(this->undo_limit);
		if (this->undo_size <= this->undo_limit) {
			this->undo_limit = 0;
		}
	}

	qrlchiplist_undobuf[next_ptr] = (*qrlchiplist);
	if (!msg.isEmpty()) {
		QDateTime dt = QDateTime::currentDateTime();
		const QString str = dt.toString(QObject::tr("ddd,dd MMM,yyyy hh:mm:ss")) + " " + msg;
		qrlchiplist_undobuf_memo[next_ptr] = str;
	} else {
		qrlchiplist_undobuf_memo[next_ptr] = qrlchiplist_undobuf_memo[this->undo_ptr];
	}

	this->undo_ptr = next_ptr;
	return next_ptr;
}

int_fast8_t QRL::QRLMap::undo(QString* const msg) noexcept
{
	if (this->undo_ptr == this->undo_limit) {
		return -1;
	}

	int_fast8_t prev_ptr = this->undo_ptr;
	--prev_ptr;
	if (prev_ptr < 0) {
		prev_ptr = (this->undo_size - 1);
	}

	if (NULL != msg) {
		(*msg) = qrlchiplist_undobuf_memo[this->undo_ptr];
	}
	(*qrlchiplist) = qrlchiplist_undobuf[prev_ptr];

	this->undo_ptr = prev_ptr;

	const bool ret = rebuild_map();
	if (!ret) {
		return -1;
	}
	return prev_ptr;
}

int_fast8_t QRL::QRLMap::redo(QString* const msg) noexcept
{
	if (this->undo_ptr == this->redo_limit) {
		return -1;
	}

	int_fast8_t next_ptr = this->undo_ptr;
	++next_ptr;
	if (this->undo_size <= next_ptr) {
		next_ptr = 0;
	}

	if (NULL != msg) {
		(*msg) = qrlchiplist_undobuf_memo[next_ptr];
	}
	(*qrlchiplist) = qrlchiplist_undobuf[next_ptr];

	this->undo_ptr = next_ptr;

	const bool ret = rebuild_map();
	if (!ret) {
		return -1;
	}
	return next_ptr;
}
// [ End of File ]
