#!/bin/sh --
#	revision_id.sh
#	ӥID  C إåեѴ
#	Tue,10 Sep,2013
#	Thu,28 May,2015 - Sun,31 May,2015
#	Mon,10 Oct,2016
#	Copyright(C)2005-2016 G-HAL, All rights reserved.
#
#	Redistribution and use in source and binary forms, with or without
#	modification, are permitted provided that the following conditions
#	are met:
#	
#	* Redistributions of source code must retain the above copyright
#	notice, this list of conditions and the following disclaimer.
#	
#	* Redistributions in binary form must reproduce the above copyright
#	notice, this list of conditions and the following disclaimer in the
#	documentation and/or other materials provided with the distribution.
#	
#	* Neither the name of the copyright holders nor the names of its contributors
#	may be used to endorse or promote products derived from this software
#	without specific prior written permission.
#	
#	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
#	A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
#	CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
#	EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
#	PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
#	PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
#	LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
#	NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#	SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

# tools
check_exec()
{
  _check_file="$1"
  if [ -x ${_check_file} -a ! -d ${_check_file} ]; then
    return 0
  fi
  return 1
}
#
search_exec()
{
  _env_name="$1"
  _search_file="$2"
  _default_file="$3"
  if [ "x${_default_file}" = "x" ]; then
    if check_exec /bin/${_search_file}; then
      _ret=/bin/${_search_file}
      return 0
    elif check_exec /usr/bin/${_search_file}; then
      _ret=/usr/bin/${_search_file}
      return 0
    elif check_exec /usr/local/bin/${_search_file}; then
      _ret=/usr/local/bin/${_search_file}
      return 0
    elif check_exec /usr/X11R6/bin/${_search_file}; then
      _ret=/usr/X11R6/bin/${_search_file}
      return 0
    else
      echo "${_search_file} was not found."
      echo "Please set environment ${_env_name} where ${_search_file} is."
      return 1
    fi
  elif check_exec ${_default_file}; then
    _ret=${_default_file}
    return 0
  else
    echo "${_default_file} was not executable"
    echo "Please set environment ${_env_name} where ${_search_file} is."
#    return 1
    _ret=${_default_file}
    return 0
  fi
}
#
search_exec UNAME uname ${UNAME} || exit 2
UNAME=${_ret}
search_exec BASENAME basename ${BASENAME} || exit 2
BASENAME=${_ret}
search_exec DIRNAME dirname ${DIRNAME} || exit 2
DIRNAME=${_ret}
search_exec MKTEMP mktemp ${MKTEMP} || exit 2
MKTEMP=${_ret}
search_exec RM rm ${RM} || exit 2
RM="${_ret}"
search_exec SHRED shred ${SHRED}
SHRED="${_ret}"
search_exec GSHRED gshred ${GSHRED}
GSHRED="${_ret}"
search_exec SVN svn ${SVN} || exit 2
SVN=${_ret}
search_exec GREP grep ${GREP} || exit 2
GREP=${_ret}
search_exec SED sed ${SED} || exit 2
SED=${_ret}
search_exec DIFF diff ${DIFF} || exit 2
DIFF=${_ret}
search_exec MV mv ${MV} || exit 2
MV=${_ret}
search_exec TOUCH touch ${TOUCH} || exit 2
TOUCH=${_ret}
search_exec CHMOD chmod ${CHMOD} || exit 2
CHMOD=${_ret}
#
script_basename=`${BASENAME} $0 .sh`
srcdir=`${DIRNAME} $0`
#
case `${UNAME} -s` in
FreeBSD|NetBSD|OpenBSD|*BSD|Darwin)
  if [ "x${RM}" = "x" ]; then
    exit 2
  fi
  REMOVE="${RM} -P"
  MKTEMP_OPT="-t ${script_basename}"
  ;;
Linux|linux)
  if [ "x${SHRED}" = "x" ]; then
    exit 2
  fi
  REMOVE="${SHRED} --remove -n 3 --zero"
  MKTEMP_OPT="--tmpdir ${script_basename}.XXXXXX"
  ;;
*)
  if [ "x${GSHRED}" = "x" ]; then
    exit 2
  fi
  REMOVE="${GSHRED} --remove -n 3 --zero"
  MKTEMP_OPT="${script_basename}.XXXXXX"
  ;;
esac
#
TMPFILE1=`${MKTEMP} ${MKTEMP_OPT}`
if [ $? -ne 0 ]; then
  echo "$0: Can not create temp file, exiting..."
  exit 2
fi
TMPFILE2=`${MKTEMP} ${MKTEMP_OPT}`
if [ $? -ne 0 ]; then
  echo "$0: Can not create temp file, exiting..."
  exit 2
fi
#

env LANG=C ${SVN} log -l 1 --xml --with-revprop svn:author --with-revprop svn:date ${srcdir} 2> ${TMPFILE1} 1>&2
if [ $? -ne 0 ]; then
  ${REMOVE} ${TMPFILE1} ${TMPFILE2}
  echo "$0: The project is not under svn, exiting..."
  exit 1
fi


SED_REFORMAT_REVISION='s/^.*revision="/"/
s/">.*$/"/'
RESULT_REVISION=`${GREP} -w revision < ${TMPFILE1} | ${SED} -e "${SED_REFORMAT_REVISION}"`

SED_REFORMAT_DATE='s/^.*<date>/"/
s/<\/date>.*$/"/'
RESULT_DATE=`${GREP} -w date < ${TMPFILE1} | ${SED} -e "${SED_REFORMAT_DATE}"`

SED_REFORMAT_AUTHOR='s/^.*<author>/"/
s/<\/author>.*$/"/'
RESULT_AUTHOR=`${GREP} -w author < ${TMPFILE1} | ${SED} -e "${SED_REFORMAT_AUTHOR}"`

echo '#define REVISION_SVN "" ' ${RESULT_REVISION} ' " " ' ${RESULT_DATE} ' " " ' ${RESULT_AUTHOR} ' ""' > ${TMPFILE2}
${CHMOD} 0644 ${TMPFILE2}
SED_REFORMAT_TIMESTAMP='s/"([0-9]{4})-([0-9]{2})-([0-9]{2})T([0-9]{2}):([0-9]{2}):([0-9]{2})\.([0-9]{6})Z"/\1\2\3\4\5\.\6/g'
${TOUCH} -t `echo ${RESULT_DATE} | ${SED} -E ${SED_REFORMAT_TIMESTAMP}` ${TMPFILE2}

${REMOVE} ${TMPFILE1}


${DIFF} -q $1 ${TMPFILE2} 2> /dev/null 1>&2
if [ $? -ne 0 ]; then
  ${MV} ${TMPFILE2} $1
  echo "$0: Done."
  exit 0
else
  ${REMOVE} ${TMPFILE2}
  echo "$0: Without change..."
  exit 0
fi

exit 1
# [ End of File ]
