/**@file
 *
 *@brief	QRL Maker
 *@date		Sun,06 Sep,2015 - Mon,08 Sep,2015
 *@date		Fri,11 Sep,2015 - Sat,12 Sep,2015
 *@date		Sun,20 Sep,2015 - Tue,29 Sep,2015
 *@date		Sat,03 Oct,2015 - Sun,04 Oct,2015
 *@date		Sun,11 Oct,2015 - Mon,12 Oct,2015
 *@date		Wed,14 Oct,2015 - Fri,16 Oct,2015
 *@date		Sun,18 Oct,2015
 *@date		Mon,26 Oct,2015 - Thu,29 Oct,2015
 *@date		Sat,31 Oct,2015
 *@date		Sun,22 Nov,2015
 *@date		Sun,10 Jan,2016 - Mon,11 Jan,2016
 *@date		Thu,11 Feb,2016 - Sun,14 Feb,2016
 *@date		Sun,16 Jul,2017
 *@date		Fri,21 Jul,2017
 *@date		Sun,23 Jul,2017
 *@date		Fri,18 Aug,2017
 *@date		Sat,03 Mar,2018
 *@date		Sat,17 Mar,2018
 *@date		Sat,27 Oct,2018
 *@date		Tue,27 Nov,2018 - Thu,29 Nov,2018
 *@date		Mon,24 Dec,2018
 *@date		Fri,28 Dec,2018
 *@date		Sat,29 Dec,2018
 *@date		Sat,19 Jan,2019
 *@date		Sun,20 Jan,2019
 *@date		Tue,29 Jan,2019
 *@date		Sat,16 Feb,2019
 *@date		Tue,19 Feb,2019
 *@date		Sun,13 Sep,2020
 *@date		Sun,18 Oct,2020
 *@date		Wed,28 Oct,2020
 *@date		Sat,31 Oct,2020
 *@date		Sun,08 Nov,2020
 *@date		Wed,18 Nov,2020
 *@date		Sat,21 Nov,2020
 *@date		Wed,02 Dec,2020
 *@date		Sun,27 Dec,2020
 *@date		Thu,18 Feb,2021
 *@date		Sat,20 Feb,2021
 *@date		Sun,21 Feb,2021
 *@date		Tue,23 Feb,2021
 *@date		Sun,23 May,2021
 *@date		Sun,10 Oct,2021
 *@date		Sat,30 Oct,2021
 *@date		Mon,21 Feb,2022
 *@date		Thu,07 Jul,2022
 *@date		Fri,08 Jul,2022
 *@date		Wed,13 Jul,2022
 *@date		Sun,17 Jul,2022
 *@date		Mon,09 Jan,2023
 *@date		Sat,18 Feb,2023
 *@date		Sat,25 Feb,2023
 *@date		Sat,27 May,2023
 *
 *@author	Copyright(C)2015-2023 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef SETTINGS_H
#define SETTINGS_H

#include <cstdint>
#include "qrl_type.h"
#include <QSettings>
#include <QString>
#include <QPoint>
#include <QSize>

namespace Settings {

#define	RO(T, NAME)	private: T NAME; public: const T& get_##NAME(void) const { return (NAME); }
#define	RW(T, NAME)	private: T NAME; public: const T& get_##NAME(void) const { return (NAME); }; void set_##NAME(const T& ARG) { NAME = ARG; return; }

struct App_Config { public: explicit App_Config(void) noexcept;
RO(QString, OrgName);
RO(QString, AppName);
RW(QString, HomePath);
RW(QString, DefaultPath);
};

struct SettingsKeyValue_Key {
	const QString mainwindow_settings;
	// const QString mainwindow_geometry;
	const QString mainwindow_size;
	const QString mainwindow_pos;
	const QString mainwindow_centralwidget_size;
	//const QString mainwindow_gridLayout;
	//const QString mainwindow_gridLayout_0G;
	const QString mainwindow_splitter_1V_size;
	const QString mainwindow_splitter_2H_size;
	const QString mainwindow_Form_TreeWidget_size;
	const QString mainwindow_layoutWidget;
	//const QString mainwindow_gridLayout_3G;
	const QString mainwindow_form_mainform_size;
	//const QString mainwindow_horizontalLayout;
	const QString mainwindow_horizontalSlider_size;
	const QString mainwindow_verticalScrollBar_size;
	const QString mainwindow_horizontalScrollBar_size;
	const QString mainwindow_listWidget_size;
	const QString mainwindow_menubar_size;
	const QString mainwindow_statusbar_size;
	//const QString mainwindow_splitter_1V_state;
	const QString mainwindow_splitter_1V_sizes;
	//const QString mainwindow_splitter_2H_state;
	const QString mainwindow_splitter_2H_sizes;
	const QString mainwindow_form_mainform_scaling_dB;
	const QString dialog_inputdialog_size;
	const QString dialog_inputdialog_pos;
	const QString dialog_listdialog_size;
	const QString dialog_listdialog_pos;
	const QString mainwindow_Form_TreeWidget_expanded;
	const QString mainwindow_DoubleClickInterval;
	const QString mainwindow_DragScrollTimer;
};

struct SettingsKeyValue_Value {
	QPoint dialog_inputdialog_pos;
	QSize  dialog_inputdialog_size;
	QPoint dialog_listdialog_pos;
	QSize  dialog_listdialog_size;
};


struct QRLChip_Library {
const struct {
const char* const EditorCommand;
const char* const ChipLabel;
const char* const ChipLibrary;
const char* const ChipArgument;
const char* const ChipArgumentList;
} tr_context;
const struct {
const char* const Label;
const char* const Chip;
const char* const ArgumentComment;
const char* const ArgumentList;
} tr_disambiguation;
const struct {
const QString LuaChipDir;
const QString LuaContainer_Filename_Header;
const QString LuaContainer_Filename_Stamp;
const QString LuaContainer_Filename_Footer;
const QString LuaChip_Filename_Header;
const QString LuaChip_Filename_Wildcard;
const QString LuaChip_Filename_Label_ext;
const QString LuaChip_Filename_Chip_ext;
const QString LuaChip_Filename_Image_ext;
const uint_fast8_t LuaChip_Filename_MaxNestLevel;
} LibraryFile;
const struct QRL_Syntax {
const QString Begin;
const QString Body;
const QString End;
const struct QRL_Header {
const QString name;
const QString size;
const QString footprint;
const QString footprint_header_substance;
const QString address;
const QString chip_coordinates_tag;
const QString chip_number_tag;
const QString chip_number;
const QString chip_footprint_tag;
const QString next_address_condition_true_coordinates_tag;
const QString next_address_condition_true_tag;
const QString next_address_condition_true;
const QString next_address_condition_false_coordinates_tag;
const QString next_address_condition_false_tag;
const QString next_address_condition_false;
const QString argument_num;
const QString argument_comment;
const QString argument_arg;
const QString argument_tag;
const QString argument_tag_raw;
const QString argument_type;
const struct Argument_Type {
enum ArgumentType_Kind { VAR, NUM, VAR_NUM, STRING, LABEL, LIST, SENTINEL } kind;
const QString label;
const char* const comment;
} argument_type_kind[Argument_Type::SENTINEL + 1];
const QString argument_type_selected;
const QString argument_list;
const QString argument_position;
const QString argument_closebracket;
const QString argument_geometry;
const QString argument_geometry_regex;
} Header;
const struct QRL_Argument {
const QString regex_num;
struct QRL_Argument_Type_Num_List {
	const QString regex;
	const QString syntax;
	const QString argument;
};
const struct QRL_Argument_Type_Num_List * const argument_type_num;
const QString regex_var;
const QString regex_str;
const QString regex_label;
const QString var_syntax;
const QString var_argument;
} Argument;
const QString Label_OutOfRange;
} Syntax;
const struct {
const struct {
const QRL::QRLChipNumber Max;
const uint_fast8_t Digit;
} Number;
const struct {
const QRL::ChipAddr Max;
const uint_fast8_t Digit;
const QRL::QRLChipArrowAddress Base;
} Address;
const struct {
const QRL::QRLChipArrowAddress Max;
const uint_fast8_t Digit;
} Arrow;
const int_fast8_t Undo;
} Limit;
const QSize Icon_size;
};

struct RGB {
const uint_fast8_t R;
const uint_fast8_t G;
const uint_fast8_t B;
};

struct BuildImage_Info {
const uint_fast16_t GaugeSize;
const uint_fast16_t EdgeSize;
const struct {
const uint_fast16_t OverlappingSize;
const uint_fast16_t GapSize;
const uint_fast16_t CoreSize;
const struct QRL::ChipAddrXY Count;
} Chip;
const struct {
const struct RGB Background;
const struct RGB GaugeText;
const struct RGB Line;
const struct RGB ChipText;
} Color;
const struct {
const int_fast16_t GaugeTextPointSize;
const int_fast16_t GaugeTextLength;
const int_fast16_t ChipTextPointSize;
} Font;
};

struct OverlayImage_Info {
enum CursorType { CURSOR_TYPE_MIN = 0, CURSOR_TYPE_FOCUS = 0, CURSOR_TYPE_SELECT, CURSOR_TYPE_HIGHLIGHT, CURSOR_TYPE_MAX = CURSOR_TYPE_HIGHLIGHT };
const struct OverlayImage_File {
const QString ImageDir;
const QString Cursor[Settings::OverlayImage_Info::CURSOR_TYPE_MAX + 1];
const QString ArrowImage_True;
const QString ArrowImage_False;
const QString ArrowImage_Ext;
} File;
};

struct QRLData_Info {
const struct {
const QString DataDir;
const QString Prefix;
const QString QRLMap_Ext;
const QString QRLMap_Backup_Ext;
const QString QRLMap_Image_Ext;
} File;
};

struct EditorCommand {
enum EditorCommand_TYPE { NONE = 0, NORMAL, SELECT, RECTANGULAR, CUT, PASTE, DELETE, SET_ARROW_TRUE, SET_ARROW_FALSE, EDIT_ARGUMENT, PUT_CHIP } type;
const char* const label;
};

struct Mouse_Info { public: explicit Mouse_Info(void) noexcept;
RW(int, DoubleClickInterval);	/**< [ms] */
RW(int, DragScrollTimer);		/**< [ms] */
};


extern struct App_Config AppConfig;
extern QSettings* ini;
extern const struct SettingsKeyValue_Key SettingsKey;
extern struct SettingsKeyValue_Value SettingsCandidates;
extern const struct QRLChip_Library QRLChipLibrary;
extern const struct BuildImage_Info BuildImage;
extern const struct OverlayImage_Info OverlayImage;
extern const struct QRLData_Info QRLData;
extern const struct EditorCommand EditorCommands[];
extern struct Mouse_Info Mouse;

}

#endif // SETTINGS_H
// [ End of File ]
