[FORMAT "WCOFF"]
[INSTRSET "i486p"]
[BITS 32]
[FILE "asmfunc.nas"]

	GLOBAL _io_hlt,_io_cli,_io_sti,_io_stihlt
	GLOBAL _io_in_eight,_io_in_sixteen,_io_in_thirtytwo
	GLOBAL _io_out_eight,_io_out_sixteen,_io_out_thirtytwo
	GLOBAL _io_load_eflags,_io_store_eflags
	GLOBAL _load_gdtr,_load_idtr
	GLOBAL _asm_keyboard_handler,_asm_mouse_handler
	GLOBAL _asm_timer_handler,_asm_athlon,_asm_general_exception_handler
	GLOBAL _asm_stack_exception
	GLOBAL _load_cr0,_store_cr0
	GLOBAL _store_cr3
	GLOBAL _load_tr,_farjmp,_farcall,_asm_cons_putchar
	GLOBAL _inpg,_paging_on
	GLOBAL _asm_hrb_api,_start_app,_asm_end_app
	GLOBAL _clts,_fnsave,_frstor,_asm_fpuhandler
	GLOBAL _asm_fdc_handler,_asm_pagingfalut_handler
	EXTERN _keyboard_handler,_mouse_handler
	EXTERN _timer_handler,_general_exception_handler
	EXTERN _athlon,_stack_exception
	EXTERN _print_cons_char,_hrb_api
	EXTERN _fpuhandler,_fdc_handler
	EXTERN _pagingfalut_handler

[SECTION .text]

_io_hlt:	; void io_hlt(void);
	HLT
	RET

_io_cli:	; void io_cli(void);
	CLI
	RET

_io_sti:	; void io_sti(void);
	STI
	RET

_io_stihlt:	; void io_stihlt(void);
	STI
	HLT
	RET

_io_in_eight:	; int io_in_eight(int port);
	MOV	EDX,[ESP+4]	; port
	MOV	EAX,0
	IN	AL,DX
	RET

_io_in_sixteen:	; int io_in_sixteen(int port);
	MOV	EDX,[ESP+4]	; port
	MOV	EAX,0
	IN	AX,DX
	RET

_io_in_thirtytwo:	; int io_in_thirtytwo(int port);
	MOV	EDX,[ESP+4]	; port
	IN	EAX,DX
	RET

_io_out_eight:	; void io_out_eight(int port, int data);
	MOV	EDX,[ESP+4]	; port
	MOV	AL,[ESP+8]	; data
	OUT	DX,AL
	RET

_io_out_sixteen:	; void io_out_sixteen(int port, int data);
	MOV	EDX,[ESP+4]	; port
	MOV	EAX,[ESP+8]	; data
	OUT	DX,AX
	RET

_io_out_thirtytwo:	; void io_out_thirtytwo(int port, int data);
	MOV	EDX,[ESP+4]	; port
	MOV	EAX,[ESP+8]	; data
	OUT	DX,EAX
	RET

_io_load_eflags:	; int io_load_eflags(void);
	PUSHFD	; PUSH EFLAGS ƂӖ
	POP	EAX
	RET

_io_store_eflags:	; void io_store_eflags(int eflags);
	MOV	EAX,[ESP+4]
	PUSH	EAX
	POPFD	; POP EFLAGS ƂӖ
	RET
_load_gdtr:	; void load_gdtr(int limit, int addr);
	MOV	AX,[ESP+4]	; limit
	MOV	[ESP+6],AX
	LGDT	[ESP+6]
	RET

_load_idtr:	; void load_idtr(int limit, int addr);
	MOV	AX,[ESP+4]	; limit
	MOV	[ESP+6],AX
	LIDT	[ESP+6]
	RET
_asm_keyboard_handler:
	PUSH	ES
	PUSH	DS
	PUSHAD
	MOV	EAX,ESP
	PUSH	EAX
	MOV	AX,SS
	MOV	DS,AX
	MOV	ES,AX
	CALL	_keyboard_handler
	POP	EAX
	POPAD
	POP	DS
	POP	ES
	IRETD
_asm_athlon:
	PUSH	ES
	PUSH	DS
	PUSHAD
	MOV	EAX,ESP
	PUSH	EAX
	MOV	AX,SS
	MOV	DS,AX
	MOV	ES,AX
	CALL	_athlon
	POP	EAX
	POPAD
	POP	DS
	POP	ES
	IRETD

_asm_mouse_handler:
	PUSH	ES
	PUSH	DS
	PUSHAD
	MOV	EAX,ESP
	PUSH	EAX
	MOV	AX,SS
	MOV	DS,AX
	MOV	ES,AX
	CALL	_mouse_handler
	POP	EAX
	POPAD
	POP	DS
	POP	ES
	IRETD

_asm_timer_handler:
	PUSH	ES
	PUSH	DS
	PUSHAD
	MOV	EAX,ESP
	PUSH	EAX
	MOV	AX,SS
	MOV	DS,AX
	MOV	ES,AX
	CALL	_timer_handler
	POP	EAX
	POPAD
	POP	DS
	POP	ES
	IRETD

_asm_general_exception_handler:
	STI
	PUSH	ES
	PUSH	DS
	PUSHAD
	MOV	EAX,ESP
	PUSH	EAX
	MOV	AX,SS
	MOV	DS,AX
	MOV	ES,AX
	CALL	_general_exception_handler
	CMP	EAX,0	; Ⴄ
	JNE	_asm_end_app	; Ⴄ
	POP	EAX
	POPAD
	POP	DS
	POP	ES
	ADD	ESP,4		; INT 0x0d ł́AꂪKv
	IRETD

_load_cr0:	; int load_cr0(void);
	MOV	EAX,CR0
	RET

_store_cr0:	; void store_cr0(int cr0);
	MOV	EAX,[ESP+4]
	MOV	CR0,EAX
	RET
_load_tr:
	LTR [ESP+4]
	RET
_farjmp:
	JMP FAR[ESP+4]
	RET
_farcall:
	CALL FAR [ESP+4]
	RET
_asm_cons_putchar:
	STI
	PUSHAD
	PUSH	7
	AND	EAX,0xff	; AHEAX̏ʂ0ɂāAEAXɕR[hԂɂB
	PUSH	EAX
	PUSH	DWORD [0x0fec]	; ̓eǂݍł̒lPUSH
	CALL	_print_cons_char
	ADD	ESP,12	; X^bNɐς񂾃f[^̂Ă
	POPAD
	IRETD
_asm_hrb_api:
	STI
	PUSH	DS
	PUSH	ES
	PUSHAD	; ۑ̂߂PUSH
	PUSHAD	; hrb_apiɂ킽߂PUSH
	MOV	AX,SS
	MOV	DS,AX	; OSp̃ZOgDSESɂ
	MOV	ES,AX
	CALL	_hrb_api
	CMP	EAX,0	; EAX0łȂ΃AvI
	JNE	_asm_end_app
	ADD	ESP,32
	POPAD
	POP	ES
	POP	DS
	IRETD

_start_app:	; void start_app(int eip, int cs, int esp, int ds,int *tss_esp0);
	PUSHAD	; 32rbgWX^SۑĂ
	MOV	EAX,[ESP+36]	; AvpEIP
	MOV	ECX,[ESP+40]	; AvpCS
	MOV	EDX,[ESP+44]	; AvpESP
	MOV	EBX,[ESP+48]	; AvpDS/SS
	MOV	EBP,[ESP+52]	; tss.esp0̔Ԓn
	MOV	[EBP  ],ESP	; OSpESPۑ
	MOV	[EBP+4],SS	; OSpSSۑ
	MOV	ES,BX
	MOV	DS,BX
	MOV	FS,BX
	MOV	GS,BX
;	ȉRETFŃAvɍs邽߂̃X^bN
	OR	ECX,3		; Avp̃ZOgԍ3OR
	OR	EBX,3		; Avp̃ZOgԍ3OR
	PUSH	EBX		; AvSS
	PUSH	EDX		; AvESP
	PUSH	ECX		; AvCS
	PUSH	EAX		; AvEIP
	RETF
;	AvIĂɂ͗Ȃ
_asm_stack_exception:
	STI
	PUSH	ES
	PUSH	DS
	PUSHAD
	MOV	EAX,ESP
	PUSH	EAX
	MOV	AX,SS
	MOV	DS,AX
	MOV	ES,AX
	CALL	_stack_exception
	CMP	EAX,0
	JNE	_asm_end_app
	POP	EAX
	POPAD
	POP	DS
	POP	ES
	ADD	ESP,4		; INT 0x0c łAꂪKv
	IRETD
_asm_end_app:
;	EAXtss.esp0̔Ԓn
	MOV	ESP,[EAX]
	MOV	DWORD [EAX+4],0
	POPAD
	RET			; cmd_app֋A
_clts:          ; void clts(void);
        CLTS
        RET

_fnsave:        ; void fnsave(int *addr);
        MOV     EAX,[ESP+4]     ; addr
        FNSAVE  [EAX]
        RET

_frstor:        ; void frstor(int *addr);
        MOV     EAX,[ESP+4]     ; addr
        FRSTOR  [EAX]
        RET

_asm_fpuhandler:
        STI
        PUSH    ES
        PUSH    DS
        PUSHAD
        MOV     EAX,ESP
        PUSH    EAX
        MOV     AX,SS
        MOV     DS,AX
        MOV     ES,AX
        CALL    _fpuhandler
        CMP     EAX,0
        JNE     _asm_end_app
        POP     EAX
        POPAD
        POP     DS
        POP     ES
        IRETD
        ; INT07ł ESP += 4; ͂Ȃ
_asm_fdc_handler:
	PUSH	ES
	PUSH	DS
	PUSHAD
	MOV	EAX,ESP
	PUSH	EAX
	MOV	AX,SS
	MOV	DS,AX
	MOV	ES,AX
	CALL	_fdc_handler
	POP	EAX
	POPAD
	POP	DS
	POP	ES
	IRETD
_asm_pagingfalut_handler:
	PUSH	ES
	PUSH	DS
	PUSHAD
	MOV	EAX,ESP
	PUSH	EAX
	MOV	AX,SS
	MOV	DS,AX
	MOV	ES,AX
	CALL	_pagingfalut_handler
	POP	EAX
	POPAD
	POP	DS
	POP	ES
	IRETD
_store_cr3:	; void store_cr3(int cr0);
	MOV	EAX,[ESP+4]
	MOV	CR3,EAX
	RET
_inpg:
	MOV	EAX,[ESP+4]
	INVLPG	[EAX]
	RET

_paging_on:
	PUSH EAX
	MOV EAX,CR0
	OR EAX,0x80000000
	MOV CR0,EAX
	POP EAX
	RET
