/* UDOSq */
#include "head.h"

static void  *emalloc (int size);

static struct FAT_info FAT_info;

static void *
emalloc (int size)
{ 
    void *p = malloc (size);
    if (p == NULL) perror ("malloc");
    return p;
}
void
decode_dirent (unsigned char *ptr, struct FAT_dirent *dirent)
{
    memcpy (dirent->name, ptr, FILENAME_LEN);
    dirent->name [FILENAME_LEN] = '\0';
    dirent->attr = ptr [11];
    dirent->size = ptr [28] | (ptr [29] << 8)
	    | (ptr [30] << 16) | (ptr [31] << 24);
    dirent->clus_num = ptr [26] | (ptr [27] << 8);
    /* Note: fatgen103.pdf says ptr[20] and ptr[21] are always 0
       for FAT12/FAT16, but not in some implementation. So, we
       ignore ptr[20] and ptr[21]. | (ptr [20] << 16) | (ptr [21] << 24); */
}
void
encode_dirent (unsigned char *ptr, struct FAT_dirent *dirent)
{
    memcpy (ptr, dirent->name, FILENAME_LEN);
    ptr [11] = dirent->attr;
    ptr [28] = dirent->size             & 0xFF;
    ptr [29] = (dirent->size >> 8)      & 0xFF;
    ptr [30] = (dirent->size >> 16)     & 0xFF;
    ptr [31] = (dirent->size >> 24)     & 0xFF;
    ptr [26] = dirent->clus_num         & 0xFF;
    ptr [27] = (dirent->clus_num >> 8)  & 0xFF;
    ptr [20] = (dirent->clus_num >> 16) & 0xFF;
    ptr [21] = (dirent->clus_num >> 24) & 0xFF;
    ptr [12] = 0; /* initialize reserved area */

    /* initialized time stamps with the epoch time */
    ptr [13] = 0;                /* CrtTimeTenth */
    ptr [14] = ptr [15] = 0;     /* CrtTime */
    ptr [16] = ptr [17] = 0;     /* CrtDate */
    ptr [18] = ptr [19] = 0;     /* LstAccDate */
    ptr [22] = ptr [23] = 0;     /* WrtTime */
    ptr [24] = ptr [25] = 0;     /* WrtDate */
}

void
read_dirent (int clus_num, int clus_offset, struct FAT_dirent *dirent)
{
    if (clus_num == ROOT_DIR_CLUS_NUM) {
	decode_dirent (FAT_info.RootDir + clus_offset, dirent);
    } else {
	unsigned char *buf = emalloc (FAT_info.BytsPerClus);
	read_cluster (buf, clus_num);
	decode_dirent (buf + clus_offset, dirent);
	free (buf);
    }
    dirent->entry.clus_num    = clus_num;
    dirent->entry.clus_offset = clus_offset;
}

void
write_dirent (int clus_num, int clus_offset, struct FAT_dirent *dirent)
{
    if (clus_num == ROOT_DIR_CLUS_NUM) {
	encode_dirent (FAT_info.RootDir + clus_offset, dirent);
    } else {
	unsigned char *buf = emalloc (FAT_info.BytsPerClus);
	read_cluster (buf, clus_num);
	encode_dirent (buf + clus_offset, dirent);
	write_cluster (buf, clus_num);
	free (buf);
    }
}

int
search_dirent (int dir_clus_num, const char *filename,
	       struct FAT_dirent *dirent)
{
    struct FILEHANDLE file;

    if ((dir_clus_num == ROOT_DIR_CLUS_NUM)
	&& (!strncmp (filename, DIR_DOT, FILENAME_LEN)
	    || !strncmp (filename, DIR_DOTDOT, FILENAME_LEN))) {
	*dirent = FAT_info.DummyRootDirent;
	return 0;
    }
    /* fate[u𖼑Oł[邽߂Ƀt@C\̂ԂグB */
    /* to call FAT12_readdir without FAT12_open */
    file.flag                     = O_RDONLY;
    file.pos           = 0;
    memcpy (file.dirent.name, filename, FILENAME_LEN + 1);
    file.dirent.attr              = ATTR_DIRECTORY;
    file.dirent.size              = 0;
    while (FAT12_readdir (&file, dirent, 1) > 0) {
	if (!strncmp (filename, dirent->name, FILENAME_LEN))
	    return 0;		/* FATe[u疼OTĂ */
    }
    /* if(search_name_from_fattable){ */
    /*   return ok; */
    /* } */
    return -1;
}

int
create_dirent (const char *path, struct FAT_dirent *new_dirent,
	       int attr, int clus_num)
{
    char *dir, filename [FILENAME_LEN + 1];
    struct FILEHANDLE file;
    int ret;

    new_dirent->size     = 0;
    new_dirent->attr     = attr;

    ret = FAT12_open (&file, path, O_RDONLY); /* create_fileƓ */

    if (ret != -1) {
	printf ("create_dirent: already exists: %s\n", path);
	goto error;
    }
    FAT12_close (&file);
    dir = divide_path_right (path, filename);
    ret = FAT12_open (&file, dir, O_RDWR);
    if (ret == -1) {
	printf ("create_dirent: No such directory: %s\n", dir);
	goto error;
    }
    if (!is_directory (&file.dirent)) {
	printf ("create_dirent: Not directory: %s\n", dir);
	goto error;
    }

    memcpy (new_dirent->name, filename, FILENAME_LEN + 1);
    ret = FAT12_writedir (&file, new_dirent, 1);
    FAT12_close (&file);
    free (dir);
    return 0;
 error:
    FAT12_close (&file);
    free (dir);
    return -1;
}

/* like namei in BSD */
int
path_to_dirent (const char *path, struct FAT_dirent *dirent)
{
  const char *dir = path;
  int ret, clus_num;

  while (1) {
    char file [FILENAME_LEN + 1];
    dir = divide_path_left (dir, file); /* ? */
    ret = search_dirent (clus_num, file, dirent); /* ̑Oɖ{clus_num̏̂Ă܂? */
    /* search_dirent̏C̑OŃ_EB͂06/24 */
    if (ret == -1)
      return -1;
    clus_num = dirent->clus_num;
    if (dir == NULL)
      break;
  }
  return 0;
}

int
get_FAT12_entry (int clus_num)
{
    int FAT_entry;
    int FATOffset = clus_num + (clus_num / 2);

    if (clus_num % 2 == 0) { /* cluster number is even */
	FAT_entry = (FAT_info.FAT [FATOffset] & 0xFF)
		    | ((FAT_info.FAT [FATOffset + 1] << 8) & 0xF00);
    } else {                 /* cluster number is odd  */
	FAT_entry = ((FAT_info.FAT [FATOffset] >> 4) & 0xF)
		    | ((FAT_info.FAT [FATOffset + 1] << 4) & 0xFF0);
    }
    return FAT_entry;
}

void
set_FAT12_entry (int clus_num, int value)
{
    int FATOffset = clus_num + (clus_num / 2);

    if (clus_num % 2 == 0) { /* cluster number is even */
	FAT_info.FAT [FATOffset] = value & 0xFF;
	FAT_info.FAT [FATOffset + 1] = (FAT_info.FAT [FATOffset + 1] & 0xF0)
	                               | ((value >> 8) & 0x0F);
    } else {                 /* cluster number is odd  */
	FAT_info.FAT [FATOffset] = (FAT_info.FAT [FATOffset] & 0x0F)
	                           | ((value << 4) & 0xF0);
	FAT_info.FAT [FATOffset + 1] = (value >> 4) & 0xFF;
    }
}
void
read_cluster (void *buf, int clus_num)
{
    int offset = (FAT_info.FirstDataSector +
		  (clus_num - 2) * FAT_BPB.SecPerClus) * FAT_BPB.BytsPerSec;
    fs_read  (buf, FAT_info.BytsPerClus, offset);
}

void
write_cluster (void *buf, int clus_num)
{
    int offset = (FAT_info.FirstDataSector +
		  (clus_num - 2) * FAT_BPB.SecPerClus) * FAT_BPB.BytsPerSec;
    fs_write  (buf, FAT_info.BytsPerClus, offset);
}
int
path_to_dirent (const char *path, struct FAT_dirent *dirent)
{
  const char *dir = path;
  int ret;
  if (!strcmp (path, "/")) {
    *dirent = FAT_info.DummyRootDirent;
    return 0;
  }
  while (1) {
    char file [FILENAME_LEN + 1];
    dir = divide_path_left (dir, file);
    ret = search_dirent (clus_num, file, dirent); /* ۂɂfile_searchăNX^io[ԂĂĂ邾BƂŉ */
    if (ret == -1){
      return -1;
    }
    if (dir == NULL)
      break;
  }
  return 0;
}
/* "/usr/bin/ls" -> return="/usr/bin", file="LS         " */
char *
divide_path_right (const char *path, char *file)
{
  char *s;
  char *path2 = emalloc (strlen (path) + 1);

  memcpy (path2, path, strlen (path) + 1);
  s = strrchr (path2, '/');
  if (s == NULL) {
    normalize_name (path2, file);
    free (path2);
    return strdup (DIR_DOT);
  } else {
    *s = '\0';
    normalize_name (s + 1, file);
    if (*path2 == '\0') {
      free (path2);
      return strdup (DIR_ROOT);
    } else {
      return path2;
    }
  }
}


int
FAT12_readdir (struct FILEHANDLE *fp, struct FAT_dirent *dirent, int skip_invalid)
{
  int n_bytes;
  uint8_t ptr [DIRENT_SIZE];

  while (1) {
    dirent->entry.clus_num    = fp->current_clus_num;
    dirent->entry.clus_offset = fp->current_clus_offset;
    /* ܂ł͂ */
    n_bytes=file_read(fp,ptr,DIRENT_SIZE);
    decode_dirent (ptr, dirent);
    if (n_bytes < DIRENT_SIZE || is_end_of_directory (dirent))
      break;
    if (!skip_invalid || !is_invalid_dirent (dirent))
      return n_bytes;
  }
  return 0;
}

int
FAT12_writedir (struct FILEHANDLE *fp, struct FAT_dirent *dirent, int skip_used)
{
  uint8_t ptr [DIRENT_SIZE];
  struct FAT_dirent dirent_tmp;
  int n_bytes, ret;

  while (1) {
    n_bytes = FAT12_read (fp, ptr, DIRENT_SIZE);
    decode_dirent (ptr, &dirent_tmp);
    if (n_bytes < DIRENT_SIZE)
      perror ("FAT12_writedir: read error");
    if (is_end_of_directory (&dirent_tmp))
      break;
    if (!skip_used || (uint8_t)dirent_tmp.name [0] == DIRENT_UNUSED)
      break;
  }
  FAT12_seek (fp, -DIRENT_SIZE, SEEK_CUR);
  dirent->entry.clus_num    = fp->current_clus_num;
  dirent->entry.clus_offset = fp->current_clus_offset;
  encode_dirent (ptr, dirent);
  ret = FAT12_write (fp, ptr, DIRENT_SIZE);

  /* write EndOfDir */
  if (!is_end_of_directory (dirent) && is_end_of_directory (&dirent_tmp)) {
    dirent_tmp = *dirent;
    dirent_tmp.name [0] = DIRENT_END_DIR;
    encode_dirent (ptr, &dirent_tmp);
    ret = FAT12_write (fp, ptr, DIRENT_SIZE);
    FAT12_seek (fp, -DIRENT_SIZE, SEEK_CUR);
  }
  return ret;
}

int
FAT12_seek   (struct FILEHANDLE *fp, int offset, int whence)
{
  switch (whence) {
  case SEEK_SET: fp->pos = offset;  break;
  case SEEK_CUR: fp->pos += offset; break;
  case SEEK_END: fp->pos = get_filesize (&fp->dirent) + offset;
    break;
  default:       return -1;
  }
  if (fp->pos < 0) {
    printf ("FAT12_seek: negative offset: %d\n", fp->pos);
    fp->pos = 0;
  }
  calc_clus_num_offset (fp, &fp->current_clus_num, &fp->current_clus_offset);
  return 0;
}
int
FAT12_rmdir  (const char *path)
{
  struct FILEHANDLE file_dot;
  struct FAT_dirent dirent;
  int ret, n_files;

  ret = FAT12_open (&file_dot, path, O_RDONLY);
  if (ret == -1) {
    printf ("FAT12_rmdir: No such directory: %s\n", path);
    return -1;
  }
  if (!is_directory (&file_dot.dirent)) {
    printf ("FAT12_rmdir: No directory: %s\n", path);
    return -1;
  }

  n_files = 0;
  while (FAT12_readdir (&file_dot, &dirent, 1) > 0)
    n_files++;
  if (n_files > 2) {
    printf ("FAT12_rmdir: Directory not empty: %s\n", path);
    return -1;
  }
  FAT12_close (&file_dot);

  FAT12_unlink (path);
  return 0;
}

int
FAT12_unlink (const char *path)
{
  int ret;
  struct FAT_dirent dirent;
  ret = path_to_dirent (path, &dirent);
  if (ret == -1) {
    printf ("FAT12_unlink: No such file: %s\n", path);
    return -1;
  }
  free_cluster_chain (dirent.clus_num);
  dirent.clus_num = CLUSTER_FREE;
  dirent.name [0] = DIRENT_UNUSED;
  write_dirent (dirent.entry.clus_num, dirent.entry.clus_offset, &dirent);
  return 0;
}

/* Tu֐ */
int
is_end_of_directory (struct FAT_dirent *dirent)
{
  return (uint8_t)dirent->name [0] == DIRENT_END_DIR;
}
int
is_invalid_dirent (struct FAT_dirent *dirent)
{
  if ((uint8_t)dirent->name [0] == DIRENT_UNUSED)
    return 1;      /* unused entry */
  if ((dirent->attr & ATTR_LONG_NAME_MASK) == ATTR_LONG_NAME)
    return 1;      /* entry for long file name */
  if ((dirent->attr & (ATTR_VOLUME_ID | ATTR_DIRECTORY)) == ATTR_VOLUME_ID)
    return 1;      /* entry for volume name */
  return 0;
}
/* "/usr/bin/ls" or "usr/bin/ls" -> file="USR        ", return="bin/ls".
   Note: divide_path_{right, left} are not symmetric. */
const char *
divide_path_left (const char *path, char *file)
{
  char *s;
  char short_filename [FILENAME_LEN + 1];

  if (*path == '/') path++;
  s = strchr (path,  '/');
  if (s == NULL) {
    normalize_name (path, file);
    return NULL;
  } else {
    memset (short_filename, ' ', FILENAME_LEN);
    memcpy (short_filename, path, s - path);
    short_filename [s - path] = '\0'; 
    normalize_name (short_filename, file);
    return s + 1;
  }
}
void
normalize_name (const char *from, char *to)
{
  int i;

  memset (to, ' ', FILENAME_LEN);
  to [FILENAME_LEN] = '\0';

  if (!strncmp (from, "..", 2)) {
    memcpy (to, DIR_DOTDOT, FILENAME_LEN + 1);
    return;
  }
  if (!strncmp (from, ".", 1)) {
    memcpy (to, DIR_DOT,    FILENAME_LEN + 1);
    return;
  }

  for (i = 0; i < 8; i++) {
    if (*from == '.')  break;
    if (*from == '\0') return;
    to [i] = toupper (*from++);
  }
  while (*from != '\0' && *from++ != '.')
    ;
  for (i = 8; i < FILENAME_LEN; i++) {
    if (*from == '\0') break;
    to [i] = toupper (*from++);
  }
}
int
toupper (int c)
{
  if ('a' <= c && c <= 'z')
    return c + 'A' - 'a';
  else
    return c;
}
