#include "head.h"
extern struct biosinfo *basic;
extern struct wcontrol *window_control;
extern struct tcontrol *timer_control;
extern struct TASKCTL *task_control;
extern int *fat;
int *hrb_api(int edi,int esi,int ebp,int esp,int ebx,int edx,int ecx,int eax)
{
  struct TASK *task=task_now();
  int ds_base=task->ds_base;
  struct CONSOLE *cons=task->cons;
  struct window *window;
  int *reg=&eax+1;
  struct FILEHANDLE *fh;
  int i;
  if(edx==1) {
    print_cons_char(cons,eax&0xff,SIRO);
  }else if(edx==2) {
    print_cons(cons,(char *)ebx+ds_base,SIRO);
  }else if(edx==3) {
    cons_printstr1(cons,(char *)ebx+ds_base,ecx);
  }else if(edx==4){
    return &(task->tss.esp0);
  }else if(edx==5){
    window=make_window(ebx,eax,esi,edi,"APLI");
    window->task=task;
    window->use|=0x10;
    move_window(window,ebx,eax);
    switch_window(window,window_control->top);
    keywin_on(window);
    reg[7]=(int)window;
  }else if(edx==6){
    window=(struct window *)ebx;
    print(window,(char *)ebp+ds_base,esi,edi,eightbit_to_16bit(eax));
  }else if(edx==7){
    window=(struct window *)ebx;
    box(window,eax,ecx,esi,edi,eightbit_to_16bit(ebp));
  }else if(edx==8){
    manager_init((struct manager *)(ebx+ds_base));
    ecx&=0xfffffff0;
    free((struct manager *)(ebx+ds_base),eax,ecx);
  }else if(edx==9){
    ecx=(ecx+0x0f)&0xfffffff0;
    reg[7]=alloc((struct manager *)(ebx+ds_base),ecx);
  }else if(edx==10){
    ecx=(ecx+0x0f)&0xfffffff0;
    free((struct manager *)(ebx+ds_base),eax,ecx);
  }else if(edx==11){
    window=(struct window *)ebx;
    dot(window,esi,edi,eightbit_to_16bit(eax));
  }else if(edx==12){
    window=(struct window *)ebx;
    refresh_window(window,eax,ecx,esi,edi);
  }else if(edx==13){
    int i;
    window=(struct window *)ebx;
    line(window,eax,ecx,esi,edi,eightbit_to_16bit(ebp));
    if(eax>esi){
      i=eax;
      eax=esi;
      esi=i;
    }
    if(ecx>edi){
      i=ecx;
      ecx=edi;
      edi=i;
    }
    refresh_window(window,eax,ecx,esi,edi);
  }else if(edx==14){
    window=(struct window *)ebx;
    close_window(window);
  }else if(edx==15){
    for(;;){
      io_cli();
      if(fifo_status(&task->fifo)==0){
	if(eax!=0){
	  task_sleep(task);
	}else{
	  io_sti();
	  reg[7]=-1;
	  return 0;
	}
      }
      i=fifo_out(&task->fifo);
      io_sti();
      if(i>=256){
	reg[7]=i-256;
	return 0;
      }
    }
  }else if(edx==16){
    reg[7]=(int)make_timer();
    ((struct timer *)reg[7])->apli=1;
  }else if(edx==17){
    setfifo((struct timer *)ebx,&(task->fifo));
    setdata_timer((struct timer *)ebx,eax+256);
  }else if(edx==18){
    timer_settime((struct timer *)ebx,eax);
  }else if(edx==19){
    free_timer((struct timer *)ebx);
  }else if(edx==20){
    if(eax==0){
      beepoff();
    }else{
      beepon(eax);
    }
  }else if(edx==21){
    int i;
    for(i=0;i<CONS_FILE_HANDLES;i++){
      if(task->fhandle[i].flag==0){
	break;
      }
    }
    if(i>=CONS_FILE_HANDLES){
      reg[7]=0;
    }else{
      reg[7]=(int)file_open(&task->fhandle[i],(char *)(ebx+ds_base),'r');
    }
  }else if(edx==22){
    fh=(struct FILEHANDLE *)eax;
    file_close(fh);
  }else if(edx==23){
    fh=(struct FILEHANDLE *)eax;
    if(ecx==0){
      fh->pos=ebx;
    }else if(ecx==1){
      fh->pos+=ebx;
    }else if(ecx==2){
      fh->pos=fh->size+ebx;
    }
    if(fh->pos<0){
      fh->pos=0;
    }
    if(fh->pos>fh->size){
      fh->pos=fh->size;
    }
  }else if(edx==24){
    fh=(struct FILEHANDLE *)eax;
    if(ecx==0){
      reg[7]=fh->size;
    }else if(ecx==1){
      reg[7]=fh->pos;
    }else if(ecx==2){
      reg[7]=fh->size-fh->pos;
    }
  }else if(edx==25){
    fh=(struct FILEHANDLE *)eax;
    reg[7]=file_read(fh,(char *)(ebx+ds_base),ecx);
  }else if(edx==26){
    int i=0;
    for(;;){
      *((char *)ebx+ds_base+i)=task->cons->cmdline[i];
      if(task->cons->cmdline[i]==0){
	break;
      }
      if(i>=ecx){
	break;
      }
      i++;
    }
    reg[7]=i;
  }else if(edx==27){
    window=make_window_apli((short *)(ebx+ds_base),esi,edi,"APLI");
    window->task=task;
    window->use|=0x10;
    move_window(window,0,0);
    switch_window(window,window_control->top);
    keywin_on(window);
    reg[7]=(int)window;
  }else if (edx == 0x1001) {
    /* Haritomo common API tomo_gettick() */
    reg[7] = timer_control->count;
  }else if (edx == 0x1004) {
    /* Haritomo common API tomo_sysinfo() */
    struct SYS_INFO *info = (struct SYS_INFO *) (eax + ds_base);
    info->cyls  = basic->cyls;
    info->leds  = basic->leds;
    info->vmode = basic->vmode;
    info->reserve = basic->reserve;
    info->scrnx = basic->fullx;
    info->scrny = basic->fully;
    info->vram  = basic->vram;
    info->os_type = 5; /* OSAkkie */
  }else if (edx == 0x1005) {
    /* Haritomo common API tomo_systime() */
    struct clock *c=(struct clock *)(eax+ds_base);
    clockGet(c);
  } else if (edx == 0x400a) {
    window = window_control->window_pointer[window_control->top];
    move_window(window,edi,esi);
    fifo_in(&task_control->task_mouse->fifo,0x4001);	/* }EXWXVv */
  } else if (edx == 0x400b) {
    struct MOUSE_INFO *info = (struct MOUSE_INFO *) (eax + ds_base);
    window =window_control->window_pointer[window_control->top];
    info->x = window->x;
    info->y = window->y;
  }
  return 0;
}
void cons_printstr0(struct CONSOLE *cons,char *s)
{
  for(;*s!=0;s++){
    print_cons_char(cons,*s,SIRO);
    return;
  }
}
void cons_printstr1(struct CONSOLE *cons,char *s,int l)
{
  int i;
  for(i=0;i<l;i++){
    print_cons_char(cons,s[i],SIRO);
  }
  return;
}
