#include "head.h"
/* PTE page table entry */
/* y[WɊւۑ */
#define DEF_PTE_FLAGS_P             0x00000001
#define DEF_PTE_FLAGS_RW            0x00000002
#define DEF_PTE_FLAGS_US            0x00000004
#define DEF_PTE_FLAGS_PWT           0x00000008
#define DEF_PTE_FLAGS_PCD           0x00000010
#define DEF_PTE_FLAGS_A             0x00000020
#define DEF_PTE_FLAGS_D             0x00000040
#define DEF_PTE_FLAGS_PAT           0x00000080
#define DEF_PTE_FLAGS_G             0x00000100
#define DEF_PTE_FLAGS_AVAILABLE     0x00000E00
#define DEF_PTE_FRAME_ADDRESS       0xFFFFF000
PAGE_TABLE *table;
/* PTEW߂΃y[We[uɂȂ */

void setPteFlags(PAGE_TABLE_ENTRY *entry,unsigned long flags)
{
  *entry|=flags;
  return;
}
void clearPteFlags(PAGE_TABLE_ENTRY *entry,unsigned long flags)
{
  *entry&=~flags;
}
void setPtePageFrameAddress(PAGE_TABLE_ENTRY *entry,unsigned long page_frame_address)
{
  page_frame_address &= DEF_PTE_FRAME_ADDRESS;
  *entry             |= page_frame_address;
  return;
}
unsigned long getPtePageFrameAddress(PAGE_TABLE_ENTRY *entry)
{
  return ( *entry & DEF_PTE_FRAME_ADDRESS );
}
int isPtePresent(PAGE_TABLE_ENTRY *entry)
{
  return ( ( *entry & DEF_PTE_FLAGS_P ) == DEF_PTE_FLAGS_P );
}
int isPteWritable( PAGE_TABLE_ENTRY* entry )
{
  return ( ( *entry & DEF_PTE_FLAGS_RW ) == DEF_PTE_FLAGS_RW );
}
/* PDE */
/* PTEW߂y[We[uW߂fBNgGg */
#define DEF_PDE_FLAGS_P             0x00000001
#define DEF_PDE_FLAGS_RW            0x00000002
#define DEF_PDE_FLAGS_US            0x00000004
#define DEF_PDE_FLAGS_PWT           0x00000008
#define DEF_PDE_FLAGS_PCD           0x00000010
#define DEF_PDE_FLAGS_A             0x00000020
#define DEF_PDE_FLAGS_RESERVED      0x00000040
#define DEF_PDE_FLAGS_PS            0x00000080
#define DEF_PDE_FLAGS_G             0x00000100
#define DEF_PDE_FLAGS_AVAILABLE     0x00000E00
#define DEF_PDE_PAGE_TABLE_ADDRESS  0xFFFFF000
unsigned long page_frame_address;
void setPdeFlags(PAGE_DIRECTORY_ENTRY *entry,unsigned long flags)
{
  *entry |= flags;
  return;
}
void clearPdeFlags(PAGE_DIRECTORY_ENTRY *entry,unsigned long flags)
{
  *entry &= ~flags;
}
void setPdePageFrameAddress(PAGE_DIRECTORY_ENTRY *entry,unsigned long page_table_address )
{
  page_frame_address &= DEF_PDE_PAGE_TABLE_ADDRESS;
  *entry             |= page_table_address;
}

unsigned long getPdePageTableAddress(PAGE_DIRECTORY_ENTRY *entry )
{
  return ( *entry & DEF_PDE_PAGE_TABLE_ADDRESS );
}

int isPdePresent(PAGE_DIRECTORY_ENTRY *entry )
{
  return ( ( *entry & DEF_PDE_FLAGS_P ) == DEF_PDE_FLAGS_P );
}

int isPdeWritable(PAGE_DIRECTORY_ENTRY *entry )
{
  return ( ( *entry & DEF_PDE_FLAGS_RW ) == DEF_PDE_FLAGS_RW );
}
/* z */
#define	DEF_MM_PAGE_SIZE            4096

#define	DEF_MM_KERNEL_START         0x00010000

#define	DEF_MM_PTE_INDEX_MASK       0x000003FF
#define	DEF_MM_PTE_INDEX_SHIFT      12

#define	DEF_MM_PDE_INDEX_MASK       0x000003FF
#define	DEF_MM_PDE_INDEX_SHIFT      22

#define	DEF_MM_NUM_PTE              1024
#define	DEF_MM_PAGE_TABLE_SIZE      ( sizeof( PAGE_TABLE_ENTRY ) * DEF_MM_NUM_PTE )
#define	DEF_MM_NUM_PDE              1024
#define	DEF_MM_PAGE_DIRECTORY_SIZE  ( sizeof( PAGE_DIRECTORY_ENTRY ) * DEF_MM_NUM_PDE )
#define	DEF_MM_OK                   0
#define	DEF_MM_ERROR                (-1)
/* y[Ẅƕ̈̊蓖ĂƊJ */
PAGE_TABLE_ENTRY *allocPage(PAGE_TABLE_ENTRY *entry)
{
  unsigned long *physical_address;

  physical_address =(unsigned long *) alloc4((struct manager *)(MANAGER_ADDR),4096);

  if(physical_address==0){
    return (PAGE_TABLE_ENTRY *)physical_address;
  }
  setPtePageFrameAddress(entry,(unsigned long)physical_address);
  setPteFlags( entry, DEF_PTE_FLAGS_P );

  return (PAGE_TABLE_ENTRY *)physical_address;
}
void freePage(PAGE_TABLE_ENTRY *entry)
{
  unsigned long *physical_address;
  physical_address=(unsigned long *)getPtePageFrameAddress(entry);

  if(physical_address==0){
    return;
  }
  free4((struct manager *)(MANAGER_ADDR),(unsigned int)physical_address,4096);
  clearPteFlags(entry,DEF_PTE_FLAGS_P);
  return;
}
/* zAhXPTEAPDE擾 */
unsigned long getPteIndex(unsigned long virtual_address )
{
  unsigned long index;

  index = ( virtual_address >> DEF_MM_PTE_INDEX_SHIFT )&DEF_MM_PTE_INDEX_MASK;
  return index;
}
PAGE_TABLE_ENTRY *getPTE(PAGE_TABLE *table,unsigned long virtual_address)
{
  PAGE_TABLE_ENTRY *entry;

  if(table==0) {
    return (PAGE_TABLE_ENTRY*)0;
  }
  entry = (PAGE_TABLE_ENTRY*)(table);

  return ( &entry[getPteIndex(virtual_address)]);
}
unsigned long getPdeIndex(unsigned long virtual_address)
{
  unsigned long index;

  index=(virtual_address>>DEF_MM_PDE_INDEX_SHIFT)&DEF_MM_PDE_INDEX_MASK;
  return index;
}
PAGE_DIRECTORY_ENTRY *getPDE(PAGE_DIRECTORY *directory,unsigned long virtual_address)
{
  PAGE_DIRECTORY_ENTRY *entry;
  if(table==0){
    return (PAGE_TABLE_ENTRY*)0;
  }
  entry=(PAGE_DIRECTORY_ENTRY*)(directory);
  return (&entry[getPdeIndex(virtual_address)]);
}

void writeCPUCR3(unsigned long value)
{
  store_cr3(value);
}
void switchNewPDE(PAGE_DIRECTORY *directory)
{
  if(directory!=0){
    writeCPUCR3( ( unsigned long )directory );
  }
}

PAGE_DIRECTORY *current_pd;

PAGE_DIRECTORY *getCurrentPageDirectory(void)
{
  return (current_pd);
}
void invlpg(unsigned long virtual_address)
{
  io_cli();
  inpg(virtual_address);
  io_sti();
}
void flushTLB(unsigned long virtual_address)
{
  invlpg(virtual_address);
}
int mapPage(unsigned long physical_address,unsigned long virtual_address)
{
  PAGE_DIRECTORY        *page_directory;
  PAGE_DIRECTORY_ENTRY  *pde;
  PAGE_TABLE            *page_table;
  PAGE_TABLE_ENTRY      *pte;

  page_directory = getCurrentPageDirectory( );
  if(page_directory==0){
    return (DEF_MM_ERROR);
  }
  pde=getPDE(page_directory,virtual_address);
  if(!isPdePresent(pde)){
    page_table=(PAGE_TABLE*)alloc4((struct manager *)(MANAGER_ADDR),4096);

    if(page_table==0){
      return (DEF_MM_ERROR);
    }
    kmemset((void*)page_table, 0x00, DEF_MM_PAGE_TABLE_SIZE );

    setPdeFlags( pde, DEF_PDE_FLAGS_P | DEF_PDE_FLAGS_RW);
    setPdePageFrameAddress( pde, ( unsigned long )page_table );
  }else{
    page_table=(PAGE_TABLE*)getPdePageTableAddress(pde);
  }
  pte=getPTE(page_table,virtual_address);

  setPteFlags(pte,DEF_PTE_FLAGS_P|DEF_PTE_FLAGS_RW);
  setPtePageFrameAddress( pte, physical_address);

  return (DEF_MM_OK);
}
int initVirtualMemoryManagement(void)
{
  PAGE_TABLE              *table_low;
  PAGE_TABLE              *table_high;
  PAGE_TABLE_ENTRY        *pte;

  PAGE_DIRECTORY          *directory;
  PAGE_DIRECTORY_ENTRY    *pde;
  
  int                     i;
  unsigned long           frame;
  unsigned long           virtual_address;

  table_low  = ( PAGE_TABLE* )alloc4((struct manager *)(MANAGER_ADDR),4096);

  if(table_low==0)
    {
      return( DEF_MM_ERROR );
    }

  table_high = ( PAGE_TABLE* )alloc4((struct manager *)(MANAGER_ADDR),4096);

  if( table_high == 0 )
    {
      return( DEF_MM_ERROR );
    }

  /* ------------------------------------------------------------------------ */
  /*  clear page table                                                        */
  /* ------------------------------------------------------------------------ */
  kmemset( ( void* )table_low,  0x00, DEF_MM_PAGE_TABLE_SIZE );
  kmemset( ( void* )table_high, 0x00, DEF_MM_PAGE_TABLE_SIZE );
  for( i = 0, frame = 0x00000000, virtual_address = 0x00000000 ;
       i < DEF_MM_NUM_PTE ;
       frame += DEF_MM_PAGE_SIZE, virtual_address += DEF_MM_PAGE_SIZE )
    {
      pte = getPTE( table_low, virtual_address );
      setPteFlags( pte, DEF_PTE_FLAGS_P | DEF_PTE_FLAGS_RW );
      setPtePageFrameAddress( pte, frame );
    }
  for( i = 0, frame = 0x00100000, virtual_address = 0xC0000000 ;
       i < DEF_MM_NUM_PTE ;
       frame += DEF_MM_PAGE_SIZE, virtual_address += DEF_MM_PAGE_SIZE )
    {
      pte = getPTE( table_high, virtual_address );
      setPteFlags( pte, DEF_PTE_FLAGS_P | DEF_PTE_FLAGS_RW );
      setPtePageFrameAddress( pte, frame );
    }
       

  directory = ( PAGE_DIRECTORY* )alloc4((struct manager *)(MANAGER_ADDR),4096);

  if( directory == 0 )
    {
      return( DEF_MM_ERROR );
    }

  /* ------------------------------------------------------------------------ */
  /*  set up pdes 0x00000000 - 0x003FF000                                     */
  /* ------------------------------------------------------------------------ */
  pde = getPDE( directory, 0x00000000 );
  setPdeFlags( pde, DEF_PDE_FLAGS_P | DEF_PDE_FLAGS_RW );
  setPdePageFrameAddress( pde, ( unsigned long )table_low );

  /* ------------------------------------------------------------------------ */
  /* 	set up pdes 0xC0000000 - 0xC03FF000                                     */
  /* ------------------------------------------------------------------------ */
  pde = getPDE( directory, 0x00000000 );
  setPdeFlags( pde, DEF_PDE_FLAGS_P | DEF_PDE_FLAGS_RW );
  setPdePageFrameAddress( pde, ( unsigned long )table_high );
  /* ------------------------------------------------------------------------ */
  /*  switch to the new pdes                                                  */
  /* ------------------------------------------------------------------------ */
  switchNewPDE( directory );

  /* ------------------------------------------------------------------------ */
  /*  entering the paging                                                     */
  /* ------------------------------------------------------------------------ */
  pagingOn();
  return DEF_MM_OK;
}
void pagingOn(void)
{
  /* ------------------------------------------------------------------------- */
  /*  disable interrupt                                                        */
  /* ------------------------------------------------------------------------- */
  /* disableInterrupt( ); */
  io_cli();

  /* ------------------------------------------------------------------------- */
  /*  paging on                                                                */
  /* ------------------------------------------------------------------------- */
  paging_on();
  io_sti();
}

void kmemset(void *str,unsigned char c, int size)
{
  unsigned char *ptr	= ( unsigned char * )str;
  const unsigned char ch= ( const unsigned char )c;
	
  while(size--)
    *ptr++ = ch;
}			
