Imports systembase.table

Public Class Fieldprovider3

    Private Sub Fieldprovider3_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Dim rp As New UTable.CRecordProvider
        With New CFieldBuilder
            rp.AddField(0, New CDateFieldProvider, .Next)
        End With
        Me.Table.Content.SetRecordProvider(rp)
        Me.Table.CreateCaption()

        Using Me.Table.UpdateBufferBlock
            For i As Integer = 0 To 10
                Me.Table.Content.AddRecord()
            Next
        End Using
        
    End Sub

    Class CDateFieldProvider
        Inherits CFieldProvider
        Public Overrides Function Editor() As systembase.table.IEditor
            Return New CDateEditor
        End Function
        Public Overrides Function ValueFormat(ByVal v As Object) As String
            If TypeOf v Is DateTime Then
                Return CType(v, DateTime).ToString("yyyy/MM/dd")
            Else
                Return Nothing
            End If
        End Function
    End Class

    Class CDateEditor
        Inherits DateTimePicker
        Implements IEditor

        Public Event _Leave(ByVal sender As Object, ByVal direction As String) Implements IEditor.Leave
        Public Event _ValueChanged(ByVal sender As Object) Implements IEditor.ValueChanged
        Public Event _ProcessDialogKey(ByVal sender As Object, ByVal keyData As System.Windows.Forms.Keys, ByRef handled As Boolean) Implements IEditor.ProcessDialogKey

        Public Sub Initialize(ByVal field As UTable.CField) Implements IEditor.Initialize
            With field.DynamicSetting
                Me.Font = .Font
            End With
        End Sub

        Public Sub _Enter(ByVal key As Char, ByVal hIMC As Integer, ByVal clear As Boolean) Implements IEditor.Enter
            Me.Focus()
        End Sub

        Public Property _Value() As Object Implements IEditor.Value
            Get
                Return Me.Value
            End Get
            Set(ByVal value As Object)
                Try
                    Me.Value = value
                Catch ex As Exception
                End Try
            End Set
        End Property

        Protected Overrides Function ProcessDialogKey(ByVal keyData As System.Windows.Forms.Keys) As Boolean
            Dim handled As Boolean = False
            RaiseEvent _ProcessDialogKey(Me, keyData, handled)
            If handled Then
                Return True
            Else
                Return MyBase.ProcessDialogKey(keyData)
            End If
        End Function

        Public Function RaiseValidate() As Boolean Implements IEditor.RaiseValidate
            Dim e As New System.ComponentModel.CancelEventArgs
            Me.OnValidating(e)
            If Not e.Cancel Then
                Me.OnValidated(System.EventArgs.Empty)
                Return True
            End If
            Return False
        End Function

        Private Sub CDateEditor_TextChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.TextChanged
            RaiseEvent _ValueChanged(Me)
        End Sub

        Public Function Control() As System.Windows.Forms.Control Implements systembase.table.IEditor.Control
            Return Me
        End Function

    End Class
End Class