Imports System.Drawing

Partial Class UTable

    Partial Class CField

        Public Function GetAdjustSize() As CGrid.CSize
            With Me.Desc.Layout
                Return Me.getAdjustSize(New CGrid.CPoint(.Row + .Rows - 1, .Col + .Cols - 1))
            End With
        End Function

        Public Function GetAdjustSize(ByVal point As CGrid.CPoint) As CGrid.CSize
            If Me.Table.BackBuffer Is Nothing Then
                Return New CGrid.CSize
            End If
            With Me.Desc
                Dim entireSize As Size = .Provider.GetAdjustSize(Me.Table.BackBuffer.Graphics, Me)
                Return New CGrid.CSize(CGrid.GetSizeFromEntireSize(Me.Record.Rows, .Layout.Row, .Layout.Rows, point.Row, entireSize.Height), _
                                       CGrid.GetSizeFromEntireSize(Me.Table.Cols, .Layout.Col, .Layout.Cols, point.Col, entireSize.Width))
            End With
        End Function

        Private Sub adjust_on_setValue()
            If Me.Desc.Layout IsNot Nothing And _
               (Me.Table.AutoAdjust.Col Or Me.Table.AutoAdjust.Row) Then
                With Me.getAdjustSize
                    If Me.Table.AutoAdjust.Row Then
                        If Me.Row.Size < .Row Then
                            Me.Row.Size = .Row
                            Me.TopLevelContent.NeedUpdateCache = True
                        End If
                    End If
                    If Me.Table.AutoAdjust.Col Then
                        If Me.Col.Size < .Col Then
                            Me.Col.Size = .Col
                            Me.Table.NeetUpdateCache = True
                        End If
                    End If
                End With
            End If
        End Sub

    End Class

    Public Sub AdjustSize()
        Using Me.UpdateBufferBlock
            For i As Integer = 0 To Me.Cols.Count - 1
                Me.AdjustSize(i)
            Next
        End Using
    End Sub

    Public Sub AdjustSize(ByVal col As Integer)
        Using Me.UpdateBufferBlock
            Dim size As Integer = 1
            Dim t As Integer
            t = Me.getAdjustColSize(col, Me.HeaderContent)
            If t > size Then
                size = t
            End If
            t = Me.getAdjustColSize(col, Me.Content)
            If t > size Then
                size = t
            End If
            Me.Cols(col).Size = size
        End Using
    End Sub

    Private Function getAdjustColSize(ByVal col As Integer, ByVal content As CContent) As Integer
        Dim ret As Integer = 0
        Me.updateScrollBars(Me.updateLayoutCaches)
        For Each record As CRecord In content.Records
            If record.LayoutCache.Visible Then
                For row As Integer = 0 To record.Rows.Count - 1
                    Dim f As CField = record.FindField(New CGrid.CPoint(row, col))
                    If f IsNot Nothing Then
                        Dim t As Integer = f.GetAdjustSize(New CGrid.CPoint(row, col)).Col
                        If t > ret Then
                            ret = t
                        End If
                    End If
                Next
                If record.Child IsNot Nothing Then
                    Dim t As Integer = Me.getAdjustColSize(col, record.Child)                    
                    If t > ret Then
                        ret = t
                    End If
                End If
            End If
        Next        
        Return ret
    End Function

End Class
