Imports System.Drawing

Partial Class UTable

    Public Sub PrepareCols(ByVal cols_count As Integer)
        Do While Me.Cols.Count < cols_count
            Me.Cols.Add(New CGrid(Me))
            Me.NeetUpdateCache = True
        Loop
    End Sub

    Public Property FixedCols() As Integer
        Get
            Return Me._FixedCols
        End Get
        Set(ByVal value As Integer)
            Using Me.UpdateBufferBlock
                Me._FixedCols = value
                Me.NeetUpdateCache = True
            End Using
        End Set
    End Property

    Class CResizing
        Public Size As Integer
        Public Col As Integer
    End Class

    Private cursor_resizing As CResizing = Nothing
    Private resizing As CResizing = Nothing

    Private Function cols_MouseDown(ByVal e As System.Windows.Forms.MouseEventArgs) As Boolean
        If e.Button = Windows.Forms.MouseButtons.Left Then
            If Me.cursor_resizing IsNot Nothing Then
                Me.resizing = Me.cursor_resizing
                Me.resizing.Size = Me.Cols(Me.resizing.Col).Size
                Return True
            End If
        End If        
        Return False
    End Function

    Private Function cols_MouseDoubleClick(ByVal e As System.Windows.Forms.MouseEventArgs) As Boolean
        Using Me.UpdateBufferBlock
            If Me.Setting.UserColAdjustable And Me.cursor_resizing IsNot Nothing Then
                If Me.Cols(Me.cursor_resizing.Col).Resizable And _
                   Me.Cols(Me.cursor_resizing.Col).UserAdjustable Then
                    Me.AdjustSize(Me.cursor_resizing.Col)
                    Me.resizing = Nothing
                    Me.cursor_resizing = Nothing
                    Return True
                End If
            End If
        End Using
        Return False
    End Function

    Private Function cols_MouseMove(ByVal e As System.Windows.Forms.MouseEventArgs) As Boolean
        If Me.Setting.UserColResizable Then
            Return resize_col(e.Location.Y, e.Location.X, Cursors.VSplit)
        End If
        Return False
    End Function

    Private Function cols_MouseUp(ByVal e As System.Windows.Forms.MouseEventArgs) As Boolean
        If Me.resizing IsNot Nothing Then
            Using Me.UpdateBufferBlock
                Me.Cols(Me.resizing.Col).Size = Me.resizing.Size
                Me.resizing = Nothing
                Me.cursor_resizing = Nothing
                Me.NeetUpdateCache = True
            End Using
            Return True
        End If
        Return False
    End Function

    Private Function resize_col(ByVal row_pos As Integer, ByVal col_pos As Integer, ByVal resizableCorsor As Cursor) As Boolean
        Me.Cursor = Cursors.Default
        If Me.Editor IsNot Nothing Then
            Return False
        End If
        If Me.resizing Is Nothing Then
            Me.cursor_resizing = Nothing
            If row_pos <= Me.HeaderContent.LayoutCache.RowsSize Then
                For i As Integer = 0 To Me.RenderCache.Cols.Count - 1
                    If Me.Cols(i).Resizable AndAlso _
                       Me.Cols(i).UserResizable AndAlso _
                       Me.RenderCache.Cols(i).Appeared AndAlso _
                       Math.Abs(col_pos - Me.RenderCache.Cols(i).To) <= 3 Then
                        Me.Cursor = resizableCorsor
                        Me.cursor_resizing = New CResizing
                        Me.cursor_resizing.Col = i
                    End If
                Next
            End If
            Return False
        Else
            Me.Cursor = resizableCorsor
            Dim size As Integer = col_pos - Me.RenderCache.Cols(Me.resizing.Col).From
            With Me.Cols(Me.resizing.Col)
                If size > 1 And _
                   (.SizeMin = 0 Or size >= .SizeMin) And _
                   (.SizeMax = 0 Or size <= .SizeMax) And _
                   (isSizeValid(size)) Then
                    Using Me.UpdateBufferBlock
                        Me.resizing.Size = size
                    End Using
                End If
            End With
            Return True
        End If
    End Function

    Private Function isSizeValid(ByVal size As Integer) As Boolean
        If Me.resizing.Col < Me.FixedCols Then
            Dim fixedColsSize As Integer = Me.Cols.GetSize(0, Me.FixedCols)            
            If Me.Width - SCROLLBAR_WIDTH < fixedColsSize - Me.Cols(Me.resizing.Col).Size + size Then
                Return False
            End If
        End If
        Return True
    End Function

End Class