Imports System.Drawing

Partial Class UTable

    Public Class CRecordProvider

        Public Class CFieldDesc
            Public CreateCaption As Boolean = True
            Public UserSortable As CGlobalSetting.ESortable = CGlobalSetting.ESortable.DEFAULT
            Public MergeCaption As Object = Nothing
            Public Layout As CGrid.CRegion
            Public Provider As IFieldProvider

            Private _Setting As UTable.CSetting

            Public Sub New()
            End Sub

            Public Sub New(ByVal provider As IFieldProvider, ByVal layout As CGrid.CRegion)
                Me.Initialize(provider, layout)
            End Sub

            Public Sub Initialize(ByVal provider As IFieldProvider, ByVal layout As CGrid.CRegion)
                Me.Provider = provider
                Me.Layout = layout
                Me.Setting = provider.Setting
            End Sub

            Public Function HasSetting() As Boolean
                Return Me._Setting IsNot Nothing
            End Function

            Public Sub ClearSetting()
                Me.Setting = Nothing
            End Sub

            Public Property Setting() As UTable.CSetting
                Get
                    If Me._Setting Is Nothing Then
                        Me._Setting = New UTable.CSetting
                    End If
                    Return Me._Setting
                End Get
                Set(ByVal value As UTable.CSetting)
                    Me._Setting = value
                End Set
            End Property

        End Class

        Public FieldDescs As New Dictionary(Of Object, CFieldDesc)
        Public Rows As New CGrids
        Public ChildRecordProvider As CRecordProvider = Nothing
        Public ColsCount As Integer = 0

        Private _Setting As UTable.CSetting = Nothing

        Public Function HasSetting() As Boolean
            Return Me._Setting IsNot Nothing
        End Function

        Public Sub ClearSetting()
            Me.Setting = Nothing
        End Sub

        Public Property Setting() As UTable.CSetting
            Get
                If Me._Setting Is Nothing Then
                    Me._Setting = New UTable.CSetting
                End If
                Return Me._Setting
            End Get
            Set(ByVal value As UTable.CSetting)
                Me._Setting = value
            End Set
        End Property

        Public Function AddField(ByVal key As Object, _
                                 ByVal provider As IFieldProvider, _
                                 Optional ByVal layout As CGrid.CRegion = Nothing) As CFieldDesc
            Return Me._AddField(Of CFieldDesc)(key, provider, layout)
        End Function

        Protected Function _AddField(Of TDesc As {CFieldDesc, New}) _
                                    (ByVal key As Object, _
                                     ByVal provider As IFieldProvider, _
                                     ByVal layout As CGrid.CRegion) As TDesc
            Dim field As New TDesc
            field.Initialize(provider, layout)
            If layout IsNot Nothing Then
                Do While Me.Rows.Count < layout.Row + layout.Rows
                    Me.Rows.Add(New CGrid)
                Loop
                If Me.ColsCount < layout.Col + layout.Cols Then
                    Me.ColsCount = layout.Col + layout.Cols
                End If
            End If
            Me.FieldDescs.Add(key, field)
            Return field
        End Function

        Public Sub SetChildRecordProvider(ByVal recordProvider As CRecordProvider)
            Me.ChildRecordProvider = recordProvider
        End Sub

        Public Function Layout(ByVal key As Object) As CGrid.CRegion
            Return Me.FieldDescs(key).Layout
        End Function

        Public Function Layout(ByVal key1 As Object, ByVal key2 As Object) As CGrid.CRegion
            Return Me.FieldDescs(key1).Layout.Union(Me.FieldDescs(key2).Layout)
        End Function

        Public Sub FlatBorder(ByVal key1 As Object, ByVal key2 As Object)
            CFieldProvider.FlatBorder(Me.FieldDescs, key1, key2)
        End Sub

    End Class

End Class