Imports System.Drawing

Partial Class UTable

    Private Const SCROLLBAR_WIDTH As Integer = 16

    Private Sub updateScrollBars(ByVal needUpdate As Boolean)

        If needUpdate Then
            Dim m As Integer = 0
            Dim fixed_h As Integer = Me.HeaderContent.LayoutCache.RowsSize + Me.FooterContent.LayoutCache.RowsSize
            Me.showScrollBar(Me.VScrollBar, _
                             Me.Content.LayoutCache.RowsSize, _
                             Me.Height - fixed_h)
            If Me.VScrollBar.Visible Then
                m = SCROLLBAR_WIDTH
            Else
                m = 0
            End If
            Me.showScrollBar(Me.HScrollBar, _
                             Me.LayoutCache.ColsSize, _
                             Me.Width - m)
            If Me.HScrollBar.Visible Then
                Me.showScrollBar(Me.VScrollBar, _
                                 Me.Content.LayoutCache.RowsSize, _
                                 Me.Height - fixed_h - SCROLLBAR_WIDTH)
            End If
            If m = 0 And Me.VScrollBar.Visible Then
                Me.showScrollBar(Me.HScrollBar, _
                                 Me.LayoutCache.ColsSize, _
                                 Me.Width - SCROLLBAR_WIDTH)
            End If
        End If

        Me._updateScrollbars()

    End Sub

    Private Sub UTable_VisibleChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.VisibleChanged
        Me.updateScrollBars(True)
    End Sub

    Private Sub _updateScrollbars()
        If Me.VScrollBar.Visible And Me.HScrollBar.Visible Then
            Me.VScrollBar.Size = New Size(SCROLLBAR_WIDTH, Me.Height - SCROLLBAR_WIDTH)
            Me.VScrollBar.Location = New Point(Me.Width - SCROLLBAR_WIDTH, 0)
            Me.HScrollBar.Size = New Size(Me.Width - SCROLLBAR_WIDTH, SCROLLBAR_WIDTH)
            Me.HScrollBar.Location = New Point(0, Me.Height - SCROLLBAR_WIDTH)
            Me.scrollPlaceHolderPanel.Size = New Size(SCROLLBAR_WIDTH, SCROLLBAR_WIDTH)
            Me.scrollPlaceHolderPanel.Location = New Point(Me.Width - SCROLLBAR_WIDTH, Me.Height - SCROLLBAR_WIDTH)
            Me.scrollPlaceHolderPanel.Visible = True
            Me.scrollPlaceHolderPanel.BackColor = SystemColors.Control
        ElseIf Me.VScrollBar.Visible Then
            Me.VScrollBar.Size = New Size(SCROLLBAR_WIDTH, Me.Height)
            Me.VScrollBar.Location = New Point(Me.Width - SCROLLBAR_WIDTH, 0)
            Me.scrollPlaceHolderPanel.Visible = False
        ElseIf Me.HScrollBar.Visible Then
            Me.HScrollBar.Size = New Size(Me.Width, SCROLLBAR_WIDTH)
            Me.HScrollBar.Location = New Point(0, Me.Height - SCROLLBAR_WIDTH)
            Me.scrollPlaceHolderPanel.Visible = False
        Else
            Me.scrollPlaceHolderPanel.Visible = False
        End If
    End Sub

    Private Sub showScrollBar(ByVal scrollBar As ScrollBar, ByVal entireSize As Integer, ByVal displaySize As Integer)
        If entireSize > displaySize And displaySize > 0 Then
            Dim v As Integer = 0
            With scrollBar
                If .Visible Then
                    v = .Value
                End If
                .Minimum = 0
                .Maximum = entireSize
                .LargeChange = displaySize
                .SmallChange = Me.DefaultGridSize.Row
                .Visible = True
                Me.SetScrollValue(scrollBar, v)
            End With
        Else
            scrollBar.Value = scrollBar.Minimum
            scrollBar.Visible = False
        End If
    End Sub

    Private Sub VScrollBar_ValueChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles VScrollBar.ValueChanged
        If Me.AutoUpdate Then
            Me.UpdateBuffer()
        End If
    End Sub

    Private Sub ScrollBar_MouseEnter(ByVal sender As Object, ByVal e As System.EventArgs) Handles HScrollBar.MouseEnter, VScrollBar.MouseEnter
        Me.Cursor = Cursors.Default
    End Sub

    Private Sub HScrollBar_ValueChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles HScrollBar.ValueChanged
        If Me.AutoUpdate Then
            Me.UpdateBuffer()
        End If
    End Sub

    Private Sub UTable_MouseWheel(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Me.MouseWheel
        If Me.VScrollBar.Visible And Me.VScrollBar.Enabled Then
            Dim t As Integer = Me.VScrollBar.Value
            If e.Delta > 0 Then
                t -= Me.VScrollBar.SmallChange
            Else
                t += Me.VScrollBar.SmallChange
            End If
            Me.SetScrollValue(Me.VScrollBar, t)
        End If
    End Sub

    Public Function ContentRowSize() As Integer
        Dim t As Integer = 0
        If Me.HScrollBar.Visible Then
            t = Me.HScrollBar.Height
        End If
        Return Me.Height - (Me.HeaderContent.LayoutCache.RowsSize + Me.FooterContent.LayoutCache.RowsSize) - t
    End Function

    Public Function ContentColSize() As Integer
        Dim t As Integer = 0
        If Me.VScrollBar.Visible Then
            t = Me.VScrollBar.Width
        End If
        Return Me.Width - Me.LayoutCache.FixedColsSize - t
    End Function

    Public Sub SetScrollValue(ByVal scrollBar As ScrollBar, ByVal scrollValue As Integer)
        If scrollBar.Visible And scrollBar.Enabled Then
            If scrollValue < scrollBar.Minimum Then
                scrollBar.Value = scrollBar.Minimum
            ElseIf scrollValue > scrollBar.Maximum - scrollBar.LargeChange Then
                scrollBar.Value = scrollBar.Maximum - scrollBar.LargeChange
            Else
                scrollBar.Value = scrollValue
            End If
        End If
    End Sub

    Private Class CHScrollBar
        Inherits HScrollBar
        Public Sub New()
            Me.SetStyle(ControlStyles.Selectable, False)
        End Sub
    End Class

    Private Class CVScrollBar
        Inherits VScrollBar
        Public Sub New()
            Me.SetStyle(ControlStyles.Selectable, False)
        End Sub
    End Class

End Class
