/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc.pexcel.records;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openoffice.xmerge.converter.xml.OfficeConstants;
import org.openoffice.xmerge.converter.xml.sxc.Format;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.PocketExcelConstants;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.BIFFRecord;
import org.openoffice.xmerge.util.ColourConverter;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.EndianConverter;

public class ExtendedFormat
implements BIFFRecord,
OfficeConstants {
    private byte[] ixfnt = new byte[2];
    private byte[] ixnf = new byte[2];
    private byte[] fattributes = new byte[4];
    private byte[] fBaseAttr = new byte[2];
    private byte[] fTextAttr = new byte[2];
    private byte[] icvFore = new byte[2];
    private byte[] icvFill = new byte[2];
    private byte bRight;
    private byte bTop;
    private byte bLeft;
    private byte bBottom;
    private byte backstyle;
    private byte borderstyle;
    public static final int TOP_BORDER = 1;
    public static final int LEFT_BORDER = 2;
    public static final int BOTTOM_BORDER = 4;
    public static final int RIGHT_BORDER = 8;
    public static final int NORMAL_ALIGN = 0;
    public static final int LEFT_ALIGN = 1;
    public static final int CENTER_ALIGN = 2;
    public static final int RIGHT_ALIGN = 3;
    public static final int TOP_ALIGN = 16;
    public static final int MIDDLE_ALIGN = 32;
    public static final int BOTTOM_ALIGN = 48;
    public static final int WORD_WRAP = 8;

    public ExtendedFormat(int n, Format format) {
        Color color;
        this.ixfnt = EndianConverter.writeShort((short)((short)n));
        String string = format.getCategory();
        this.ixnf = string.equalsIgnoreCase("currency") ? EndianConverter.writeShort((short)0) : (string.equalsIgnoreCase("date") ? EndianConverter.writeShort((short)18) : (string.equalsIgnoreCase("time") ? EndianConverter.writeShort((short)30) : EndianConverter.writeShort((short)0)));
        this.fattributes = new byte[]{-1, -1, -1, -1};
        byte[] byArray = new byte[2];
        byArray[0] = 2;
        this.fBaseAttr = byArray;
        this.fTextAttr = new byte[2];
        int n2 = format.getAlign();
        this.fTextAttr[0] = n2 == 2 ? (byte)(this.fTextAttr[0] | 2) : (n2 == 3 ? (byte)(this.fTextAttr[0] | 1) : (n2 == 1 ? (byte)(this.fTextAttr[0] | 3) : (byte)(this.fTextAttr[0] | 0)));
        int n3 = format.getVertAlign();
        this.fTextAttr[0] = n3 == 1 ? (byte)(this.fTextAttr[0] | 0x10) : (n3 == 3 ? (byte)(this.fTextAttr[0] | 0x30) : (n3 == 2 ? (byte)(this.fTextAttr[0] | 0x20) : (byte)(this.fTextAttr[0] | 0x30)));
        if (format.getAttribute(1024)) {
            this.fTextAttr[0] = (byte)(this.fTextAttr[0] | 8);
        }
        if (format.getAttribute(64)) {
            this.fTextAttr[1] = (byte)(this.fTextAttr[1] | 2);
        }
        if (format.getAttribute(128)) {
            this.fTextAttr[1] = (byte)(this.fTextAttr[1] | 8);
        }
        if (format.getAttribute(256)) {
            this.fTextAttr[1] = (byte)(this.fTextAttr[1] | 1);
        }
        if (format.getAttribute(512)) {
            this.fTextAttr[1] = (byte)(this.fTextAttr[1] | 4);
        }
        if ((color = format.getBackground()) != null) {
            ColourConverter colourConverter = new ColourConverter(PocketExcelConstants.cLookup);
            this.icvFill = EndianConverter.writeShort((short)colourConverter.convertFromRGB(color));
        } else {
            byte[] byArray2 = new byte[2];
            byArray2[0] = -1;
            this.icvFill = byArray2;
        }
        byte[] byArray3 = new byte[2];
        byArray3[0] = -1;
        this.icvFore = byArray3;
        this.bRight = (byte)-1;
        this.bTop = (byte)-1;
        this.bLeft = (byte)-1;
        this.bBottom = (byte)-1;
        this.backstyle = 0;
        this.borderstyle = 0;
    }

    public ExtendedFormat(InputStream inputStream) throws IOException {
        this.read(inputStream);
    }

    public boolean compareTo(ExtendedFormat extendedFormat) {
        if (EndianConverter.readShort((byte[])this.icvFill) != EndianConverter.readShort((byte[])extendedFormat.icvFill)) {
            return false;
        }
        if (this.getTextAttr() != extendedFormat.getTextAttr()) {
            return false;
        }
        if (this.getVertAlign() != extendedFormat.getVertAlign()) {
            return false;
        }
        if (this.getAlign() != extendedFormat.getAlign()) {
            return false;
        }
        if (this.getFontIndex() != extendedFormat.getFontIndex()) {
            return false;
        }
        return this.getFormatIndex() == extendedFormat.getFormatIndex();
    }

    public int getAlign() {
        int n = 3;
        int n2 = this.fTextAttr[0] & n;
        if (n2 == 32) {
            return 3;
        }
        if (n2 == 2) {
            return 2;
        }
        if (n2 == 3) {
            return 1;
        }
        return 3;
    }

    public Color getBackground() {
        short s = EndianConverter.readShort((byte[])this.icvFill);
        Color color = null;
        if (s != 255) {
            ColourConverter colourConverter = new ColourConverter(PocketExcelConstants.cLookup);
            color = colourConverter.convertToRGB(s);
        }
        return color;
    }

    public short getBiffType() {
        return 224;
    }

    public int getFontIndex() {
        return EndianConverter.readShort((byte[])this.ixfnt);
    }

    public int getFormatIndex() {
        return EndianConverter.readShort((byte[])this.ixnf);
    }

    public int getTextAttr() {
        return EndianConverter.readShort((byte[])this.fTextAttr);
    }

    public int getVertAlign() {
        int n = 48;
        int n2 = this.fTextAttr[0] & n;
        if (n2 == 32) {
            return 2;
        }
        if (n2 == 48) {
            return 3;
        }
        if (n2 == 16) {
            return 1;
        }
        return 3;
    }

    public boolean isBorder(int n) {
        return (this.fTextAttr[1] & n) != 0;
    }

    public boolean isWordWrap() {
        return (this.fTextAttr[0] & 8) != 0;
    }

    public int read(InputStream inputStream) throws IOException {
        int n = inputStream.read(this.ixfnt);
        n += inputStream.read(this.ixnf);
        n += inputStream.read(this.fattributes);
        n += inputStream.read(this.fBaseAttr);
        n += inputStream.read(this.fTextAttr);
        n += inputStream.read(this.icvFore);
        n += inputStream.read(this.icvFill);
        this.bRight = (byte)inputStream.read();
        this.bTop = (byte)inputStream.read();
        this.bLeft = (byte)inputStream.read();
        this.bBottom = (byte)inputStream.read();
        this.backstyle = (byte)inputStream.read();
        this.borderstyle = (byte)inputStream.read();
        Debug.log((int)4, (String)("\tixfnt : " + EndianConverter.readShort((byte[])this.ixfnt) + " ixnf : " + EndianConverter.readShort((byte[])this.ixnf) + " fattributes : " + EndianConverter.readInt((byte[])this.fattributes) + " fBaseAttr : " + EndianConverter.readShort((byte[])this.fBaseAttr) + "\n\tfTextAttr : " + EndianConverter.readShort((byte[])this.fTextAttr) + " icvFore : " + EndianConverter.readShort((byte[])this.icvFore) + " icvFill : " + EndianConverter.readShort((byte[])this.icvFill) + " bRight : " + this.bRight + "\n\tbTop : " + this.bTop + " bLeft : " + this.bLeft + " bBottom : " + this.bBottom + " backstyle : " + this.backstyle + " borderstyle : " + this.borderstyle));
        return n += 6;
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.getBiffType());
        outputStream.write(this.ixfnt);
        outputStream.write(this.ixnf);
        outputStream.write(this.fattributes);
        outputStream.write(this.fBaseAttr);
        outputStream.write(this.fTextAttr);
        outputStream.write(this.icvFore);
        outputStream.write(this.icvFill);
        outputStream.write(this.bRight);
        outputStream.write(this.bTop);
        outputStream.write(this.bLeft);
        outputStream.write(this.bBottom);
        outputStream.write(this.backstyle);
        outputStream.write(this.borderstyle);
        Debug.log((int)4, (String)"Writing ExtendedFormat record");
    }
}

