/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public final class Issue
implements Comparable {
    static final String ISSUE_TYPE = "issue_type";
    static final String SHORT_DESC = "short_desc";
    static final String LONG_DESC = "long_desc";
    static final String COMMENT = "comment";
    static final String ISSUE_ID = "issue_id";
    static final String ISSUE_STATUS = "issue_status";
    static final String RESOLUTION = "resolution";
    static final String COMPONENT = "component";
    static final String REPORTER = "reporter";
    static final String VERSION = "version";
    static final String SUBCOMPONENT = "subcomponent";
    static final String REP_PLATFORM = "rep_platform";
    static final String OP_SYS = "op_sys";
    static final String PRIORITY = "priority";
    static final String ASSIGNED_TO = "assigned_to";
    static final String CC = "cc";
    static final String DEPENDS_ON = "dependson";
    static final String BLOCKS = "blocks";
    static final String CREATED = "creation_ts";
    static final String VOTES = "votes";
    static final String KEYWORDS = "keywords";
    static final String TARGET_MILESTONE = "target_milestone";
    static final String LONG_DESC_LIST = "long_desc_list";
    private HashMap attributes = new HashMap(49);

    public int getId() {
        Object object = this.getAttribute(ISSUE_ID);
        try {
            return Integer.parseInt((String)object);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public String getAssignedTo() {
        return this.string(ASSIGNED_TO);
    }

    public String getReportedBy() {
        return this.string(REPORTER);
    }

    public String[] getObservedBy() {
        List list = (List)this.getAttribute(CC);
        if (list != null) {
            return list.toArray(new String[0]);
        }
        return new String[0];
    }

    public String getStatus() {
        return this.string(ISSUE_STATUS);
    }

    public String getResolution() {
        return this.string(RESOLUTION);
    }

    public String getType() {
        return this.string(ISSUE_TYPE);
    }

    public int getPriority() {
        String string = this.string(PRIORITY);
        if (string.length() == 2 && string.charAt(0) == 'P') {
            return string.charAt(1) - 48;
        }
        return -1;
    }

    public Date getCreated() {
        Date date = (Date)this.getAttribute(CREATED);
        return date == null ? new Date(0L) : date;
    }

    public String getSummary() {
        return this.string(SHORT_DESC);
    }

    public Description[] getDescriptions() {
        Object object = this.getAttribute(LONG_DESC_LIST);
        if (object == null) {
            return new Description[0];
        }
        return ((List)object).toArray(new Description[0]);
    }

    public int[] getDependsOn() {
        return this.ints(DEPENDS_ON);
    }

    public int[] getBlocks() {
        return this.ints(BLOCKS);
    }

    public String getTargetMilestone() {
        return this.string(TARGET_MILESTONE);
    }

    public String getComponent() {
        return this.string(COMPONENT);
    }

    public String getSubcomponent() {
        return this.string(SUBCOMPONENT);
    }

    public int getVotes() {
        try {
            String string = this.string(VOTES);
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public String getKeywords() {
        try {
            return this.string(KEYWORDS);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public boolean containsKeyword(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.getKeywords());
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private String string(String string) {
        Object object = this.getAttribute(string);
        return object instanceof String ? (String)object : "";
    }

    private int[] ints(String string) {
        List list = (List)this.getAttribute(string);
        if (list == null) {
            return new int[0];
        }
        int[] nArray = new int[list.size()];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = Integer.parseInt((String)list.get(n));
            ++n;
        }
        return nArray;
    }

    Object getAttribute(String string) {
        if (string.equals(LONG_DESC)) {
            return this.formatLongDescriptions();
        }
        return this.attributes.get(string);
    }

    void setAttribute(String string, Object object) {
        this.attributes.put(string, object);
    }

    private Map attributes() {
        return this.attributes;
    }

    public String toString() {
        if (this.attributes == null) {
            return "Empty BugBase";
        }
        Iterator iterator = this.attributes.entrySet().iterator();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName() + " containing these name/value attribute pairs:\n");
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringBuffer.append("NAME  : " + entry.getKey() + "\n");
            stringBuffer.append("VALUE : " + entry.getValue() + "\n");
        }
        return stringBuffer.toString();
    }

    public int compareTo(Object object) {
        Issue issue = (Issue)object;
        return this.getId() - issue.getId();
    }

    private String formatLongDescriptions() {
        if (this.attributes.get(LONG_DESC) == null) {
            StringBuffer stringBuffer = new StringBuffer("");
            Object object = this.getAttribute(LONG_DESC_LIST);
            if (object == null) {
                return null;
            }
            List list = (List)object;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Description description = (Description)iterator.next();
                stringBuffer.append(description.toString());
            }
            this.attributes.put(LONG_DESC, stringBuffer.toString());
        }
        return this.attributes.get(LONG_DESC).toString();
    }

    public static final class Description {
        static final String WHO = "who";
        static final String ISSUE_WHEN = "issue_when";
        static final String BODY = "body";
        static final String THETEXT = "thetext";
        private String who;
        private Date when;
        private String body;

        public String getWho() {
            return this.who;
        }

        void setWho(String string) {
            this.who = string;
        }

        public Date getWhen() {
            return this.when;
        }

        void setIssueWhen(Date date) {
            this.when = date;
        }

        public String getBody() {
            return this.body;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getWho());
            stringBuffer.append(", ");
            stringBuffer.append(this.getWhen());
            stringBuffer.append(" : \n");
            stringBuffer.append(this.getBody());
            stringBuffer.append("\n\n");
            return stringBuffer.toString();
        }

        void setBody(String string) {
            this.body = string;
        }

        void setAtribute(String string, String string2) {
            if (string.equalsIgnoreCase(WHO)) {
                this.setWho(string2);
            } else if (string.equalsIgnoreCase(BODY) || string.equalsIgnoreCase(THETEXT)) {
                this.setBody(string2);
            }
        }

        private String getAttribute(String string) {
            if (string.equalsIgnoreCase(WHO)) {
                return this.who;
            }
            if (string.equalsIgnoreCase(BODY) || string.equalsIgnoreCase(THETEXT)) {
                return this.body;
            }
            return null;
        }
    }
}

