/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.expr;

import com.jclark.xsl.expr.BooleanVariant;
import com.jclark.xsl.expr.Converter;
import com.jclark.xsl.expr.ExprContext;
import com.jclark.xsl.expr.NodeSetVariant;
import com.jclark.xsl.expr.NumberVariant;
import com.jclark.xsl.expr.ObjectVariant;
import com.jclark.xsl.expr.SingleNodeIterator;
import com.jclark.xsl.expr.StringVariant;
import com.jclark.xsl.expr.Variant;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.NodeIterator;
import com.jclark.xsl.om.XSLException;

public abstract class VariantBase
implements Variant {
    public abstract boolean convertToBoolean() throws XSLException;

    public NodeIterator convertToNodeSet() throws XSLException {
        throw new XSLException("cannot convert to node-set");
    }

    public double convertToNumber() throws XSLException {
        return Converter.toNumber(this.convertToString());
    }

    public abstract Object convertToObject() throws XSLException;

    public boolean convertToPredicate(ExprContext exprContext) throws XSLException {
        return this.convertToBoolean();
    }

    public abstract String convertToString() throws XSLException;

    public static Variant create(Object object) {
        if (object instanceof String) {
            return new StringVariant((String)object);
        }
        if (object instanceof Number) {
            return new NumberVariant(((Number)object).doubleValue());
        }
        if (object instanceof Boolean) {
            return new BooleanVariant((Boolean)object);
        }
        if (object instanceof NodeIterator) {
            return new NodeSetVariant((NodeIterator)object);
        }
        if (object instanceof Node) {
            return new NodeSetVariant(new SingleNodeIterator((Node)object));
        }
        if (object instanceof Variant) {
            return (Variant)object;
        }
        return new ObjectVariant(object);
    }

    public Node getBaseNode() {
        return null;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isNodeSet() {
        return false;
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public Variant makePermanent() throws XSLException {
        return this;
    }
}

