/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.bind.tuple;

import com.sleepycat.bdb.bind.DataBuffer;
import com.sleepycat.bdb.bind.DataFormat;
import com.sleepycat.bdb.bind.KeyExtractor;
import com.sleepycat.bdb.bind.tuple.TupleFormat;
import com.sleepycat.bdb.bind.tuple.TupleInput;
import com.sleepycat.bdb.bind.tuple.TupleOutput;
import java.io.IOException;

public abstract class TupleTupleKeyExtractor
implements KeyExtractor {
    protected TupleFormat primaryKeyFormat;
    protected TupleFormat valueFormat;
    protected TupleFormat indexKeyFormat;

    public TupleTupleKeyExtractor(TupleFormat primaryKeyFormat, TupleFormat valueFormat, TupleFormat indexKeyFormat) {
        this.primaryKeyFormat = primaryKeyFormat;
        this.valueFormat = valueFormat;
        this.indexKeyFormat = indexKeyFormat;
    }

    public DataFormat getPrimaryKeyFormat() {
        return this.primaryKeyFormat;
    }

    public DataFormat getValueFormat() {
        return this.valueFormat;
    }

    public DataFormat getIndexKeyFormat() {
        return this.indexKeyFormat;
    }

    public void extractIndexKey(DataBuffer primaryKeyData, DataBuffer valueData, DataBuffer indexKeyData) throws IOException {
        TupleOutput output = this.indexKeyFormat.newOutput();
        TupleInput primaryKeyInput = this.primaryKeyFormat != null ? this.primaryKeyFormat.dataToInput(primaryKeyData) : null;
        TupleInput valueInput = this.valueFormat != null ? this.valueFormat.dataToInput(valueData) : null;
        this.extractIndexKey(primaryKeyInput, valueInput, output);
        this.indexKeyFormat.outputToData(output, indexKeyData);
    }

    public void clearIndexKey(DataBuffer valueData) throws IOException {
        TupleOutput output = this.valueFormat.newOutput();
        this.clearIndexKey(this.valueFormat.dataToInput(valueData), output);
        this.valueFormat.outputToData(output, valueData);
    }

    public abstract void extractIndexKey(TupleInput var1, TupleInput var2, TupleOutput var3) throws IOException;

    public abstract void clearIndexKey(TupleInput var1, TupleOutput var2) throws IOException;
}

