/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.factory;

import com.sleepycat.bdb.DataIndex;
import com.sleepycat.bdb.DataStore;
import com.sleepycat.bdb.ForeignKeyIndex;
import com.sleepycat.bdb.PrimaryKeyAssigner;
import com.sleepycat.bdb.bind.DataBinding;
import com.sleepycat.bdb.bind.EntityBinding;
import com.sleepycat.bdb.bind.serial.ClassCatalog;
import com.sleepycat.bdb.bind.serial.SerialFormat;
import com.sleepycat.bdb.bind.serial.TupleSerialMarshalledBinding;
import com.sleepycat.bdb.bind.serial.TupleSerialMarshalledKeyExtractor;
import com.sleepycat.bdb.bind.tuple.TupleBinding;
import com.sleepycat.bdb.bind.tuple.TupleFormat;
import com.sleepycat.bdb.bind.tuple.TupleMarshalledBinding;
import com.sleepycat.bdb.collection.StoredMap;
import com.sleepycat.bdb.collection.StoredSortedMap;
import com.sleepycat.db.Db;

public class TupleSerialDbFactory {
    private static final TupleFormat TUPLE_FORMAT = new TupleFormat();
    private ClassCatalog catalog;

    public TupleSerialDbFactory(ClassCatalog catalog) {
        this.catalog = catalog;
    }

    public final ClassCatalog getCatalog() {
        return this.catalog;
    }

    public DataStore newDataStore(Db db, Class baseClass, PrimaryKeyAssigner keyAssigner) {
        return new DataStore(db, TUPLE_FORMAT, new SerialFormat(this.catalog, baseClass), keyAssigner);
    }

    public DataIndex newDataIndex(DataStore store, Db db, String keyName, boolean usePrimaryKey, boolean useValue) {
        return new DataIndex(store, db, TUPLE_FORMAT, this.getKeyExtractor(store, keyName, usePrimaryKey, useValue));
    }

    public ForeignKeyIndex newForeignKeyIndex(DataStore store, Db db, String keyName, boolean usePrimaryKey, boolean useValue, DataStore foreignStore, int deleteAction) {
        return new ForeignKeyIndex(store, db, this.getKeyExtractor(store, keyName, usePrimaryKey, useValue), foreignStore, deleteAction);
    }

    public StoredMap newMap(DataStore store, Class keyClass, boolean writeAllowed) {
        return new StoredMap(store, this.getKeyBinding(keyClass), (EntityBinding)this.getEntityBinding(store), writeAllowed);
    }

    public StoredMap newMap(DataIndex index, Class keyClass, boolean writeAllowed) {
        return new StoredMap(index, this.getKeyBinding(keyClass), (EntityBinding)this.getEntityBinding(index.getStore()), writeAllowed);
    }

    public StoredSortedMap newSortedMap(DataStore store, Class keyClass, boolean writeAllowed) {
        return new StoredSortedMap(store, this.getKeyBinding(keyClass), (EntityBinding)this.getEntityBinding(store), writeAllowed);
    }

    public StoredSortedMap newSortedMap(DataIndex index, Class keyClass, boolean writeAllowed) {
        return new StoredSortedMap(index, this.getKeyBinding(keyClass), (EntityBinding)this.getEntityBinding(index.getStore()), writeAllowed);
    }

    private TupleSerialMarshalledKeyExtractor getKeyExtractor(DataStore store, String keyName, boolean usePrimaryKey, boolean useValue) {
        return new TupleSerialMarshalledKeyExtractor(this.getEntityBinding(store), TUPLE_FORMAT, keyName, usePrimaryKey, useValue);
    }

    private TupleSerialMarshalledBinding getEntityBinding(DataStore store) {
        return new TupleSerialMarshalledBinding((TupleFormat)store.getKeyFormat(), (SerialFormat)store.getValueFormat());
    }

    private DataBinding getKeyBinding(Class keyClass) {
        TupleBinding binding = TupleBinding.getPrimitiveBinding(keyClass, TUPLE_FORMAT);
        if (binding == null) {
            binding = new TupleMarshalledBinding(TUPLE_FORMAT, keyClass);
        }
        return binding;
    }
}

