/*
 * Decompiled with CFR 0.152.
 */
package ifc.util;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameReplace;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.util.ElementChange;
import com.sun.star.util.XChangesBatch;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XChangesBatch
extends MultiMethodTest {
    public XChangesBatch oObj;
    private Object changeElement = null;
    private Object originalElement = null;
    private String elementName = null;
    private XPropertySet xProp = null;
    private XNameReplace xNameReplace = null;

    protected void before() {
        this.changeElement = this.tEnv.getObjRelation("XChangesBatch.ChangeElement");
        this.originalElement = this.tEnv.getObjRelation("XChangesBatch.OriginalElement");
        this.elementName = (String)this.tEnv.getObjRelation("XChangesBatch.PropertyName");
        this.xProp = (XPropertySet)this.tEnv.getObjRelation("XChangesBatch.PropertySet");
        try {
            if (this.originalElement == null && this.xProp != null) {
                this.originalElement = this.xProp.getPropertyValue(this.elementName);
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            throw new StatusException("Could not get property '" + this.elementName + "'.", exception);
        }
        this.xNameReplace = (XNameReplace)this.tEnv.getObjRelation("XChangesBatch.NameReplace");
        try {
            if (this.originalElement == null && this.xNameReplace != null) {
                this.originalElement = this.xNameReplace.getByName(this.elementName);
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            throw new StatusException("Could not get element by name '" + this.elementName + "'.", exception);
        }
        if (this.changeElement == null || this.originalElement == null || this.elementName == null || this.xProp == null && this.xNameReplace == null) {
            this.log.println(this.changeElement == null ? "Missing property 'XChangesBatch.ChangeElement'\n" : ("" + this.originalElement == null ? "Missing property 'XChangesBatch.OriginalElement'\n" : ("" + this.elementName == null ? "Missing property 'XChangesBatch.PropertyName'\n" : ("" + this.xProp == null ? "Missing property 'XChangesBatch.PropertySet'" : ("" + this.xNameReplace == null ? "Missing property 'XChangesBatch.NameReplace'" : "")))));
            throw new StatusException("Some needed object relations are missing.", new Exception());
        }
    }

    public void _commitChanges() {
        this.requiredMethod("getPendingChanges()");
        try {
            this.log.println("Committing changes.");
            this.oObj.commitChanges();
        }
        catch (WrappedTargetException wrappedTargetException) {
            this.tRes.tested("commitChanges()", Status.exception(wrappedTargetException));
            return;
        }
        try {
            this.executeChange(this.originalElement);
        }
        catch (StatusException statusException) {
            this.tRes.tested("hasPendingChanges()", Status.exception(statusException));
            return;
        }
        try {
            this.log.println("Commit changes back.");
            this.oObj.commitChanges();
        }
        catch (WrappedTargetException wrappedTargetException) {
            this.tRes.tested("commitChanges()", Status.exception(wrappedTargetException));
            return;
        }
        this.tRes.tested("commitChanges()", true);
    }

    public void _getPendingChanges() {
        this.requiredMethod("hasPendingChanges()");
        ElementChange[] elementChangeArray = this.oObj.getPendingChanges();
        if (elementChangeArray == null) {
            this.log.println("Returned changes was 'null'");
            this.log.println("It should have been 1 change.");
            this.tRes.tested("getPendingChanges()", false);
        } else if (elementChangeArray.length != 1) {
            int n = elementChangeArray.length;
            this.log.println("Found not the right number of changes: " + n);
            this.log.println("It should have been 1 change.");
            for (int i = 0; i < n; ++i) {
                System.out.println("Detailed Change " + i + " -> new Element: '" + elementChangeArray[i].Element.toString() + "'  ReplacedElement: '" + elementChangeArray[i].ReplacedElement.toString() + "'");
            }
            this.tRes.tested("getPendingChanges()", false);
        } else {
            boolean bl = elementChangeArray[0].ReplacedElement.equals(this.originalElement);
            this.tRes.tested("getPendingChanges()", bl &= elementChangeArray[0].Element.equals(this.changeElement));
        }
    }

    public void _hasPendingChanges() {
        try {
            this.executeChange(this.changeElement);
        }
        catch (StatusException statusException) {
            this.tRes.tested("hasPendingChanges()", Status.exception(statusException));
            return;
        }
        boolean bl = this.oObj.hasPendingChanges();
        this.tRes.tested("hasPendingChanges()", bl);
    }

    private void executeChange(Object object) throws StatusException {
        if (this.xProp != null) {
            try {
                this.xProp.setPropertyValue(this.elementName, object);
            }
            catch (com.sun.star.uno.Exception exception) {
                throw new StatusException("Could not set property '" + this.elementName + "'.", exception);
            }
        }
        if (this.xNameReplace != null) {
            try {
                this.xNameReplace.replaceByName(this.elementName, object);
            }
            catch (com.sun.star.uno.Exception exception) {
                throw new StatusException("Could not replace '" + this.elementName + "' by name.", exception);
            }
        }
    }
}

