/*
 * Decompiled with CFR 0.152.
 */
package lib;

import java.util.Hashtable;
import util.utils;

public class TestParameters
extends Hashtable {
    public String ConnectionString = "socket,host=localhost,port=8100";
    public Object AppProvider = null;
    public Object ProcessHandler = null;
    public String AppExecutionCommand = "";
    public boolean AutoRestart = false;
    public int ShortWait = 500;
    public String OfficeProvider = "helper.OfficeProvider";
    public String TestBase = "java_fat";
    public Object ServiceFactory;
    public String DescriptionPath;
    public String TestDocumentPath = utils.getUsersTempDir();
    public boolean LoggingIsActive = true;
    public boolean DebugIsActive = false;
    public Object TestJob;
    public String LogWriter = "stats.SimpleLogWriter";
    public String OutProducer = "stats.SimpleOutProducer";
    public Integer TimeOut = new Integer(30000);
    public Integer ThreadTimeOut = new Integer(30000);

    public Object get(Object object) {
        Object v = super.get(object);
        if (v == null && this.DebugIsActive) {
            System.out.print("Have been asked for key \"" + object.toString());
            System.out.println("\" which is not part of params.");
        }
        return v;
    }

    public boolean getBool(Object object) {
        Object v = super.get(object);
        if (v != null) {
            if (v instanceof String) {
                String string = (String)v;
                if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes")) {
                    return true;
                }
                if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("no")) {
                    return false;
                }
            }
            if (v instanceof Boolean) {
                return (Boolean)v;
            }
        }
        return false;
    }

    public int getInt(Object object) {
        Object v = super.get(object);
        if (v != null) {
            if (v instanceof Integer) {
                return (Integer)v;
            }
            try {
                Integer n;
                if (v instanceof String && (n = new Integer((String)v)) > 0) {
                    return n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public Object put(Object object, Object object2) {
        return super.put(object, object2);
    }

    public TestParameters() {
        this.put("ConnectionString", this.ConnectionString);
        this.put("TestBase", this.TestBase);
        this.put("TestDocumentPath", this.TestDocumentPath);
        this.put("LoggingIsActive", this.LoggingIsActive ? Boolean.TRUE : Boolean.FALSE);
        this.put("DebugIsActive", this.DebugIsActive ? Boolean.TRUE : Boolean.FALSE);
        this.put("OutProducer", this.OutProducer);
        this.put("ShortWait", new Integer(this.ShortWait));
        this.put("OfficeProvider", this.OfficeProvider);
        this.put("LogWriter", this.LogWriter);
        this.put("AppExecutionCommand", this.AppExecutionCommand);
        this.put("TimeOut", this.TimeOut);
        this.put("ThreadTimeOut", this.ThreadTimeOut);
        this.put("AutoRestart", this.AutoRestart ? Boolean.TRUE : Boolean.FALSE);
        this.put("OperatingSystem", this.getSOCompatibleOSName());
        this.put("CNCSTR", this.ConnectionString);
        this.put("DOCPTH", this.TestDocumentPath);
        System.setProperty("DOCPTH", this.TestDocumentPath);
    }

    public Object getMSF() {
        Object object = null;
        object = this.get("ServiceFactory");
        return object;
    }

    String getSOCompatibleOSName() {
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = System.getProperty("os.arch");
        String string3 = "";
        if (string.indexOf("windows") > -1) {
            string3 = "wntmsci";
        } else if (string.indexOf("linux") > -1) {
            string3 = "unxlngi";
        } else if (string.indexOf("sunos") > -1) {
            string3 = string2.equals("x86") ? "unxsoli" : "unxsols";
        }
        return string3;
    }
}

