/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleValue;
import com.sun.star.awt.XWindow;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.UnoRuntime;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.WriterTools;
import util.utils;

public class SwAccessibleDocumentView
extends TestCase {
    XTextDocument xTextDoc = null;
    public static boolean first = false;
    public static XAccessibleContext SearchedContext = null;
    static /* synthetic */ Class class$com$sun$star$frame$XModel;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleValue;

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        XAccessibleContext xAccessibleContext = null;
        XText xText = this.xTextDoc.getText();
        XTextCursor xTextCursor = xText.createTextCursor();
        printWriter.println("inserting some lines");
        try {
            for (int i = 0; i < 5; ++i) {
                xText.insertString(xTextCursor, "Paragraph Number: " + i, false);
                xText.insertString(xTextCursor, " The quick brown fox jumps over the lazy Dog: SwXParagraph", false);
                xText.insertControlCharacter(xTextCursor, (short)0, false);
                xText.insertString(xTextCursor, "THE QUICK BROWN FOX JUMPS OVER THE LAZY DOG: SwXParagraph", false);
                xText.insertControlCharacter(xTextCursor, (short)0, false);
                xText.insertControlCharacter(xTextCursor, (short)1, false);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(printWriter);
            throw new StatusException("Couldn't insert lines", illegalArgumentException);
        }
        XModel xModel = (XModel)UnoRuntime.queryInterface(class$com$sun$star$frame$XModel == null ? (class$com$sun$star$frame$XModel = SwAccessibleDocumentView.class$("com.sun.star.frame.XModel")) : class$com$sun$star$frame$XModel, (Object)this.xTextDoc);
        AccessibilityTools accessibilityTools = new AccessibilityTools();
        XWindow xWindow = AccessibilityTools.getCurrentWindow((XMultiServiceFactory)testParameters.getMSF(), xModel);
        XAccessible xAccessible = AccessibilityTools.getAccessibleObject(xWindow);
        AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)13);
        xAccessibleContext = AccessibilityTools.SearchedContext;
        printWriter.println("ImplementationName " + utils.getImplName(xAccessibleContext));
        AccessibilityTools.printAccessibleTree(printWriter, xAccessible, testParameters.getBool("DebugIsActive"));
        TestEnvironment testEnvironment = new TestEnvironment(xAccessibleContext);
        SwAccessibleDocumentView.getAccessibleObjectForRole(xAccessible, (short)50);
        final XAccessibleValue xAccessibleValue = (XAccessibleValue)UnoRuntime.queryInterface(class$com$sun$star$accessibility$XAccessibleValue == null ? (class$com$sun$star$accessibility$XAccessibleValue = SwAccessibleDocumentView.class$("com.sun.star.accessibility.XAccessibleValue")) : class$com$sun$star$accessibility$XAccessibleValue, (Object)SearchedContext);
        testEnvironment.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            public void fireEvent() {
                xAccessibleValue.setCurrentValue(xAccessibleValue.getMinimumValue());
                xAccessibleValue.setCurrentValue(xAccessibleValue.getMaximumValue());
            }
        });
        return testEnvironment;
    }

    public static void getAccessibleObjectForRole(XAccessible xAccessible, short s) {
        XAccessibleContext xAccessibleContext = xAccessible.getAccessibleContext();
        if (xAccessibleContext.getAccessibleRole() == s) {
            if (first) {
                SearchedContext = xAccessibleContext;
            } else {
                first = true;
            }
        } else {
            int n = xAccessibleContext.getAccessibleChildCount();
            for (int i = 0; i < n; ++i) {
                try {
                    SwAccessibleDocumentView.getAccessibleObjectForRole(xAccessibleContext.getAccessibleChild(i), s);
                    if (SearchedContext == null) continue;
                    return;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    System.out.println("Couldn't get Child");
                }
            }
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("dispose text document");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("creating a text document");
        this.xTextDoc = WriterTools.createTextDoc((XMultiServiceFactory)testParameters.getMSF());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

