/*
 * Decompiled with CFR 0.152.
 */
package mod._toolkit;

import com.sun.star.awt.Rectangle;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XControlModel;
import com.sun.star.awt.XDevice;
import com.sun.star.awt.XGraphics;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.drawing.XControlShape;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.view.XControlAccess;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.FormTools;
import util.SOfficeFactory;
import util.WriterTools;
import util.utils;

public class UnoScrollBarControl
extends TestCase {
    XTextDocument xTextDoc;
    static /* synthetic */ Class class$com$sun$star$frame$XModel;
    static /* synthetic */ Class class$com$sun$star$view$XControlAccess;
    static /* synthetic */ Class class$com$sun$star$awt$XWindow;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a textdocument");
            this.xTextDoc = sOfficeFactory.createTextDoc(null);
            printWriter.println("maximize the window size");
            XModel xModel = (XModel)UnoRuntime.queryInterface(class$com$sun$star$frame$XModel == null ? (class$com$sun$star$frame$XModel = UnoScrollBarControl.class$("com.sun.star.frame.XModel")) : class$com$sun$star$frame$XModel, (Object)this.xTextDoc);
            XFrame xFrame = xModel.getCurrentController().getFrame();
            XWindow xWindow = xFrame.getContainerWindow();
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension dimension = toolkit.getScreenSize();
            Rectangle rectangle = xWindow.getPosSize();
            rectangle.Width = new Double(dimension.getWidth()).intValue();
            rectangle.Height = new Double(dimension.getHeight()).intValue();
            rectangle.X = 0;
            rectangle.Y = 0;
            xWindow.setPosSize(rectangle.X, rectangle.Y, rectangle.Width, rectangle.Height, (short)15);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        XControl xControl = null;
        XWindowPeer xWindowPeer = null;
        XToolkit xToolkit = null;
        XDevice xDevice = null;
        XGraphics xGraphics = null;
        XControl xControl2 = null;
        XControlShape xControlShape = FormTools.createUnoControlShape(this.xTextDoc, 3000, 4500, 15000, 10000, "ScrollBar", "UnoControlScrollBar");
        WriterTools.getDrawPage(this.xTextDoc).add(xControlShape);
        XControlModel xControlModel = xControlShape.getControl();
        XControlShape xControlShape2 = FormTools.createControlShape(this.xTextDoc, 3000, 4500, 5000, 10000, "TextField");
        WriterTools.getDrawPage(this.xTextDoc).add(xControlShape2);
        XControlModel xControlModel2 = xControlShape2.getControl();
        XControlAccess xControlAccess = (XControlAccess)UnoRuntime.queryInterface(class$com$sun$star$view$XControlAccess == null ? (class$com$sun$star$view$XControlAccess = UnoScrollBarControl.class$("com.sun.star.view.XControlAccess")) : class$com$sun$star$view$XControlAccess, (Object)this.xTextDoc.getCurrentController());
        try {
            xControl = xControlAccess.getControl(xControlModel);
            xControl2 = xControlAccess.getControl(xControlModel2);
            xWindowPeer = xControlAccess.getControl(xControlModel).getPeer();
            xToolkit = xWindowPeer.getToolkit();
            xDevice = xToolkit.createScreenCompatibleDevice(200, 200);
            xGraphics = xDevice.createGraphics();
        }
        catch (Exception exception) {
            printWriter.println("Couldn't get ScrollBarControl");
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't get ScrollBarControl", exception);
        }
        printWriter.println("creating a new environment for UnoControlScrollBar object");
        TestEnvironment testEnvironment = new TestEnvironment(xControl);
        testEnvironment.addObjRelation("Document", this.xTextDoc);
        testEnvironment.addObjRelation("GRAPHICS", xGraphics);
        testEnvironment.addObjRelation("CONTEXT", this.xTextDoc);
        testEnvironment.addObjRelation("WINPEER", xWindowPeer);
        testEnvironment.addObjRelation("TOOLKIT", xToolkit);
        testEnvironment.addObjRelation("MODEL", xControlModel);
        XWindow xWindow = (XWindow)UnoRuntime.queryInterface(class$com$sun$star$awt$XWindow == null ? (class$com$sun$star$awt$XWindow = UnoScrollBarControl.class$("com.sun.star.awt.XWindow")) : class$com$sun$star$awt$XWindow, (Object)xControl2);
        testEnvironment.addObjRelation("XWindow.AnotherWindow", xWindow);
        System.out.println("ImplementationName: " + utils.getImplName(xControl));
        return testEnvironment;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

