/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc;

import java.awt.Color;

public class Format
implements Cloneable {
    public static final int RIGHT_ALIGN = 1;
    public static final int CENTER_ALIGN = 2;
    public static final int LEFT_ALIGN = 3;
    public static final int JUST_ALIGN = 4;
    public static final int TOP_ALIGN = 1;
    public static final int MIDDLE_ALIGN = 2;
    public static final int BOTTOM_ALIGN = 3;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int UNDERLINE = 4;
    public static final int STRIKETHRU = 8;
    public static final int SUPERSCRIPT = 16;
    public static final int SUBSCRIPT = 32;
    public static final int LEFT_BORDER = 64;
    public static final int RIGHT_BORDER = 128;
    public static final int TOP_BORDER = 256;
    public static final int BOTTOM_BORDER = 512;
    public static final int WORD_WRAP = 1024;
    private int align;
    private int vertAlign;
    private String category;
    private String value;
    private String formatSpecifier;
    private int decimalPlaces;
    private String fontName;
    protected int sizeInPoints;
    private Color foreground;
    private Color background;
    protected int attributes = 0;
    protected int mask = 0;

    public Format() {
        this.clearFormatting();
    }

    public Format(int n, int n2, String string) {
        this.attributes = n;
        this.sizeInPoints = n2;
        this.fontName = string;
    }

    public Format(Format format) {
        this.category = format.getCategory();
        this.value = format.getValue();
        this.formatSpecifier = format.getFormatSpecifier();
        this.decimalPlaces = format.getDecimalPlaces();
        this.attributes = format.attributes;
        this.mask = format.mask;
        this.fontName = format.getFontName();
        this.align = format.getAlign();
        this.vertAlign = format.getVertAlign();
        this.foreground = format.getForeground();
        this.background = format.getBackground();
        this.sizeInPoints = format.sizeInPoints;
    }

    public void clearFormatting() {
        this.category = "";
        this.value = "";
        this.formatSpecifier = "";
        this.decimalPlaces = 0;
        this.attributes = 0;
        this.mask = 0;
        this.sizeInPoints = 10;
        this.align = 3;
        this.vertAlign = 3;
        this.fontName = "";
        this.foreground = null;
        this.background = null;
    }

    public int getAlign() {
        return this.align;
    }

    public boolean getAttribute(int n) {
        if ((this.mask & n) == 0) {
            return false;
        }
        return (this.attributes & n) != 0;
    }

    public Color getBackground() {
        return this.background;
    }

    public String getCategory() {
        return this.category;
    }

    public int getDecimalPlaces() {
        return this.decimalPlaces;
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getFontSize() {
        return this.sizeInPoints;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public String getFormatSpecifier() {
        return this.formatSpecifier;
    }

    public String getValue() {
        return this.value;
    }

    public int getVertAlign() {
        return this.vertAlign;
    }

    public boolean isDefault() {
        Format format = new Format();
        if (format.attributes != this.attributes) {
            return false;
        }
        if (this.foreground != format.foreground) {
            return false;
        }
        if (this.background != format.background) {
            return false;
        }
        if (format.align != this.align) {
            return false;
        }
        return format.vertAlign == this.vertAlign;
    }

    public boolean isSet(int n) {
        return (this.mask & n) != 0;
    }

    public boolean isSubset(Format format) {
        if (format.getClass() != this.getClass()) {
            return false;
        }
        if (format.attributes != this.attributes) {
            return false;
        }
        if (format.sizeInPoints != 0 && this.sizeInPoints != format.sizeInPoints) {
            return false;
        }
        if (this.fontName != format.fontName) {
            return false;
        }
        if (this.foreground != format.foreground) {
            return false;
        }
        if (this.background != format.background) {
            return false;
        }
        if (format.align != this.align) {
            return false;
        }
        return format.vertAlign == this.vertAlign;
    }

    public void setAlign(int n) {
        this.align = n;
    }

    public void setAttribute(int n, boolean bl) {
        this.mask |= n;
        this.attributes = bl ? (this.attributes |= n) : (this.attributes &= ~n);
    }

    public void setBackground(Color color) {
        if (color != null) {
            this.background = new Color(color.getRGB());
        }
    }

    public void setCategory(String string) {
        this.category = string;
    }

    public void setDecimalPlaces(int n) {
        this.decimalPlaces = n;
    }

    public void setFontName(String string) {
        this.fontName = string;
    }

    public void setFontSize(int n) {
        this.sizeInPoints = n;
    }

    public void setForeground(Color color) {
        if (color != null) {
            this.foreground = new Color(color.getRGB());
        }
    }

    public void setFormatSpecifier(String string) {
        this.formatSpecifier = string;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public void setVertAlign(int n) {
        this.vertAlign = n;
    }

    public String toString() {
        return new String("Value : " + this.getValue() + " Category : " + this.getCategory());
    }
}

