/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.IOException;
import java.util.Enumeration;
import org.openide.filesystems.FileSystem;
import org.openide.util.enum.QueueEnumeration;

class EventControl {
    private int requests;
    private int priorityRequests;
    private AtomicActionLink currentAtomAction;
    private QueueEnumeration requestsQueue;

    EventControl() {
    }

    void dispatchEvent(FileSystem.EventDispatcher eventDispatcher) {
        if (this.postponeFiring(eventDispatcher)) {
            return;
        }
        eventDispatcher.run();
    }

    void beginAtomicAction(FileSystem.AtomicAction atomicAction) {
        this.enterAtomicAction(atomicAction, true);
    }

    void finishAtomicAction() {
        this.exitAtomicAction(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runAtomicAction(FileSystem.AtomicAction atomicAction) throws IOException {
        try {
            this.enterAtomicAction(atomicAction, false);
            atomicAction.run();
            Object var3_2 = null;
            this.exitAtomicAction(false);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.exitAtomicAction(false);
            throw throwable;
        }
    }

    private synchronized void enterAtomicAction(Object object, boolean bl) {
        AtomicActionLink atomicActionLink = new AtomicActionLink(object);
        atomicActionLink.setPreviousLink(this.currentAtomAction);
        this.currentAtomAction = atomicActionLink;
        if (bl) {
            ++this.priorityRequests;
        }
        if (this.requests++ == 0) {
            this.requestsQueue = new QueueEnumeration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exitAtomicAction(boolean bl) {
        QueueEnumeration queueEnumeration;
        Object var2_2 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        EventControl eventControl = this;
        synchronized (eventControl) {
            this.currentAtomAction = this.currentAtomAction.getPreviousLink();
            --this.requests;
            if (bl) {
                --this.priorityRequests;
            }
            if (this.requests == 0) {
                bl2 = true;
            }
            if (!bl2 && bl && this.priorityRequests == 0) {
                bl3 = true;
            }
            if (!bl2 && !bl3) {
                return;
            }
            queueEnumeration = this.requestsQueue;
            this.requestsQueue = null;
            this.priorityRequests = 0;
        }
        if (bl2) {
            this.invokeDispatchers(false, queueEnumeration);
            return;
        }
        if (bl3) {
            this.requestsQueue = new QueueEnumeration();
            QueueEnumeration queueEnumeration2 = this.invokeDispatchers(true, queueEnumeration);
            EventControl eventControl2 = this;
            synchronized (eventControl2) {
                while (this.requestsQueue != null && this.requestsQueue.hasMoreElements()) {
                    FileSystem.EventDispatcher eventDispatcher = (FileSystem.EventDispatcher)this.requestsQueue.nextElement();
                    queueEnumeration2.put(eventDispatcher);
                }
                this.requestsQueue = queueEnumeration2;
            }
        }
    }

    private QueueEnumeration invokeDispatchers(boolean bl, Enumeration enumeration) {
        QueueEnumeration queueEnumeration = new QueueEnumeration();
        while (enumeration != null && enumeration.hasMoreElements()) {
            FileSystem.EventDispatcher eventDispatcher = (FileSystem.EventDispatcher)enumeration.nextElement();
            eventDispatcher.dispatch(bl);
            if (!bl) continue;
            queueEnumeration.put(eventDispatcher);
        }
        return queueEnumeration;
    }

    private synchronized boolean postponeFiring(FileSystem.EventDispatcher eventDispatcher) {
        if (this.priorityRequests == 0) {
            eventDispatcher.setAtomicActionLink(this.currentAtomAction);
            eventDispatcher.dispatch(true);
        }
        if (this.requestsQueue != null) {
            eventDispatcher.setAtomicActionLink(this.currentAtomAction);
            this.requestsQueue.put(eventDispatcher);
            return true;
        }
        return false;
    }

    static final class AtomicActionLink {
        private AtomicActionLink upper;
        private Object propagationID;

        AtomicActionLink(Object object) {
            this.propagationID = object;
        }

        Object getAtomicAction() {
            return this.propagationID;
        }

        void setPreviousLink(AtomicActionLink atomicActionLink) {
            this.upper = atomicActionLink;
        }

        AtomicActionLink getPreviousLink() {
            return this.upper;
        }
    }
}

