/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderList;
import org.openide.loaders.FolderListListener;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.WeakListener;

public abstract class FolderInstance
extends Task
implements InstanceCookie {
    private static final RequestProcessor PROCESSOR = new RequestProcessor("Folder Instance Processor");
    private static final ThreadLocal CURRENT = new ThreadLocal();
    private static final ThreadLocal LAST_CURRENT = new ThreadLocal();
    protected DataFolder folder;
    private DataObject.Container container;
    private HashMap map = new HashMap(17);
    private Task[] waitFor;
    private Object object = CURRENT;
    private Listener listener;
    private ErrorManager err;
    private Task recognizingTask;
    private Task creationTask;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;
    static /* synthetic */ Class class$org$openide$loaders$DataObject$Container;
    static /* synthetic */ Class class$org$openide$util$TaskListener;

    public FolderInstance(DataFolder dataFolder) {
        this((DataObject.Container)dataFolder);
    }

    public FolderInstance(DataObject.Container container) {
        this(container, null);
    }

    private FolderInstance(DataObject.Container container, String string) {
        if (container instanceof DataFolder) {
            this.folder = (DataFolder)container;
            if (string == null) {
                string = this.folder.getPrimaryFile().getPackageName('.');
            }
            container = FolderList.find(this.folder.getPrimaryFile(), true);
        }
        this.listener = new Listener();
        string = string == null ? "org.openide.loaders.FolderInstance" : "org.openide.loaders.FolderInstance." + string;
        this.err = ErrorManager.getDefault().getInstance(string);
        this.container = container;
        container.addPropertyChangeListener(WeakListener.propertyChange(this.listener, container));
    }

    public String instanceName() {
        try {
            return this.instanceClass().getName();
        }
        catch (IOException iOException) {
            return "java.lang.Object";
        }
        catch (ClassNotFoundException classNotFoundException) {
            return "java.lang.Object";
        }
    }

    public Class instanceClass() throws IOException, ClassNotFoundException {
        Object object = this.object;
        if (object != null) {
            if (object instanceof IOException) {
                throw (IOException)object;
            }
            if (object instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)object;
            }
            return object.getClass();
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = FolderInstance.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public Object instanceCreate() throws IOException, ClassNotFoundException {
        Object object = CURRENT.get();
        if (object == null || LAST_CURRENT.get() != this) {
            this.waitFinished();
            object = this.object;
        }
        if (object instanceof IOException) {
            throw (IOException)object;
        }
        if (object instanceof ClassNotFoundException) {
            throw (ClassNotFoundException)object;
        }
        if (object == CURRENT) {
            throw new IOException("Cyclic reference. Somebody is trying to get value from FolderInstance (" + this.getClass().getName() + ") from the same thread that is processing the instance");
        }
        return object;
    }

    public final void instanceFinished() {
        this.waitFinished();
    }

    public void waitFinished() {
        Task task;
        do {
            Task[] taskArray;
            FolderInstance.waitProcessingFinished(this.container);
            task = this.checkRecognizingStarted();
            task.waitFinished();
            Task task2 = this.creationTask;
            if (task2 != null) {
                task2.waitFinished();
            }
            if ((taskArray = this.waitFor) == null) continue;
            int n = 0;
            while (n < taskArray.length) {
                taskArray[n].waitFinished();
                ++n;
            }
        } while (task != this.checkRecognizingStarted());
    }

    protected InstanceCookie acceptDataObject(DataObject dataObject) {
        DataObject.Container container;
        InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = FolderInstance.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie);
        try {
            instanceCookie = instanceCookie == null ? null : this.acceptCookie(instanceCookie);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, iOException);
            instanceCookie = null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            ErrorManager.getDefault().notify(1, classNotFoundException);
            instanceCookie = null;
        }
        if (instanceCookie == null && (container = (DataFolder)dataObject.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = FolderInstance.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder)) != null) {
            HoldInstance holdInstance = (HoldInstance)this.map.get(((DataObject)((Object)container)).getPrimaryFile());
            instanceCookie = holdInstance != null && holdInstance.cookie != null ? holdInstance : this.acceptFolder((DataFolder)container);
        }
        if (instanceCookie == null && (container = (DataObject.Container)dataObject.getCookie(class$org$openide$loaders$DataObject$Container == null ? (class$org$openide$loaders$DataObject$Container = FolderInstance.class$("org.openide.loaders.DataObject$Container")) : class$org$openide$loaders$DataObject$Container)) != null) {
            instanceCookie = this.acceptContainer(container);
        }
        if (this.err.isLoggable(1)) {
            this.err.log(1, "acceptDataObject: " + dataObject + " cookie: " + instanceCookie);
        }
        return instanceCookie;
    }

    protected InstanceCookie acceptCookie(InstanceCookie instanceCookie) throws IOException, ClassNotFoundException {
        return instanceCookie;
    }

    protected InstanceCookie acceptFolder(DataFolder dataFolder) {
        return this.acceptContainer(dataFolder);
    }

    protected InstanceCookie acceptContainer(DataObject.Container container) {
        return null;
    }

    protected abstract Object createInstance(InstanceCookie[] var1) throws IOException, ClassNotFoundException;

    protected Object instanceForCookie(DataObject dataObject, InstanceCookie instanceCookie) throws IOException, ClassNotFoundException {
        return instanceCookie.instanceCreate();
    }

    public synchronized void recreate() {
        this.err.log("recreate");
        this.recognizingTask = FolderInstance.computeChildrenList(this.container, this.listener);
        this.notifyRunning();
    }

    final void checkRecreate() {
        if (this.isFinished()) {
            this.recreate();
        }
    }

    private static void waitProcessingFinished(DataObject.Container container) {
        if (container instanceof FolderList) {
            ((FolderList)container).waitProcessingFinished();
        }
    }

    private static Task computeChildrenList(final DataObject.Container container, final FolderListListener folderListListener) {
        if (container instanceof FolderList) {
            FolderList folderList = (FolderList)container;
            return folderList.computeChildrenList(folderListListener);
        }
        return PROCESSOR.post(new Runnable(){

            public void run() {
                DataObject[] dataObjectArray = container.getChildren();
                ArrayList arrayList = new ArrayList(dataObjectArray.length);
                int n = 0;
                while (n < dataObjectArray.length) {
                    folderListListener.process(dataObjectArray[n], arrayList);
                    ++n;
                }
                folderListListener.finished(arrayList);
            }
        });
    }

    private final Task checkRecognizingStarted() {
        if (this.recognizingTask == null) {
            this.recreate();
        }
        return this.recognizingTask;
    }

    public void run() {
        this.recreate();
        this.instanceFinished();
    }

    final void processObjects(final Collection collection) {
        this.creationTask = this.postCreationTask(new Runnable(){

            public void run() {
                FolderInstance.this.defaultProcessObjects(collection);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void defaultProcessObjects(Collection collection) {
        block29: {
            Object v1;
            Object object;
            HashSet hashSet;
            this.err.log("defaultProcessObjects");
            ArrayList<HoldInstance> arrayList = new ArrayList<HoldInstance>();
            ThreadLocal threadLocal = CURRENT;
            synchronized (threadLocal) {
                hashSet = new HashSet(this.map.keySet());
            }
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                HoldInstance holdInstance;
                Object object2;
                object = (DataObject)iterator.next();
                if (!((DataObject)object).isValid()) continue;
                InstanceCookie instanceCookie = this.acceptDataObject((DataObject)object);
                if (instanceCookie != null) {
                    object2 = ((DataObject)object).getPrimaryFile();
                    boolean bl = false;
                    holdInstance = null;
                    if (hashSet.remove(object2)) {
                        holdInstance = (HoldInstance)this.map.get(object2);
                        boolean bl2 = bl = holdInstance != null;
                        if (bl && holdInstance.cookie == null) {
                            holdInstance = null;
                        }
                    }
                    if (holdInstance == null) {
                        HoldInstance holdInstance2 = instanceCookie instanceof HoldInstance ? (HoldInstance)instanceCookie : (instanceCookie instanceof InstanceCookie.Origin ? new HoldInstanceOrigin((DataObject)object, (InstanceCookie.Origin)instanceCookie) : new HoldInstance((DataObject)object, instanceCookie));
                        ThreadLocal threadLocal2 = CURRENT;
                        synchronized (threadLocal2) {
                            this.map.put(object2, holdInstance2);
                        }
                        ((DataObject)object).addPropertyChangeListener(WeakListener.propertyChange(this.listener, object));
                        arrayList.add(holdInstance2);
                        continue;
                    }
                    arrayList.add(holdInstance);
                    continue;
                }
                object2 = CURRENT;
                synchronized (object2) {
                    FileObject fileObject = ((DataObject)object).getPrimaryFile();
                    hashSet.remove(fileObject);
                    holdInstance = (HoldInstance)this.map.get(fileObject);
                    if (holdInstance != null && holdInstance.cookie == null) {
                        continue;
                    }
                    holdInstance = new HoldInstance((DataObject)object, null);
                    this.map.put(fileObject, holdInstance);
                }
                ((DataObject)object).addPropertyChangeListener(WeakListener.propertyChange(this.listener, object));
            }
            object = CURRENT;
            synchronized (object) {
                this.map.keySet().removeAll(hashSet);
            }
            InstanceCookie[] instanceCookieArray = new HoldInstance[arrayList.size()];
            arrayList.toArray(instanceCookieArray);
            this.updateWaitFor((HoldInstance[])instanceCookieArray);
            Object object3 = null;
            object3 = this.createInstance(instanceCookieArray);
            Object var20_20 = null;
            this.err.log("notifying finished");
            this.object = object3;
            Object t = CURRENT.get();
            CURRENT.set(object3);
            Object t2 = LAST_CURRENT.get();
            LAST_CURRENT.set(this);
            try {
                this.notifyFinished();
                v1 = null;
            }
            catch (Throwable throwable) {
                v1 = null;
            }
            Object var24_36 = v1;
            CURRENT.set(t);
            LAST_CURRENT.set(t2);
            {
                break block29;
                catch (IOException iOException) {
                    Object v2;
                    object3 = iOException;
                    Object var20_21 = null;
                    this.err.log("notifying finished");
                    this.object = object3;
                    Object t3 = CURRENT.get();
                    CURRENT.set(object3);
                    Object t4 = LAST_CURRENT.get();
                    LAST_CURRENT.set(this);
                    try {
                        this.notifyFinished();
                        v2 = null;
                    }
                    catch (Throwable throwable) {
                        v2 = null;
                    }
                    Object var24_37 = v2;
                    CURRENT.set(t3);
                    LAST_CURRENT.set(t4);
                    break block29;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Object v3;
                    object3 = classNotFoundException;
                    Object var20_22 = null;
                    this.err.log("notifying finished");
                    this.object = object3;
                    Object t5 = CURRENT.get();
                    CURRENT.set(object3);
                    Object t6 = LAST_CURRENT.get();
                    LAST_CURRENT.set(this);
                    try {
                        this.notifyFinished();
                        v3 = null;
                    }
                    catch (Throwable throwable) {
                        v3 = null;
                    }
                    Object var24_38 = v3;
                    CURRENT.set(t5);
                    LAST_CURRENT.set(t6);
                }
            }
            catch (Throwable throwable) {
                Object v4;
                Object var20_23 = null;
                this.err.log("notifying finished");
                this.object = object3;
                Object t7 = CURRENT.get();
                CURRENT.set(object3);
                Object t8 = LAST_CURRENT.get();
                LAST_CURRENT.set(this);
                try {
                    this.notifyFinished();
                    v4 = null;
                }
                catch (Throwable throwable2) {
                    v4 = null;
                }
                Object var24_39 = v4;
                CURRENT.set(t7);
                LAST_CURRENT.set(t8);
                throw throwable;
            }
        }
    }

    protected Task postCreationTask(Runnable runnable) {
        return PROCESSOR.post(runnable);
    }

    final ErrorManager err() {
        return this.err;
    }

    private void updateWaitFor(HoldInstance[] holdInstanceArray) {
        ArrayList<Task> arrayList = new ArrayList<Task>(holdInstanceArray.length);
        int n = 0;
        while (n < holdInstanceArray.length) {
            Task task = holdInstanceArray[n].getTask();
            if (task != null) {
                arrayList.add(task);
            }
            ++n;
        }
        this.waitFor = arrayList.toArray(new Task[arrayList.size()]);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class HoldInstanceOrigin
    extends HoldInstance
    implements InstanceCookie.Origin {
        public HoldInstanceOrigin(DataObject dataObject, InstanceCookie.Origin origin) {
            super(dataObject, origin);
        }

        public FileObject instanceOrigin() {
            return ((InstanceCookie.Origin)this.cookie).instanceOrigin();
        }
    }

    private class HoldInstance
    implements InstanceCookie.Of,
    TaskListener {
        private final DataObject source;
        protected final InstanceCookie cookie;

        public HoldInstance(DataObject dataObject, InstanceCookie instanceCookie) {
            this.cookie = instanceCookie;
            this.source = dataObject;
            if (instanceCookie instanceof Task) {
                Task task = (Task)((Object)instanceCookie);
                task.addTaskListener((TaskListener)WeakListener.create(class$org$openide$util$TaskListener == null ? (class$org$openide$util$TaskListener = FolderInstance.class$("org.openide.util.TaskListener")) : class$org$openide$util$TaskListener, this, task));
            }
        }

        public String instanceName() {
            return this.cookie.instanceName();
        }

        public boolean instanceOf(Class clazz) {
            if (this.cookie instanceof InstanceCookie.Of) {
                InstanceCookie.Of of = (InstanceCookie.Of)this.cookie;
                return of.instanceOf(clazz);
            }
            try {
                Class clazz2 = this.cookie.instanceClass();
                return clazz.isAssignableFrom(clazz2);
            }
            catch (IOException iOException) {
                return false;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            return this.cookie.instanceClass();
        }

        public Object instanceCreate() throws IOException, ClassNotFoundException {
            return FolderInstance.this.instanceForCookie(this.source, this.cookie);
        }

        public void taskFinished(Task task) {
            FolderInstance.this.checkRecreate();
        }

        public Task getTask() {
            if (this.cookie instanceof Task) {
                return (Task)((Object)this.cookie);
            }
            return null;
        }
    }

    private class Listener
    implements PropertyChangeListener,
    FolderListListener {
        private Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getSource();
            if (object == FolderInstance.this.container) {
                if ("children".equals(propertyChangeEvent.getPropertyName())) {
                    FolderInstance.this.err.log("PROP_CHILDREN");
                    FolderInstance.this.recreate();
                }
                return;
            }
            if ("name".equals(propertyChangeEvent.getPropertyName()) && object instanceof DataObject) {
                FolderInstance.this.err.log("PROP_NAME");
                FolderInstance.this.recreate();
            }
            if ("cookie".equals(propertyChangeEvent.getPropertyName()) && object instanceof DataObject) {
                HoldInstance holdInstance;
                DataObject dataObject = (DataObject)object;
                InstanceCookie instanceCookie = FolderInstance.this.acceptDataObject(dataObject);
                FileObject fileObject = dataObject.getPrimaryFile();
                ThreadLocal threadLocal = CURRENT;
                synchronized (threadLocal) {
                    holdInstance = (HoldInstance)FolderInstance.this.map.get(fileObject);
                }
                if (holdInstance != null && (instanceCookie == null || instanceCookie != holdInstance && !instanceCookie.equals(holdInstance.cookie))) {
                    holdInstance = instanceCookie instanceof InstanceCookie.Origin ? new HoldInstanceOrigin(dataObject, (InstanceCookie.Origin)instanceCookie) : new HoldInstance(dataObject, instanceCookie);
                    ThreadLocal threadLocal2 = CURRENT;
                    synchronized (threadLocal2) {
                        FolderInstance.this.map.put(fileObject, holdInstance);
                    }
                    FolderInstance.this.recreate();
                }
            }
        }

        public void finished(List list) {
            FolderInstance.this.processObjects(list);
        }

        public void process(DataObject dataObject, List list) {
            list.add(dataObject);
        }
    }
}

