/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.db;

import com.sun.star.sdbc.SQLException;
import com.sun.star.uno.Exception;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.db.CommandMetaData;

public class CommandName {
    private CommandMetaData CurDBMetaData;
    private String CatalogName = null;
    private String SchemaName = null;
    private String TableName = null;
    private String DisplayName = null;
    private String ComposedName = "";
    private String AliasName = "";
    private boolean bCatalogAtStart;
    private String sCatalogSep;
    private String sIdentifierQuote;
    private boolean baddQuotation = true;

    public CommandName(CommandMetaData commandMetaData, String string) {
        this.CurDBMetaData = commandMetaData;
        this.setComposedCommandName(string);
    }

    public CommandName(CommandMetaData commandMetaData, String string, String string2, String string3, boolean bl) {
        this.baddQuotation = bl;
        this.CurDBMetaData = commandMetaData;
        if (string != null && !string.equals("")) {
            this.CatalogName = string;
        }
        if (string2 != null && !string2.equals("")) {
            this.SchemaName = string2;
        }
        if (string3 != null && !string3.equals("")) {
            this.TableName = string3;
        }
        this.setComposedCommandName();
    }

    private void setComposedCommandName(String string) {
        try {
            if (this.setMetaDataAttributes()) {
                int n;
                this.DisplayName = string;
                if (this.CurDBMetaData.xDBMetaData.supportsCatalogsInDataManipulation() && (n = string.indexOf(this.sCatalogSep)) >= 0) {
                    if (this.bCatalogAtStart) {
                        this.CatalogName = string.substring(0, n);
                        string = string.substring(n + 1, string.length());
                    } else {
                        this.CatalogName = string.substring(n + 1, string.length());
                        string = string.substring(0, n);
                    }
                }
                if (this.CurDBMetaData.xDBMetaData.supportsSchemasInDataManipulation()) {
                    String[] stringArray = new String[]{};
                    stringArray = JavaTools.ArrayoutofString(string, ".");
                    this.SchemaName = stringArray[0];
                    this.TableName = stringArray[1];
                } else {
                    this.TableName = string;
                }
                this.setComposedCommandName();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void setComposedCommandName() {
        if (this.setMetaDataAttributes()) {
            if (this.CatalogName != null && this.bCatalogAtStart) {
                this.ComposedName = this.quoteName(this.CatalogName) + this.sCatalogSep;
            }
            if (this.SchemaName != null) {
                this.ComposedName = this.ComposedName + this.quoteName(this.SchemaName) + ".";
            }
            this.ComposedName = this.ComposedName == "" ? this.quoteName(this.TableName) : this.ComposedName + this.quoteName(this.TableName);
            if (!this.bCatalogAtStart && this.CatalogName != null) {
                this.ComposedName = this.ComposedName + this.sCatalogSep + this.quoteName(this.CatalogName);
            }
        }
    }

    private boolean setMetaDataAttributes() {
        try {
            this.bCatalogAtStart = this.CurDBMetaData.xDBMetaData.isCatalogAtStart();
            this.sCatalogSep = this.CurDBMetaData.xDBMetaData.getCatalogSeparator();
            this.sIdentifierQuote = this.CurDBMetaData.xDBMetaData.getIdentifierQuoteString();
            return true;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(System.out);
            return false;
        }
    }

    public String quoteName(String string) {
        if (this.baddQuotation) {
            return CommandName.quoteName(string, this.CurDBMetaData.getIdentifierQuote());
        }
        return string;
    }

    public static String quoteName(String string, String string2) {
        if (string == null) {
            string = "";
        }
        String string3 = "";
        string3 = string2 + string + string2;
        return string3;
    }

    public void setAliasName(String string) {
        this.AliasName = string;
    }

    public String getAliasName() {
        return this.AliasName;
    }

    public String getCatalogName() {
        return this.CatalogName;
    }

    public String getComposedName() {
        return this.ComposedName;
    }

    public String getDisplayName() {
        return this.DisplayName;
    }

    public String getSchemaName() {
        return this.SchemaName;
    }

    public String getTableName() {
        return this.TableName;
    }
}

