/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.sandbox;

import com.sun.star.lib.sandbox.ClassContextImpl;
import com.sun.star.lib.sandbox.RecursionCounter;
import com.sun.star.lib.sandbox.SandboxSecurityException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.URL;
import java.security.AllPermission;
import java.security.IdentityScope;
import java.security.Permission;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.security.provider.IdentityDatabase;

public class SandboxSecurity
extends SecurityManager {
    private static boolean debug = false;
    public static final int NETWORK_NONE = 1;
    public static final int NETWORK_HOST = 2;
    public static final int NETWORK_UNRESTRICTED = 3;
    private static final int PRIVELEGED_PORT = 1024;
    boolean bNoExit;
    boolean initACL;
    String[] readACL;
    String[] writeACL;
    int networkMode;
    boolean bCheckSecurity;
    RecursionCounter InCheck = new RecursionCounter();
    RecursionCounter InIsSecureLoader = new RecursionCounter();
    RecursionCounter InInClassLoader = new RecursionCounter();
    RecursionCounter InClassLoaderDepth = new RecursionCounter();
    AllPermission allPerm = new AllPermission();
    IdentityScope scope;
    Hashtable loadedClasses;

    public int getNetworkMode() {
        return this.networkMode;
    }

    public SandboxSecurity() {
        this.reset();
    }

    public SandboxSecurity(boolean bl) {
        this.reset();
        this.bNoExit = bl;
    }

    public void reset() {
        String string = System.getProperty("appletviewer.security.mode");
        this.networkMode = string == null ? 2 : (string.equals("unrestricted") ? 3 : (string.equals("none") ? 1 : 2));
        this.bCheckSecurity = !Boolean.getBoolean("stardiv.security.disableSecurity");
        IdentityScope identityScope = IdentityScope.getSystemScope();
        if (identityScope instanceof IdentityDatabase) {
            this.scope = (IdentityDatabase)identityScope;
            this.debug("installing " + identityScope + " as the scope for signers.");
        } else {
            this.debug("no signer scope found.");
        }
        this.loadedClasses = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean inApplet() {
        boolean bl = false;
        try {
            this.InCheck.acquire();
            bl = this.inClassLoader();
        }
        finally {
            this.InCheck.release();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object getSecurityContext() {
        URL uRL;
        block4: {
            uRL = null;
            try {
                this.InCheck.acquire();
                ClassLoader classLoader = this.currentClassLoader();
                if (classLoader == null) break block4;
                if (classLoader instanceof ClassContextImpl) {
                    ClassContextImpl classContextImpl = (ClassContextImpl)classLoader;
                    uRL = classContextImpl.getBase();
                    break block4;
                }
                throw new SandboxSecurityException("getsecuritycontext.unknown");
            }
            finally {
                this.InCheck.release();
            }
        }
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkCreateClassLoader() {
        try {
            this.InCheck.acquire();
            if (this.bCheckSecurity && !this.isSecureLoader() && this.classLoaderDepth() == 2) {
                throw new SandboxSecurityException("checkcreateclassloader");
            }
        }
        finally {
            this.InCheck.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean inThreadGroup(ThreadGroup threadGroup) {
        boolean bl = false;
        try {
            this.InCheck.acquire();
            ClassLoader classLoader = this.currentClassLoader();
            if (classLoader instanceof ClassContextImpl) {
                ClassContextImpl classContextImpl = (ClassContextImpl)classLoader;
                ThreadGroup threadGroup2 = classContextImpl.getThreadGroup();
                bl = threadGroup2.parentOf(threadGroup);
            }
        }
        finally {
            this.InCheck.release();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean inThreadGroup(Thread thread) {
        boolean bl = false;
        try {
            this.InCheck.acquire();
            bl = this.inThreadGroup(thread.getThreadGroup());
        }
        finally {
            this.InCheck.release();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkAccess(Thread thread) {
        try {
            this.InCheck.acquire();
            if (this.bCheckSecurity && !this.isSecureLoader() && this.classLoaderDepth() == 3 && !this.inThreadGroup(thread)) {
                throw new SandboxSecurityException("checkaccess.thread");
            }
        }
        finally {
            this.InCheck.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkAccess(ThreadGroup threadGroup) {
        try {
            this.InCheck.acquire();
            if (this.bCheckSecurity && !this.isSecureLoader() && this.classLoaderDepth() == 4 && !this.inThreadGroup(threadGroup)) {
                throw new SandboxSecurityException("checkaccess.threadgroup", threadGroup.toString());
            }
        }
        finally {
            this.InCheck.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkExit(int n) {
        try {
            this.InCheck.acquire();
            if (this.bNoExit) {
                throw new SandboxSecurityException("checkexit", String.valueOf(n));
            }
            if (this.bCheckSecurity && !this.isSecureLoader() && this.inApplet()) {
                throw new SandboxSecurityException("checkexit", String.valueOf(n));
            }
        }
        finally {
            this.InCheck.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkExec(String string) {
        try {
            this.InCheck.acquire();
            if (this.bCheckSecurity && !this.isSecureLoader() && this.inApplet()) {
                throw new SandboxSecurityException("checkexec", string);
            }
        }
        finally {
            this.InCheck.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkLink(String string) {
        try {
            this.InCheck.acquire();
            if (this.bCheckSecurity && !this.isSecureLoader()) {
                switch (this.classLoaderDepth()) {
                    case 2: 
                    case 3: {
                        throw new SandboxSecurityException("checklink", string);
                    }
                }
            }
        }
        finally {
            this.InCheck.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkPropertiesAccess() {
        try {
            this.InCheck.acquire();
            if (this.bCheckSecurity && !this.isSecureLoader() && this.classLoaderDepth() == 2) {
                throw new SandboxSecurityException("checkpropsaccess");
            }
        }
        finally {
            this.InCheck.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkPropertyAccess(String string) {
        try {
            String string2;
            boolean bl;
            this.InCheck.acquire();
            if (this.bCheckSecurity && !this.isSecureLoader() && this.classLoaderDepth() == 2 && !(bl = new Boolean(string2 = System.getProperty(string + ".applet")).booleanValue())) {
                throw new SandboxSecurityException("checkpropsaccess.key", string2);
            }
        }
        finally {
            this.InCheck.release();
        }
    }

    void parseACL(Vector vector, String string, String string2) {
        String string3 = System.getProperty("path.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(string, string3);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.startsWith("~")) {
                vector.addElement(System.getProperty("user.home") + string4.substring(1));
                continue;
            }
            if (string4.equals("+")) {
                if (string2 == null) continue;
                this.parseACL(vector, string2, null);
                continue;
            }
            vector.addElement(string4);
        }
    }

    String[] parseACL(String string, String string2) {
        if (string == null) {
            return new String[0];
        }
        if (string.equals("*")) {
            return null;
        }
        Vector vector = new Vector();
        this.parseACL(vector, string, string2);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    void initializeACLs() {
        this.readACL = this.parseACL(System.getProperty("acl.read"), System.getProperty("acl.read.default"));
        this.writeACL = this.parseACL(System.getProperty("acl.write"), System.getProperty("acl.write.default"));
        this.initACL = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkRead(String string) {
        try {
            ClassLoader classLoader;
            this.InCheck.acquire();
            if (this.bCheckSecurity && !this.isSecureLoader() && (classLoader = this.currentClassLoader()) != null) {
                if (!(classLoader instanceof ClassContextImpl)) {
                    throw new SandboxSecurityException("checkread.unknown", string);
                }
                ClassContextImpl classContextImpl = (ClassContextImpl)classLoader;
                URL uRL = classContextImpl.getBase();
                this.checkRead(string, uRL);
            }
        }
        finally {
            this.InCheck.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkRead(String string, URL uRL) {
        block16: {
            try {
                this.InCheck.acquire();
                if (!this.bCheckSecurity || uRL == null || this.isSecureLoader()) break block16;
                if (!this.initACL) {
                    this.initializeACLs();
                }
                if (this.readACL == null) {
                    this.InCheck.release();
                    return;
                }
                String string2 = null;
                try {
                    string2 = new File(string).getCanonicalPath();
                }
                catch (IOException iOException) {
                    throw new SandboxSecurityException("checkread.exception1", iOException.getMessage(), string);
                }
                int n = this.readACL.length;
                while (n-- > 0) {
                    if (!string2.startsWith(this.readACL[n])) continue;
                    this.InCheck.release();
                    return;
                }
                if (uRL.getProtocol().equals("file")) {
                    String string3 = null;
                    try {
                        StringBuffer stringBuffer = new StringBuffer(256);
                        String string4 = "%20";
                        String string5 = uRL.getFile();
                        int n2 = 0;
                        int n3 = 0;
                        while ((n3 = string5.indexOf(string4, n2)) != -1) {
                            stringBuffer.append(string5.substring(n2, n3));
                            stringBuffer.append(" ");
                            n2 = n3 + string4.length();
                        }
                        stringBuffer.append(string5.substring(n2));
                        String string6 = stringBuffer.toString();
                        string3 = new File(string6).getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        throw new SandboxSecurityException("checkread.exception2", iOException.toString());
                    }
                    if (string2.startsWith(string3)) {
                        this.InCheck.release();
                        return;
                    }
                }
                throw new SandboxSecurityException("checkread", string, string2);
            }
            finally {
                this.InCheck.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkRead(String string, Object object) {
        try {
            this.InCheck.acquire();
            this.checkRead(string);
            if (object != null) {
                this.checkRead(string, (URL)object);
            }
        }
        finally {
            this.InCheck.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkWrite(String string) {
        block10: {
            try {
                this.InCheck.acquire();
                if (!this.bCheckSecurity || !this.inApplet() || this.isSecureLoader()) break block10;
                if (!this.initACL) {
                    this.initializeACLs();
                }
                if (this.writeACL == null) {
                    this.InCheck.release();
                    return;
                }
                String string2 = null;
                try {
                    string2 = new File(string).getCanonicalPath();
                }
                catch (IOException iOException) {
                    throw new SandboxSecurityException("checkwrite.exception", iOException.getMessage(), string);
                }
                int n = this.writeACL.length;
                while (n-- > 0) {
                    if (!string2.startsWith(this.writeACL[n])) continue;
                    this.InCheck.release();
                    return;
                }
                throw new SandboxSecurityException("checkwrite", string, string2);
            }
            finally {
                this.InCheck.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkRead(FileDescriptor fileDescriptor) {
        try {
            this.InCheck.acquire();
            if (this.bCheckSecurity && !this.isSecureLoader() && (this.inApplet() && !this.inClass("java.net.SocketInputStream") || !fileDescriptor.valid())) {
                throw new SandboxSecurityException("checkread.fd");
            }
        }
        finally {
            this.InCheck.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkWrite(FileDescriptor fileDescriptor) {
        try {
            this.InCheck.acquire();
            if (this.bCheckSecurity && !this.isSecureLoader() && (this.inApplet() && !this.inClass("java.net.SocketOutputStream") || !fileDescriptor.valid())) {
                throw new SandboxSecurityException("checkwrite.fd");
            }
        }
        finally {
            this.InCheck.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkListen(int n) {
        try {
            this.InCheck.acquire();
            if (this.bCheckSecurity && !this.isSecureLoader() && this.inApplet() && n > 0 && n < 1024) {
                throw new SandboxSecurityException("checklisten", String.valueOf(n));
            }
        }
        finally {
            this.InCheck.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkAccept(String string, int n) {
        try {
            this.InCheck.acquire();
            if (this.bCheckSecurity && !this.isSecureLoader()) {
                if (this.inApplet() && n < 1024) {
                    throw new SandboxSecurityException("checkaccept", string, String.valueOf(n));
                }
                this.checkConnect(string, n);
            }
        }
        finally {
            this.InCheck.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkConnect(String string, int n) {
        block10: {
            try {
                this.InCheck.acquire();
                if (!this.bCheckSecurity || this.isSecureLoader()) break block10;
                ClassLoader classLoader = this.currentClassLoader();
                if (classLoader == null) {
                    this.InCheck.release();
                    return;
                }
                int n2 = this.classDepth("sun.net.www.http.HttpClient");
                if (n2 > 1) {
                    this.InCheck.release();
                    return;
                }
                if (this.getInCheck()) {
                    this.InCheck.release();
                    return;
                }
                if (classLoader instanceof ClassContextImpl) {
                    ClassContextImpl classContextImpl = (ClassContextImpl)classLoader;
                    this.checkConnect(classContextImpl.getBase().getHost(), string);
                    break block10;
                }
                throw new SandboxSecurityException("checkconnect.unknown");
            }
            finally {
                this.InCheck.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkConnect(String string, int n, Object object) {
        try {
            this.InCheck.acquire();
            this.checkConnect(string, n);
            if (object != null) {
                this.checkConnect(((URL)object).getHost(), string);
            }
        }
        finally {
            this.InCheck.release();
        }
    }

    /*
     * Exception decompiling
     */
    public synchronized void checkConnect(String var1_1, String var2_2, boolean var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkConnect(String string, String string2) {
        try {
            this.InCheck.acquire();
            this.checkConnect(string, string2, Boolean.getBoolean("trustProxy"));
        }
        finally {
            this.InCheck.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean checkTopLevelWindow(Object object) {
        boolean bl = true;
        try {
            this.InCheck.acquire();
            if (this.bCheckSecurity && this.inClassLoader() && !this.isSecureLoader()) {
                bl = false;
            }
        }
        finally {
            this.InCheck.release();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkPackageAccess(String string) {
        try {
            this.InCheck.acquire();
            if (this.bCheckSecurity && this.inClassLoader() && !this.isSecureLoader()) {
                int n;
                if (string.equals("stardiv.applet") || string.equals("stardiv.look") || string.equals("netscape.javascript")) {
                    this.InCheck.release();
                    return;
                }
                String[] stringArray = new String[]{"com.sun.star.uno", "com.sun.star.lib.uno", "com.sun.star.comp.connections", "com.sun.star.comp.loader", "com.sun.star.comp.servicemanager"};
                for (n = 0; n < stringArray.length; ++n) {
                    if (!string.startsWith(stringArray[n])) continue;
                    throw new SandboxSecurityException("checkpackageaccess2", string);
                }
                n = string.indexOf(46);
                while (n > 0) {
                    String string2 = string.substring(0, n);
                    if (Boolean.getBoolean("package.restrict.access." + string2)) {
                        throw new SandboxSecurityException("checkpackageaccess", string);
                    }
                    n = string.indexOf(46, n + 1);
                }
            }
        }
        finally {
            this.InCheck.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkPackageDefinition(String string) {
        try {
            this.InCheck.acquire();
        }
        finally {
            this.InCheck.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkSetFactory() {
        try {
            this.InCheck.acquire();
            if (this.bCheckSecurity && this.inApplet() && !this.isSecureLoader()) {
                throw new SandboxSecurityException("cannotsetfactory");
            }
        }
        finally {
            this.InCheck.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkMemberAccess(Class clazz, int n) {
        try {
            ClassLoader classLoader;
            this.InCheck.acquire();
            if (this.bCheckSecurity && !this.isSecureLoader() && n != 0 && (classLoader = this.currentClassLoader()) != null && this.classLoaderDepth() <= 3 && classLoader != clazz.getClassLoader()) {
                throw new SandboxSecurityException("checkmemberaccess");
            }
        }
        finally {
            this.InCheck.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkPrintJobAccess() {
        try {
            this.InCheck.acquire();
            if (this.bCheckSecurity && this.inApplet() && !this.isSecureLoader()) {
                throw new SandboxSecurityException("checkgetprintjob");
            }
        }
        finally {
            this.InCheck.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkSystemClipboardAccess() {
        try {
            this.InCheck.acquire();
            if (this.bCheckSecurity && this.inApplet() && !this.isSecureLoader()) {
                throw new SandboxSecurityException("checksystemclipboardaccess");
            }
        }
        finally {
            this.InCheck.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkAwtEventQueueAccess() {
        try {
            this.InCheck.acquire();
            if (this.bCheckSecurity && this.inClassLoader() && !this.isSecureLoader()) {
                // empty if block
            }
        }
        finally {
            this.InCheck.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkSecurityAccess(String string) {
        try {
            this.InCheck.acquire();
            if (this.bCheckSecurity && this.inApplet() && !this.isSecureLoader()) {
                throw new SandboxSecurityException("checksecurityaccess", string);
            }
        }
        finally {
            this.InCheck.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ThreadGroup getThreadGroup() {
        ThreadGroup threadGroup = null;
        try {
            this.InCheck.acquire();
            ClassLoader classLoader = this.currentClassLoader();
            if (classLoader != null && classLoader instanceof ClassContextImpl) {
                if (this.inThreadGroup(Thread.currentThread())) {
                    threadGroup = Thread.currentThread().getThreadGroup();
                } else {
                    ClassContextImpl classContextImpl = (ClassContextImpl)classLoader;
                    threadGroup = classContextImpl.getThreadGroup();
                }
            } else {
                threadGroup = super.getThreadGroup();
            }
        }
        finally {
            this.InCheck.release();
        }
        return threadGroup;
    }

    public void debug(String string) {
        if (debug) {
            System.err.println(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean isSecureLoader() {
        this.InIsSecureLoader.acquire();
        try {
            boolean bl = false;
            ClassLoader classLoader = this.currentClassLoader();
            bl = classLoader != null ? (classLoader instanceof ClassContextImpl ? !((ClassContextImpl)classLoader).checkSecurity() : true) : true;
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            this.InIsSecureLoader.release();
        }
    }

    public synchronized void checkPermission(Permission permission) {
        if ((this.InIsSecureLoader.inRecursion() || this.InInClassLoader.inRecursion() || this.InClassLoaderDepth.inRecursion()) && permission.implies(this.allPerm)) {
            throw new SandboxSecurityException("checkPermission ", permission.toString());
        }
        if (!this.InCheck.inRecursion() && !this.isSecureLoader()) {
            throw new SandboxSecurityException("checkPermission ", permission.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean inClassLoader() {
        this.InInClassLoader.acquire();
        try {
            boolean bl = super.inClassLoader();
            return bl;
        }
        finally {
            this.InInClassLoader.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int classLoaderDepth() {
        this.InClassLoaderDepth.acquire();
        try {
            int n = super.classLoaderDepth();
            return n;
        }
        finally {
            this.InClassLoaderDepth.release();
        }
    }
}

