/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ObjToIntMap;

public class VariableTable {
    private ObjArray itsVariables = new ObjArray();
    private ObjToIntMap itsVariableNames = new ObjToIntMap(11);
    private int varStart;

    public int size() {
        return this.itsVariables.size();
    }

    public int getParameterCount() {
        return this.varStart;
    }

    public Object getVariable(int n) {
        return this.itsVariables.get(n);
    }

    public boolean hasVariable(String string) {
        return this.itsVariableNames.has(string);
    }

    public Object getVariable(String string) {
        int n = this.itsVariableNames.get(string, -1);
        if (n != -1) {
            return this.itsVariables.get(n);
        }
        return null;
    }

    public int getOrdinal(String string) {
        return this.itsVariableNames.get(string, -1);
    }

    public void getAllVariables(Object[] objectArray) {
        this.itsVariables.toArray(objectArray);
    }

    public void addParameter(String string, Object object) {
        if (this.varStart != this.itsVariables.size()) {
            Context.codeBug();
        }
        int n = this.itsVariableNames.get(string, -1);
        if (this.itsVariableNames.has(string)) {
            String string2 = Context.getMessage1("msg.dup.parms", string);
            Context.reportWarning(string2, null, 0, null, 0);
        }
        int n2 = this.varStart++;
        this.itsVariables.add(object);
        this.itsVariableNames.put(string, n2);
    }

    public void addLocal(String string, Object object) {
        int n = this.itsVariableNames.get(string, -1);
        if (n != -1) {
            return;
        }
        int n2 = this.itsVariables.size();
        this.itsVariables.add(object);
        this.itsVariableNames.put(string, n2);
    }

    public void removeLocal(String string) {
        int n = this.itsVariableNames.get(string, -1);
        if (n != -1) {
            this.itsVariables.remove(n);
            this.itsVariableNames.remove(string);
            ObjToIntMap.Iterator iterator = this.itsVariableNames.newIterator();
            iterator.start();
            while (!iterator.done()) {
                int n2 = iterator.getValue();
                if (n2 > n) {
                    iterator.setValue(n2 - 1);
                }
                iterator.next();
            }
        }
    }
}

