/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager;

import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.jar.Manifest;
import org.netbeans.modules.jarpackager.CompressionEditor;
import org.netbeans.modules.jarpackager.CompressionLevel;
import org.netbeans.modules.jarpackager.DataObjectListEditor;
import org.netbeans.modules.jarpackager.FileObjectFilter;
import org.netbeans.modules.jarpackager.FilterEditor;
import org.netbeans.modules.jarpackager.JarCompiler;
import org.netbeans.modules.jarpackager.JarContent;
import org.netbeans.modules.jarpackager.JarCreator;
import org.netbeans.modules.jarpackager.JarDataLoader;
import org.netbeans.modules.jarpackager.JarExecutor;
import org.netbeans.modules.jarpackager.ManifestTab;
import org.netbeans.modules.jarpackager.api.ExtendedPropertyFactory;
import org.netbeans.modules.jarpackager.options.JarPackagerOption;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.cookies.CompilerCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SaveCookie;
import org.openide.execution.Executor;
import org.openide.execution.NbClassPath;
import org.openide.explorer.propertysheet.editors.FileOnlyEditor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.ExecSupport;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.SystemAction;

public class JarDataObject
extends MultiDataObject
implements OpenCookie,
CompilerCookie.Compile,
CompilerCookie.Build {
    static final long serialVersionUID = 2983457824351249776L;
    static final String EA_JAR_CONTENT = "NetBeans-JarContent";
    transient JarContent jarContent;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarDataObject$Save;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarDataObject;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarDataLoader;

    public JarDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
        this.getCookieSet().add((Node.Cookie)new JarExecSupport(this.getPrimaryEntry()));
    }

    public void open() {
    }

    protected void handleDelete() throws IOException {
        super.handleDelete();
        this.setModified(false);
    }

    public void setModified(boolean bl) {
        CookieSet cookieSet = this.getCookieSet();
        Save save = (Save)cookieSet.getCookie(class$org$netbeans$modules$jarpackager$JarDataObject$Save == null ? (class$org$netbeans$modules$jarpackager$JarDataObject$Save = JarDataObject.class$("org.netbeans.modules.jarpackager.JarDataObject$Save")) : class$org$netbeans$modules$jarpackager$JarDataObject$Save);
        if (bl && save == null) {
            cookieSet.add((Node.Cookie)new Save());
        } else if (!bl && save != null) {
            cookieSet.remove((Node.Cookie)save);
        }
        super.setModified(bl);
    }

    public void save() throws IOException {
        this.writeJarContent(this.getJarContent());
        this.setModified(false);
    }

    public boolean isDepthSupported(Compiler.Depth depth) {
        return Compiler.DEPTH_ONE.equals(depth);
    }

    public void addToJob(CompilerJob compilerJob, Compiler.Depth depth) {
        JarContent jarContent = this.getJarContent();
        if (jarContent == null) {
            return;
        }
        File file = jarContent.getTargetFile();
        if (file == null) {
            String string;
            FileObject fileObject = this.findContentFile();
            FileObject fileObject2 = FileUtil.findBrother((FileObject)fileObject, (String)(string = ((JarDataLoader)this.getLoader()).getArchiveExt()));
            if (fileObject2 == null) {
                try {
                    fileObject2 = fileObject.getParent().createData(fileObject.getName(), string);
                }
                catch (IOException iOException) {
                    TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Exception((Throwable)iOException, (Object)NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarDataObject == null ? (class$org$netbeans$modules$jarpackager$JarDataObject = JarDataObject.class$("org.netbeans.modules.jarpackager.JarDataObject")) : class$org$netbeans$modules$jarpackager$JarDataObject)).getString("MSG_CreateArchiveError")));
                    return;
                }
            }
            jarContent.setTargetFile(NbClassPath.toFile((FileObject)fileObject2));
            this.setModified(true);
        }
        compilerJob.add((Compiler)new JarCompiler(jarContent, this));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeJarContent(JarContent jarContent) throws IOException {
        FileObject fileObject = this.findContentFile();
        FileObject fileObject2 = this.getPrimaryFile();
        FileLock fileLock = null;
        try {
            if (fileObject == null) {
                fileObject = fileObject2.getParent().createData(fileObject2.getName(), JarPackagerOption.singleton().getContentExt());
            }
            fileLock = fileObject.lock();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileObject.getOutputStream(fileLock));
            try {
                jarContent.writeContent(objectOutputStream);
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                objectOutputStream.close();
                throw throwable;
            }
            objectOutputStream.close();
            Object var9_9 = null;
            if (fileLock == null) return;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (fileLock == null) throw throwable;
            fileLock.releaseLock();
            throw throwable;
        }
        fileLock.releaseLock();
    }

    public JarContent getJarContent() {
        if (this.jarContent == null) {
            FileObject fileObject = this.findContentFile();
            if (fileObject == null) {
                return null;
            }
            this.jarContent = JarContent.readFromFile(fileObject);
        }
        return this.jarContent;
    }

    protected FileObject findContentFile() {
        return this.getPrimaryFile();
    }

    public FileObject findArchiveFile() {
        FileObject fileObject = this.findContentFile();
        return FileUtil.findBrother((FileObject)fileObject, (String)((JarDataLoader)this.getLoader()).getArchiveExt());
    }

    public File defaultArchiveFile() {
        return JarDataObject.defaultArchiveFile(NbClassPath.toFile((FileObject)this.getPrimaryFile()), ((JarDataLoader)this.getLoader()).getArchiveExt());
    }

    public static File defaultArchiveFile(File file, String string) {
        if (file != null) {
            String string2;
            try {
                string2 = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                return null;
            }
            String string3 = string2;
            JarDataLoader jarDataLoader = (JarDataLoader)SharedClassObject.findObject((Class)(class$org$netbeans$modules$jarpackager$JarDataLoader == null ? (class$org$netbeans$modules$jarpackager$JarDataLoader = JarDataObject.class$("org.netbeans.modules.jarpackager.JarDataLoader")) : class$org$netbeans$modules$jarpackager$JarDataLoader));
            int n = string2.lastIndexOf("." + jarDataLoader.getExtension());
            if (n > 0) {
                string3 = string2.substring(0, n);
            }
            return new File(string3 + "." + string);
        }
        return null;
    }

    public boolean usesDefaultArchiveFile() {
        File file = this.getJarContent().getTargetFile();
        File file2 = this.defaultArchiveFile();
        try {
            return file != null && file.getCanonicalPath().equals(file2.getPath());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    protected Node createNodeDelegate() {
        return new JarNode((DataObject)this);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$jarpackager$JarDataObject == null ? (class$org$netbeans$modules$jarpackager$JarDataObject = JarDataObject.class$("org.netbeans.modules.jarpackager.JarDataObject")) : class$org$netbeans$modules$jarpackager$JarDataObject);
    }

    protected synchronized DataObject handleCopy(DataFolder dataFolder) throws IOException {
        DataObject dataObject = super.handleCopy(dataFolder);
        try {
            dataObject.setValid(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return dataObject;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class JarExecSupport
    extends ExecSupport {
        public JarExecSupport(MultiDataObject.Entry entry) {
            super(entry);
        }

        protected Executor defaultExecutor() {
            return new JarExecutor();
        }
    }

    public static class JarNode
    extends DataNode {
        static final String JAR_ICON_BASE = "org/netbeans/modules/jarpackager/resources/jarObject";
        private static ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarPackagerModule == null ? (class$org$netbeans$modules$jarpackager$JarPackagerModule = JarNode.class$("org.netbeans.modules.jarpackager.JarPackagerModule")) : class$org$netbeans$modules$jarpackager$JarPackagerModule));
        static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarPackagerModule;
        static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
        static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarDataObject;
        static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarDataObject$JarNode;
        static /* synthetic */ Class class$org$openide$loaders$ExecSupport;
        static /* synthetic */ Class class$java$io$File;
        static /* synthetic */ Class class$org$netbeans$modules$jarpackager$CompressionLevel;
        static /* synthetic */ Class class$org$netbeans$modules$jarpackager$FileObjectFilter;
        static /* synthetic */ Class class$java$util$jar$Manifest;
        static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarContent;

        public JarNode(DataObject dataObject) {
            this(dataObject, Children.LEAF);
        }

        public JarNode(DataObject dataObject, Children children) {
            super(dataObject, children);
            this.setIconBase(JAR_ICON_BASE);
            this.setDefaultAction(SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = JarNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction)));
        }

        protected Sheet createSheet() {
            Sheet sheet = super.createSheet();
            sheet.get("properties").put(this.createLocationProperty());
            sheet.get("properties").put(this.createCompressionProperty());
            sheet.get("properties").put(this.createFilterProperty());
            sheet.get("properties").put(this.createManifestProperty());
            sheet.get("properties").put(this.createContentsProperty());
            this.addExtendedProperties(sheet);
            Sheet.Set set = new Sheet.Set();
            set.setName(NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarDataObject == null ? (class$org$netbeans$modules$jarpackager$JarDataObject = JarNode.class$("org.netbeans.modules.jarpackager.JarDataObject")) : class$org$netbeans$modules$jarpackager$JarDataObject)).getString("CTL_ExecutionSet"));
            set.setDisplayName(NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarDataObject$JarNode == null ? (class$org$netbeans$modules$jarpackager$JarDataObject$JarNode = JarNode.class$("org.netbeans.modules.jarpackager.JarDataObject$JarNode")) : class$org$netbeans$modules$jarpackager$JarDataObject$JarNode)).getString("PROP_executionSetName"));
            set.setShortDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarDataObject$JarNode == null ? (class$org$netbeans$modules$jarpackager$JarDataObject$JarNode = JarNode.class$("org.netbeans.modules.jarpackager.JarDataObject$JarNode")) : class$org$netbeans$modules$jarpackager$JarDataObject$JarNode)).getString("HINT_executionSetName"));
            ExecSupport execSupport = (ExecSupport)this.getCookie(class$org$openide$loaders$ExecSupport == null ? (class$org$openide$loaders$ExecSupport = JarNode.class$("org.openide.loaders.ExecSupport")) : class$org$openide$loaders$ExecSupport);
            if (execSupport != null) {
                execSupport.addProperties(set);
                set.remove("debuggerType");
            }
            sheet.put(set);
            return sheet;
        }

        public JarContent getJarContent() {
            return ((JarDataObject)this.getDataObject()).getJarContent();
        }

        public void setModified(boolean bl) {
            ((JarDataObject)this.getDataObject()).setModified(bl);
        }

        public FileObject getJarContentFile() {
            return this.getDataObject().getPrimaryFile();
        }

        public void addExtendedProperties(Sheet sheet) {
            Map map = JarCreator.getExtendedProperties();
            if (map == null) {
                return;
            }
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                ExtendedPropertyFactory extendedPropertyFactory = (ExtendedPropertyFactory)iterator.next();
                Node.Property property = extendedPropertyFactory.createProperty(this.getDataObject(), this.getJarContent());
                sheet.get("properties").put(property);
            }
        }

        public Node.Property createLocationProperty() {
            return new PropertySupport.ReadWrite("location", class$java$io$File == null ? (class$java$io$File = JarNode.class$("java.io.File")) : class$java$io$File, bundle.getString("PROP_Location"), bundle.getString("CTL_LocationTip")){

                public Object getValue() {
                    return this.getJarContent().getTargetFile();
                }

                public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                    if (!(object instanceof File)) {
                        throw new IllegalArgumentException();
                    }
                    try {
                        JarContent jarContent = this.getJarContent();
                        jarContent.setTargetFile((File)object);
                        this.setModified(true);
                    }
                    catch (Exception exception) {
                        throw new IllegalArgumentException();
                    }
                }

                public PropertyEditor getPropertyEditor() {
                    return new FileOnlyEditor();
                }
            };
        }

        public Node.Property createCompressionProperty() {
            return new PropertySupport.ReadWrite(this, "compression", class$org$netbeans$modules$jarpackager$CompressionLevel == null ? (class$org$netbeans$modules$jarpackager$CompressionLevel = JarNode.class$("org.netbeans.modules.jarpackager.CompressionLevel")) : class$org$netbeans$modules$jarpackager$CompressionLevel, bundle.getString("PROP_Compression"), bundle.getString("CTL_CompressionLevelTip")){
                private final /* synthetic */ JarNode this$0;
                {
                    this.this$0 = jarNode;
                }

                public Object getValue() {
                    return this.this$0.getJarContent().getCompLevel();
                }

                public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                    if (!(object instanceof CompressionLevel)) {
                        throw new IllegalArgumentException();
                    }
                    try {
                        JarContent jarContent = this.this$0.getJarContent();
                        jarContent.setCompLevel((CompressionLevel)object);
                        this.this$0.setModified(true);
                    }
                    catch (Exception exception) {
                        throw new IllegalArgumentException();
                    }
                }

                public PropertyEditor getPropertyEditor() {
                    return new CompressionEditor();
                }
            };
        }

        public Node.Property createFilterProperty() {
            PropertySupport.ReadWrite readWrite = new PropertySupport.ReadWrite(this, "filter", class$org$netbeans$modules$jarpackager$FileObjectFilter == null ? (class$org$netbeans$modules$jarpackager$FileObjectFilter = JarNode.class$("org.netbeans.modules.jarpackager.FileObjectFilter")) : class$org$netbeans$modules$jarpackager$FileObjectFilter, bundle.getString("PROP_Filter"), bundle.getString("CTL_FilterTip")){
                private final /* synthetic */ JarNode this$0;
                {
                    this.this$0 = jarNode;
                }

                public Object getValue() {
                    return this.this$0.getJarContent().getFilter();
                }

                public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                    if (!(object instanceof FileObjectFilter)) {
                        throw new IllegalArgumentException();
                    }
                    try {
                        JarContent jarContent = this.this$0.getJarContent();
                        jarContent.setFilter((FileObjectFilter)object);
                        this.this$0.setModified(true);
                    }
                    catch (Exception exception) {
                        throw new IllegalArgumentException();
                    }
                }

                public PropertyEditor getPropertyEditor() {
                    return new FilterEditor();
                }
            };
            readWrite.setValue("canEditAsText", Boolean.FALSE);
            return readWrite;
        }

        public Node.Property createManifestProperty() {
            PropertySupport.ReadWrite readWrite = new PropertySupport.ReadWrite(this, "manifest", class$java$util$jar$Manifest == null ? (class$java$util$jar$Manifest = JarNode.class$("java.util.jar.Manifest")) : class$java$util$jar$Manifest, bundle.getString("PROP_Manifest"), bundle.getString("CTL_ManifestTip")){
                private final /* synthetic */ JarNode this$0;
                {
                    this.this$0 = jarNode;
                }

                public Object getValue() {
                    return this.this$0.getJarContent().getManifest();
                }

                public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                    if (!(object instanceof Manifest)) {
                        throw new IllegalArgumentException();
                    }
                    try {
                        JarContent jarContent = this.this$0.getJarContent();
                        jarContent.setManifest((Manifest)object);
                        this.this$0.setModified(true);
                    }
                    catch (Exception exception) {
                        throw new IllegalArgumentException();
                    }
                }

                public PropertyEditor getPropertyEditor() {
                    ManifestTab manifestTab = new ManifestTab();
                    manifestTab.setJarContentFile(this.this$0.getJarContentFile().getPackageNameExt('/', '.'));
                    return manifestTab;
                }
            };
            readWrite.setValue("canEditAsText", Boolean.FALSE);
            return readWrite;
        }

        public Node.Property createContentsProperty() {
            PropertySupport.ReadWrite readWrite = new PropertySupport.ReadWrite(this, "contents", class$org$netbeans$modules$jarpackager$JarContent == null ? (class$org$netbeans$modules$jarpackager$JarContent = JarNode.class$("org.netbeans.modules.jarpackager.JarContent")) : class$org$netbeans$modules$jarpackager$JarContent, bundle.getString("PROP_Contents"), bundle.getString("CTL_ContentsTip")){
                private final /* synthetic */ JarNode this$0;
                {
                    this.this$0 = jarNode;
                }

                public Object getValue() {
                    return this.this$0.getJarContent().makeCopy();
                }

                public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                    if (!(object instanceof JarContent)) {
                        throw new IllegalArgumentException();
                    }
                    try {
                        this.this$0.getJarContent().setContentList(((JarContent)object).getContentList());
                        this.this$0.setModified(true);
                    }
                    catch (Exception exception) {
                        throw new IllegalArgumentException();
                    }
                }

                public PropertyEditor getPropertyEditor() {
                    return new DataObjectListEditor();
                }
            };
            readWrite.setValue("canEditAsText", Boolean.FALSE);
            return readWrite;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private class Save
    implements SaveCookie {
        private Save() {
        }

        public void save() throws IOException {
            JarDataObject.this.save();
        }
    }
}

