#ifndef HL_ACCOUNT_H
#define HL_ACCOUNT_H

// these shouldn't be set higher than 31
#define USERNAME_MAXLEN 31
#define PASSWORD_MAXLEN 31

#include <string>
#include "HLProtocol.h" // for struct hl_access_bits

using namespace std;

class HLAccount
{
    public:
        HLAccount();
        ~HLAccount();
        
        const string &Login() const
            { return mLogin; }
        
        const string &Name() const
            { return mName; }
        
        const string &Password() const
            { return mPassword; }
        
        const struct hl_access_bits &Access() const
            { return mAccessBits; }
        
        const string &FilesPath() const
            { return mFilesPath; }
        
        const u_int32_t MaxBps() const
            { return mMaxBps; }
        
        void SetLogin(const string &inLogin)
            { mLogin = inLogin; }
        
        void SetName(const string &inName)
            { mName = inName; }
        
        void SetPassword(const string &inPassword)
            { mPassword = inPassword; }
        
        void SetAccess(const struct hl_access_bits &inAccessBits)
            { mAccessBits = inAccessBits; }
        
        void SetFilesPath(const string &inFilesPath);
        
        void SetMaxBps(const u_int32_t inMaxBps)
            { mMaxBps = inMaxBps; }
        
        bool IsGuest() const
			{ return (mLogin == "guest"); }
        
    protected:
        string mLogin;
        string mName;
        string mPassword;
        struct hl_access_bits mAccessBits;
        string mFilesPath;
        u_int32_t mMaxBps;
};

#endif // HL_ACCOUNT_H

