// class for private chats used by HLServer and HLClient

#ifndef HL_CHAT_H
#define HL_CHAT_H

#include <string>
#include "HLServer.h"

#define ChatIDToChatPtr(id) (HLChat *)((u_int32_t)id == 0 ? 0 : (u_int32_t)id - 0x0000BEEF)
#define ChatPtrToChatID(ptr) ((u_int32_t)ptr + 0x0000BEEF)

class HLChat
{
	public:
		HLChat(HLClient &inCreator, string &inName);
		~HLChat();
		
		void AddClient(HLClient &inClient);
		void RemoveClient(HLClient &inClient);
		void SendToClients(HLPacket &inPacket);
		bool IsClientInChat(HLClient &inClient);
		void AddUserListToPacket(HLPacket &ioPacket);
		
		bool IsEmpty() const
			{ return mClientList.empty(); }
		
		void SetSubject(const string &inSubject);
		void GetSubject(string &outSubject);
		
	protected:
		string mName;
		string mSubject;
		ClientList mClientList;
};

#endif // HL_CHAT_H


