#include "HLUser.h"
#include "FileUtils.h"
#include "HLServer.h"

#if !defined(WIN32)
#include <arpa/inet.h>
#endif // !WIN32

using namespace FileUtils;

HLUser::HLUser()
	: mID(0), mIcon(0), mStatus(0), mLoggedIn(false),
    mConnectionID(0), mLoginTime(0), mLastRecvTime(0)
{
#if defined(CONFIG_LINKING)
	mGlobalID = 0;
#endif
}

HLUser::~HLUser()
{
}

void HLUser::GetHLUser(HL_USER *outUser) const
{
	// store user data in structure to be sent over network
	outUser->id = htons(mID);
	outUser->icon = htons(mIcon);
	outUser->status = htons(mStatus);
	outUser->nlen = htons(Name().length());
	if (!Name().empty())
		strcpy(outUser->name, Name().c_str());
}

void HLUser::GetInfo(const string &inAddress, string &outInfoString, bool inFull)
{
	char infoBuf[1025];
	string timeString;
    time_t currentTime = time(0);
	
	formatTime((currentTime - mLoginTime), timeString);
    
    if (inFull)
    {
        snprintf(infoBuf, 1024,
			"    User: %s\r      ID: %u\r   Login: %s\r Address: %s\r  Online: %s",
            mName.c_str(), mID, mAccount.Login().c_str(), inAddress.c_str(), timeString.c_str());
    }
    else
    {
        snprintf(infoBuf, 1024, "    User: %s\r      ID: %u\r  Online: %s",
            mName.c_str(), mID, timeString.c_str());
    }
    
    outInfoString.assign(infoBuf);
    
    if (mStatus & IDLE_MASK)
    {
        formatTime((currentTime - mLastRecvTime), timeString);
        outInfoString.append("\r    Idle: ");
        outInfoString.append(timeString);
    }
}

void HLUser::SetName(const string &inName)
{
    mName = inName;
    // need to filter for \n \r because all clients don't
    string::size_type pos = 0;
    while ((pos = mName.find('\r')) != string::npos)
    {
        mName.erase(pos, pos + 1);
    }
    pos = 0;
    while ((pos = mName.find('\n')) != string::npos)
    {
        mName.erase(pos, pos + 1);
    }	
}

const string HLUser::Name() const
{
	string name;
	if (Access().use_any_name)
		name = mName;
	else
		name = mAccount.Name();
	
	if (name.length() == 0)
		name = "unnamed";
	return name;
}
