#if defined(_HTTPD_)
#include "WebServer.h"
#include "HLServer.h"
#include "ServerConf.h"
#include "FileUtils.h"
#include "HLClient.h"
#include <limits.h>
#ifdef WIN32
#include "ServerLog.h"
#endif//WIN32

//#define docType "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">"
//#define charSet "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />"


WebServer::WebServer()
    : mServer(NULL)
{
}

WebServer::~WebServer()
{
}

void WebServer::Run()
{
    u_int16_t webPort = 0;
    
    {
        StMutexLock lock(gServer->mLock);
        webPort = (gServer->Config().serverPort + 2);
    }
    
		//2003/07/30 added by ortana.
#ifdef WIN32
		char path_buff[MAX_PATH];
		sprintf( path_buff , "Winterra web server started. http://localhost:%d" , webPort);
		ServerLog::OtherLog( "info" , path_buff );
#endif//WIN32

    DEBUG_CALL(printf("binding web server to port: %d\n", webPort); fflush(stdout));
    mServer = httpdCreate(HTTP_ANY_ADDR, webPort);
    assert(mServer != NULL);
    
    DEBUG_CALL(
        httpdSetAccessLog(mServer, stdout);
        httpdSetErrorLog(mServer, stdout);
    );
    
    httpdSetContextPtr(mServer, this);
    httpdAddCContent(mServer, "/", "index.html",
        HTTP_TRUE, NULL, indexPage);
    
    httpdAddCContent(mServer, "/", "login.html",
        HTTP_FALSE, preloadAuthenticate, loginPage);
    httpdAddCContent(mServer, "/", "shutdown.html",
        HTTP_FALSE, preloadAuthenticate, shutdownPage);
    httpdAddCContent(mServer, "/", "config.html",
        HTTP_FALSE, preloadAuthenticate, configPage);
    httpdAddCContent(mServer, "/", "reconfig.html",
        HTTP_FALSE, preloadAuthenticate, reconfigPage);
    httpdAddCContent(mServer, "/", "status.html",
        HTTP_FALSE, preloadAuthenticate, statusPage);
    httpdAddCContent(mServer, "/", "news.html",
        HTTP_FALSE, preloadAuthenticate, newsPage);
    httpdAddCContent(mServer, "/", "broadcast.html",
        HTTP_FALSE, preloadAuthenticate, broadcastPage);
    
    //struct timeval timeout;
    //timeout.tv_sec = 5;
	//timeout.tv_usec = 0;
    while (gServer->IsRunning())
    {
        int result = httpdGetConnection(mServer, NULL /* &timeout */);
		//if (result == 0)
		//{
		//	printf("Timeout ... \n");
		//	continue;
		//}
		if (result < 0)
		{
			printf("Error ... \n");
			continue;
		}
		if(httpdReadRequest(mServer) < 0)
		{
			httpdEndRequest(mServer);
			continue;
		}
		httpdProcessRequest(mServer);
		httpdEndRequest(mServer);
    }
    
    httpdDestroy(mServer);
    mServer = NULL;
}

void WebServer::indexPage(httpd *inServer)
{
    //httpdPrintf(inServer, docType);
    httpdPrintf(inServer, "<html><head><title>Terra Server</title></head>");
    
    time_t currentTime = time(0);
    struct tm tm;
    char timeBuf[256];
    localtime_r(&currentTime, &tm);
    strftime(timeBuf, 255, " %A %m/%d/%Y %r", &tm);
    string timeString;
    string sizeString;
    StMutexLock lock(gServer->mLock);
    httpdPrintf(inServer, "<body><p>Welcome to %s</p>", gServer->Config().serverName.c_str());
    httpdPrintf(inServer, "Current local time is %s.<br />", timeBuf);
    FileUtils::formatTime(gServer->Uptime(currentTime), timeString);
    httpdPrintf(inServer, "The server has been up for %s.<br />", timeString.c_str());
    httpdPrintf(inServer, "%u users connected. %u connections total.<br />",
        gServer->mClientList.size(), gServer->mTotalConnections);
    httpdPrintf(inServer, "%u downloads active, %u queued, and %u uploads.<br />",
        gServer->mTransAM->mDownloadList.size(), gServer->mTransAM->mDownloadQueue.size(),
        gServer->mTransAM->mUploadList.size());
    if (gServer->mTransAM->mTotalDownloads)
    {
        FileUtils::formatSize(gServer->mTransAM->mTotalDownloadBytes, sizeString);
        httpdPrintf(inServer, "%s transfered for %u downloads.<br />",
            sizeString.c_str(), gServer->mTransAM->mTotalDownloads);
    }
    if (gServer->mTransAM->mTotalUploads)
    {
        FileUtils::formatSize(gServer->mTransAM->mTotalUploadBytes, sizeString);
        httpdPrintf(inServer, "%s transfered for %u uploads.<br />",
            sizeString.c_str(), gServer->mTransAM->mTotalUploads);
    }
    //httpdPrintf(inServer, "%u downloads and %u uploads.\n", );
    httpdPrintf(inServer, "<br /><a href=\"login.html\">Login</a></body></html>");
}

void WebServer::loginPage(httpd *inServer)
{
    WebServer *webServer = (WebServer *)httpdContextPtr(inServer);
    
    httpdPrintf(inServer, "<html><title>Logged in as: %s</title><body>",
        webServer->mUserAccount.Name().c_str());
    //httpdPrintf(inServer, "Your username is '%s'<br>", inServer->request.authUser);
    //httpdPrintf(inServer, "Your password is '%s'<br>", inServer->request.authPassword);
    if (webServer->mUserAccount.Access().get_user_info)
        httpdPrintf(inServer, "<a href=\"status.html\">Server Status</a><br>");
    
    if (webServer->mUserAccount.Access().read_news)
        httpdPrintf(inServer, "<a href=\"news.html\">Server News</a><br>");
    
    if (webServer->mUserAccount.Access().modify_users)
    {
        httpdPrintf(inServer, "<a href=\"config.html\">Server Config</a><br>");
        httpdPrintf(inServer, "<a href=\"shutdown.html\">Shutdown Server</a><br>");
    }
    
    if (webServer->mUserAccount.Access().can_broadcast)
    {
        httpdPrintf(inServer, "<br><form action=broadcast.html method=post>");
        httpdPrintf(inServer, "<input type=text name=message size=30>");
        httpdPrintf(inServer, " <input type=submit value=Broadcast></form><br>");
    }
    
    httpdPrintf(inServer, "</body></html>");
}

void WebServer::shutdownPage(httpd *inServer)
{
    WebServer *webServer = (WebServer *)httpdContextPtr(inServer);
    
    httpdPrintf(inServer, "<html><title>Shutdown</title><body>");
    if (webServer->mUserAccount.Access().modify_users)
    {
        httpVar	*msgVar;
        if ((msgVar = httpdGetVariableByName(inServer, "confirm")))
        {
            gServer->Stop();
            httpdPrintf(inServer, "The server has been shutdown.");
        }
        else
        {
            httpdPrintf(inServer, "<table><form action=shutdown.html method=post>");
            httpdPrintf(inServer, "<tr><td colspan=2>Are you sure you want to shutdown?</td></tr>");
            httpdPrintf(inServer, "<tr><td><input type=submit name=confirm value=\" Yes \"></form></td>");
            httpdPrintf(inServer, "<td><form action=login.html method=post>");
            httpdPrintf(inServer, "<input type=submit value=\" No \"></form></td></tr></table>");
        }
    }
    
    httpdPrintf(inServer, "</body></html>");
}

void WebServer::reconfigPage(httpd *inServer)
{
    WebServer *webServer = (WebServer *)httpdContextPtr(inServer);
    if (webServer->mUserAccount.Access().modify_users)
    {
        StMutexLock lock(gServer->mLock);
        httpVar	*msgVar;
        if ((msgVar = httpdGetVariableByName(inServer, "serverName")))
            gServer->Config().serverName = msgVar->value;
        if ((msgVar = httpdGetVariableByName(inServer, "serverDescription")))
            gServer->Config().serverDescription = msgVar->value;
        if ((msgVar = httpdGetVariableByName(inServer, "serverPort")))
            gServer->Config().serverPort = strtol(msgVar->value, 0, 0);
        if ((msgVar = httpdGetVariableByName(inServer, "maxUsers")))
            gServer->Config().maxUsers = strtol(msgVar->value, 0, 0);
        if ((msgVar = httpdGetVariableByName(inServer, "maxDownloads")))
            gServer->Config().maxDownloads = strtol(msgVar->value, 0, 0);
        if ((msgVar = httpdGetVariableByName(inServer, "maxUploads")))
            gServer->Config().maxUploads = strtol(msgVar->value, 0, 0);
        
        if ((msgVar = httpdGetVariableByName(inServer, "rootPath")))
            gServer->Config().rootPath = msgVar->value;
        if ((msgVar = httpdGetVariableByName(inServer, "agreementPath")))
            gServer->Config().agreementPath = msgVar->value;
        if ((msgVar = httpdGetVariableByName(inServer, "newsPath")))
            gServer->Config().newsPath = msgVar->value;
        if ((msgVar = httpdGetVariableByName(inServer, "accountsPath")))
            gServer->Config().accountsPath = msgVar->value;
        if ((msgVar = httpdGetVariableByName(inServer, "logsPath")))
            gServer->Config().logsPath = msgVar->value;
        
        if ((msgVar = httpdGetVariableByName(inServer, "databaseAddress")))
            gServer->Config().databaseAddress = msgVar->value;
        if ((msgVar = httpdGetVariableByName(inServer, "databaseUser")))
            gServer->Config().databaseUser = msgVar->value;
        if ((msgVar = httpdGetVariableByName(inServer, "databasePassword")))
            gServer->Config().databasePassword = msgVar->value;
        if ((msgVar = httpdGetVariableByName(inServer, "databaseName")))
            gServer->Config().databaseName = msgVar->value;
        if ((msgVar = httpdGetVariableByName(inServer, "databaseReadOnly")))
        {
            if (strtol(msgVar->value, 0, 0) == 1)
                gServer->Config().databaseReadOnly = true;
            else
            {
                gServer->Config().databaseReadOnly = false;
                DEBUG_CALL(printf("readOnly: %s\n", msgVar->value); fflush(stdout));
            }
        }
        else
            gServer->Config().databaseReadOnly = false;
        
        if ((msgVar = httpdGetVariableByName(inServer, "idleTimeout")))
            // convert from minutes to seconds
            gServer->Config().idleTimeout = (strtol(msgVar->value, 0, 0) * 60);
        if ((msgVar = httpdGetVariableByName(inServer, "banTimeout")))
            // convert from minutes to seconds
            gServer->Config().banTimeout = (strtol(msgVar->value, 0, 0) * 60);
        if ((msgVar = httpdGetVariableByName(inServer, "dirPermissions")))
            gServer->Config().dirPermissions = strtol(msgVar->value, 0, 0);
        if ((msgVar = httpdGetVariableByName(inServer, "filePermissions")))
            gServer->Config().filePermissions = strtol(msgVar->value, 0, 0);
        if ((msgVar = httpdGetVariableByName(inServer, "socksDetectLevel")))
            gServer->Config().socksDetectLevel = strtol(msgVar->value, 0, 0);
        
        if ((msgVar = httpdGetVariableByName(inServer, "trackerList")))
        {
			gServer->Config().trackerList.clear();
            
			string trackerListString(msgVar->value);
			string trackerDelimiter = "\r";
			string passwordDelimiter = ":";
			vector<string> trackers;
			FileUtils::fixLineEndings(trackerListString);
			FileUtils::splitString(trackerListString, trackerDelimiter, trackers);
			vector<string>::iterator iter = trackers.begin();
			while (iter != trackers.end())
			{
				vector<string> trackerItem;
				FileUtils::splitString((*iter), passwordDelimiter, trackerItem);
				if (trackerItem.size() == 1)
				{
					string emptyString;
					gServer->Config().trackerList.push_back(TrackerEntry(trackerItem[0], emptyString));
				}
				else if (trackerItem.size() > 1)
					gServer->Config().trackerList.push_back(TrackerEntry(trackerItem[0], trackerItem[1]));
				iter++;
			}
        }
        
        gServer->Config().WriteConf(gServer->Config().confFile.c_str());
        // reloading the conf file is unneeded for now, we just need to write it
        //gServer->ReloadConf();
    }
    
    httpdSetResponse(inServer, "301 Moved");
    httpdAddHeader(inServer, "Location: index.html");
    httpdSendHeaders(inServer);
}

void WebServer::configPage(httpd *inServer)
{
    WebServer *webServer = (WebServer *)httpdContextPtr(inServer);
    
    httpdPrintf(inServer, "<html><title>Server Config</title><body>");
    if (webServer->mUserAccount.Access().modify_users)
    {
        StMutexLock lock(gServer->mLock);
        //gServer->ReloadConf();
        httpdPrintf(inServer, "<html><title>Server Config</title><body>");
        httpdPrintf(inServer, "<form action=reconfig.html method=post>");
        httpdPrintf(inServer, "<table border=0 cellspacing=0 cellpadding=2>");
        httpdPrintf(inServer, "<tr><td align=right>Server Name:</td>");
        httpdPrintf(inServer, "<td><input type=text name=serverName size=32 value=\"%s\"></td></tr>",
            gServer->Config().serverName.c_str());
        httpdPrintf(inServer, "<tr><td align=right>Server Description:</td>");
        httpdPrintf(inServer,
            "<td><input type=text name=serverDescription size=32 value=\"%s\"></td></tr>",
            gServer->Config().serverDescription.c_str());
        httpdPrintf(inServer, "<tr><td align=right>Server Port:</td>");
        httpdPrintf(inServer,
            "<td><input type=text name=serverPort size=6 value=\"%u\"></td></tr>",
            gServer->Config().serverPort);
        httpdPrintf(inServer, "<tr><td align=right>Max Users:</td>");
        httpdPrintf(inServer,
            "<td><input type=text name=maxUsers size=6 value=\"%u\"></td></tr>",
            gServer->Config().maxUsers);
        httpdPrintf(inServer, "<tr><td align=right>Max Downloads:</td>");
        httpdPrintf(inServer,
            "<td><input type=text name=maxDownloads size=6 value=\"%u\"></td></tr>",
            gServer->Config().maxDownloads);
        httpdPrintf(inServer, "<tr><td align=right>Max Uploads:</td>");
        httpdPrintf(inServer,
            "<td><input type=text name=maxUploads size=6 value=\"%u\"></td></tr>",
            gServer->Config().maxUploads);
        httpdPrintf(inServer, "<tr><td colspan=2><hr></td></tr>");
        httpdPrintf(inServer, "<tr><td align=right>Root Path:</td>");
        httpdPrintf(inServer,
            "<td><input type=text name=rootPath size=32 value=\"%s\"></td></tr>",
            gServer->Config().rootPath.c_str());
        httpdPrintf(inServer, "<tr><td align=right>Agreement Path:</td>");
        httpdPrintf(inServer,
            "<td><input type=text name=agreementPath size=32 value=\"%s\"></td></tr>",
            gServer->Config().agreementPath.c_str());
        httpdPrintf(inServer, "<tr><td align=right>News Path:</td>");
        httpdPrintf(inServer,
            "<td><input type=text name=newsPath size=32 value=\"%s\"></td></tr>",
            gServer->Config().newsPath.c_str());
        httpdPrintf(inServer, "<tr><td align=right>Accounts Path:</td>");
        httpdPrintf(inServer,
            "<td><input type=text name=accountsPath size=32 value=\"%s\"></td></tr>",
            gServer->Config().accountsPath.c_str());
        httpdPrintf(inServer, "<tr><td align=right>Logs Path:</td>");
        httpdPrintf(inServer,
            "<td><input type=text name=logsPath size=32 value=\"%s\"></td></tr>",
            gServer->Config().logsPath.c_str());
        httpdPrintf(inServer, "<tr><td colspan=2><hr></td></tr>");
        httpdPrintf(inServer, "<tr><td align=right>Database Address:</td>");
        httpdPrintf(inServer,
            "<td><input type=text name=databaseAddress size=20 value=\"%s\"></td></tr>",
            gServer->Config().databaseAddress.c_str());
        httpdPrintf(inServer, "<tr><td align=right>Database User:</td>");
        httpdPrintf(inServer,
            "<td><input type=text name=databaseUser size=20 value=\"%s\"></td></tr>",
            gServer->Config().databaseUser.c_str());
        httpdPrintf(inServer, "<tr><td align=right>Database Password:</td>");
        httpdPrintf(inServer,
            "<td><input type=password name=databasePassword size=20 value=\"%s\"></td></tr>",
            gServer->Config().databasePassword.c_str());
        httpdPrintf(inServer, "<tr><td align=right>Database Name:</td>");
        httpdPrintf(inServer,
            "<td><input type=text name=databaseName size=20 value=\"%s\"></td></tr>",
            gServer->Config().databaseName.c_str());
        httpdPrintf(inServer, "<tr><td align=right>Database Read Only:</td>");
        string readOnly;
        if (gServer->Config().databaseReadOnly)
            readOnly = "checked ";
        httpdPrintf(inServer,
            "<td><input type=checkbox %sname=databaseReadOnly size=20 value=1></td></tr>",
            readOnly.c_str());
        httpdPrintf(inServer, "<tr><td colspan=2><hr></td></tr>");
        httpdPrintf(inServer, "<tr><td align=right>Idle Timeout:</td>");
        httpdPrintf(inServer,
            "<td><input type=text name=idleTimeout size=3 value=\"%u\"> minutes</td></tr>",
            (gServer->Config().idleTimeout / 60));
        httpdPrintf(inServer, "<tr><td align=right>Temp Ban Timeout:</td>");
        httpdPrintf(inServer,
            "<td><input type=text name=banTimeout size=3 value=\"%u\"> minutes</td></tr>",
            (gServer->Config().banTimeout / 60));
        httpdPrintf(inServer, "<tr><td align=right>Directory Permissions:</td>");
        httpdPrintf(inServer,
            "<td><input type=text name=dirPermissions size=5 value=\"0%o\"></td></tr>",
            gServer->Config().dirPermissions);
        httpdPrintf(inServer, "<tr><td align=right>File Permissions:</td>");
        httpdPrintf(inServer,
            "<td><input type=text name=filePermissions size=5 value=\"0%o\"></td></tr>",
            gServer->Config().filePermissions);
        httpdPrintf(inServer, "<tr><td align=right>Socks Detection Level:</td>");
        httpdPrintf(inServer, "<td><select name=socksDetectLevel>");
        string selectedOption[3];
        selectedOption[gServer->Config().socksDetectLevel] = "selected ";
        httpdPrintf(inServer, "<option %svalue=0>Off</option>", selectedOption[0].c_str());
        httpdPrintf(inServer, "<option %svalue=1>Report</option>", selectedOption[1].c_str());
        httpdPrintf(inServer, "<option %svalue=2>Ban</option>", selectedOption[2].c_str());
        httpdPrintf(inServer, "</select></td></tr><tr><td colspan=2><hr></td></tr>");
        httpdPrintf(inServer, "<tr valign=top><td align=right>Tracker List:</td>");
        TrackerList::const_iterator iter = gServer->Config().trackerList.begin();
        string trackerListString;
        while (iter != gServer->Config().trackerList.end())
        {
            trackerListString.append((*iter).addr + ":" + (*iter).pass + "\n");
            iter++;
        }
        httpdPrintf(inServer,
            "<td><textarea cols=32 rows=5 name=trackerList>%s</textarea></td></tr>",
            trackerListString.c_str());
        httpdPrintf(inServer, "<tr><td colspan=2><hr></td></tr>");
        httpdPrintf(inServer, "<tr><td><input type=submit value=\"Save Config\"></td></tr>");
        httpdPrintf(inServer, "</table></form>");
    }
    httpdPrintf(inServer, "</body></html>");
    
    //httpdSetResponse(inServer, "301 Moved");
    //httpdAddHeader(inServer, "Location: index.html");
    //httpdSendHeaders(inServer);
}

void WebServer::statusPage(httpd *inServer)
{
    WebServer *webServer = (WebServer *)httpdContextPtr(inServer);
    
    httpdPrintf(inServer, "<html><title>Server Status</title><body>");
    if (webServer->mUserAccount.Access().get_user_info)
    {
        httpdPrintf(inServer, "<table border=1 cellpadding=2 cellspacing=1>");
        // table headers
        httpdPrintf(inServer, "<tr><td>ID</td><td>Status</td><td>Icon</td><td>Address</td>");
        httpdPrintf(inServer, "<td>Login</td><td>Name</td><td>Time</td></tr>");
        
        StMutexLock lock(gServer->mLock);
        ClientList::iterator iter = gServer->mClientList.begin();
        time_t currentTime = time(0);
        while (iter != gServer->mClientList.end())
        {
            if ((*iter)->User().IsLoggedIn() && (*iter)->User().LoginTime())
            {
                string timeString;
                FileUtils::formatTime(currentTime - (*iter)->User().LoginTime(), timeString);
                httpdPrintf(inServer,
                    "<tr><td>%u</td><td>%u</td><td>%u</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td></tr>",
                    (*iter)->User().ID(), (*iter)->User().Status(), (*iter)->User().Icon(),
                    (*iter)->Address().c_str(), (*iter)->User().Login().c_str(),
                    (*iter)->User().Name().c_str(), timeString.c_str());
            }
            iter++;
        }
        httpdPrintf(inServer, "</table>");
        
        httpdPrintf(inServer, "<table border=1 cellpadding=2 cellspacing=1>");
        // table headers
        httpdPrintf(inServer, "<tr><td>User</td><td>Type</td><td>File</td><td>Progress</td></tr>");
        
        TransferList::iterator tIter = gServer->mTransAM->mDownloadList.begin();
        string progressString;
        while (tIter != gServer->mTransAM->mDownloadList.end())
        {
            transferProgress((*tIter), progressString);
            httpdPrintf(inServer, "<tr><td>%s</td><td>Download</td><td>%s</td><td>%s</td></tr>",
                (*tIter)->User().Name().c_str(), (*tIter)->Info().fileName.c_str(),
                progressString.c_str());
            tIter++;
        }
        
        tIter = gServer->mTransAM->mUploadList.begin();
        while (tIter != gServer->mTransAM->mUploadList.end())
        {
            transferProgress((*tIter), progressString);
            httpdPrintf(inServer, "<tr><td>%s</td><td>Upload</td><td>%s</td><td>%s</td></tr>",
                (*tIter)->User().Name().c_str(), (*tIter)->Info().fileName.c_str(),
                progressString.c_str());
            tIter++;
        }
        
        httpdPrintf(inServer, "</table>");
    }
    httpdPrintf(inServer, "</body></html>");
}

void WebServer::newsPage(httpd *inServer)
{
    string newsString;
    StMutexLock lock(gServer->mLock);
    gServer->mDataBase.GetNewsFile(newsString);

    string::size_type pos = 0;
    while ((pos = newsString.find('\r', pos)) != string::npos)
    {
        newsString.replace(pos, 1, "<p>");
        pos += 4;
    }
    
    httpdPrintf(inServer, "<html><title>News</title><body>");
    httpdPrintf(inServer, "<div style=\"width: 450px\">");
    // this should be fixed once i can patch libhttpd more
    httpdPrintf(inServer, "%s", newsString.c_str());
    httpdPrintf(inServer, "</div></html></body>");
}

void WebServer::broadcastPage(httpd *inServer)
{
    WebServer *webServer = (WebServer *)httpdContextPtr(inServer);
    
    if (webServer->mUserAccount.Access().can_broadcast)
    {
        httpVar	*msgVar;
        msgVar = httpdGetVariableByName(inServer, "message");
        if (msgVar != NULL)
        {
            StMutexLock lock(gServer->mLock);
            HLPacket broadcastPacket(HTLS_HDR_MSG_BROADCAST, 0, 0);
            broadcastPacket.AddStringObject(HTLS_DATA_MSG, msgVar->value);
            gServer->SendToAll(broadcastPacket);
        }
    }
    
    httpdSetResponse(inServer, "301 Moved");
    httpdAddHeader(inServer, "Location: login.html");
    httpdSendHeaders(inServer);
}

int WebServer::preloadAuthenticate(httpd *inServer)
{
    httpdAuthenticate(inServer, "Terra Server");
    WebServer *webServer = (WebServer *)httpdContextPtr(inServer);
    webServer->mUserAccount.SetFilesPath("");
    webServer->mUserAccount.SetName("");
    struct hl_access_bits emptyAccess;
    memset(&emptyAccess, 0, sizeof(struct hl_access_bits));
    webServer->mUserAccount.SetAccess(emptyAccess);

#ifdef WIN32
		char log_buff[MAX_PATH + 50];
		sprintf( log_buff , "%s\t%s" ,inServer->clientAddr , inServer->request.authUser );
		ServerLog::OtherLog( "Web" , log_buff );
#endif//WIN32
    DEBUG_CALL(printf("web auth user: %s auth pass: %s\n",
        inServer->request.authUser, inServer->request.authPassword); fflush(stdout));
    if (strcmp(inServer->request.authUser, "guest") != 0 && strlen(inServer->request.authPassword) > 0)
    {
        webServer->mUserAccount.SetLogin(inServer->request.authUser);
        webServer->mUserAccount.SetPassword(inServer->request.authPassword);
        StMutexLock lock(gServer->mLock);
        if (gServer->mDataBase.FetchAccount(webServer->mUserAccount))
        {
            return 0;
        }
    }
    
    httpdSetResponse(inServer, "401 Unauthorized");
    httpdPrintf(inServer, "Authorization Failed");
    return -1;
}

void WebServer::transferProgress(HLTransfer *inTransfer, string &outProgressString)
{
    char statsBuf[1024];
	string timeString;
	string sizeString;
    unsigned int timeRemaining;
    string speedString;
    FileUtils::formatSize(inTransfer->TotalBytes(), sizeString);
    FileUtils::formatSize(inTransfer->networkSpeed().BytesPerSecond(), speedString);
    
    timeRemaining = inTransfer->networkSpeed().EstimatedTimeRemaining();
    if (timeRemaining == (unsigned int)-1)
    {
        if (inTransfer->TransferedBytes() == 0)
        {
            // no data has been transfered yet, so just say connecting...
            snprintf(statsBuf, 1023, "%s Connecting...", sizeString.c_str());
        }
        else
        {
            // the transfer has stalled
            snprintf(statsBuf, 1023, "Stalled at %.1f%% of %s",
                inTransfer->networkSpeed().PercentageComplete(), sizeString.c_str());
        }
    }
    else
    {
        FileUtils::formatTime(timeRemaining, timeString);
        
        // this is for the get user info window transfer stats
        snprintf(statsBuf, 1023, "%.1f%% of %s at %s/sec %s remaining",
            inTransfer->networkSpeed().PercentageComplete(), sizeString.c_str(),
            speedString.c_str(), timeString.c_str());
    }
    outProgressString.assign(statsBuf);
}

#endif // defined(_HTTPD_)
