#ifndef PREFIX_H
#define PREFIX_H

#if defined(WIN32)

// Get rid of useless template warning
#pragma warning (disable: 4786)

#include <windows.h>
#include <winsock.h>

#define snprintf _snprintf
#define vsnprintf _vsnprintf
#define strcasecmp _stricmp
#define strncasecmp _strnicmp

#define usleep		Sleep
#define sleep(x)	Sleep(x*1000)

typedef unsigned int		u_int32_t;
typedef unsigned short		u_int16_t;
typedef unsigned char		u_int8_t;
typedef LONGLONG	u_int64_t;

#ifdef SD_BOTH
#define	SHUT_RDWR		SD_BOTH
#else
#define	SHUT_RDWR		0x02
#endif

typedef int socklen_t;
typedef int uid_t;
typedef int gid_t;

#define MAXPATHLEN		_MAX_PATH

#ifdef _DEBUG
#define _DEBUG_BUILD_
#endif //_DEBUG

// This option doesn't exist on windows.  You probably shouldn't use it
#define	MSG_WAITALL		0
#include <io.h>
#include <direct.h>
#include <process.h>

// Since windows doesn't have symbolic links, we can forward the call to _stat
#include <sys/stat.h>
#define lstat		stat
#define S_ISLNK(x)	0
#define S_ISDIR(x)	(x&_S_IFDIR)

// If someone tries to create a symlink, this will return an error always.
#define symlink(x,y)	(-1)

#ifdef __cplusplus
extern "C" {
char *inet_ntoa_r(struct in_addr in, char *buf, int len);
struct tm *localtime_r(const time_t *t, struct tm *tm);
int gettimeofday(struct timeval *tp, struct timezone *tzp);
int inet_aton(const char *cp, struct in_addr * addr);
}
inline int mkdir( const char *dirname, int mode ) { return _mkdir(dirname); }
#endif // __cplusplus

#endif //WIN32

// netdata_t is the type of pointer that send and recv and other socket calls take
#ifdef WIN32
typedef char netdata_t;
#else
typedef void netdata_t;
#endif

// config.h is generated by the configure script
#if defined(HAVE_CONFIG_H)
	#include "config.h"
#endif

// can't use 'DARWIN' because it conflicts with Apple's headers
#if defined(_DARWIN_)
	// Darwin is missing this typedef
	typedef int socklen_t;
    // to turn on thread support in STL 
    // (see http://developer.apple.com/techpubs/macosx/ReleaseNotes/Compiler.html)
    #define _PTHREADS 1 // to turn on thread support in STL
#else
    // semaphores seem to work on all other systems i've tested with
	// which include Solaris, FreeBSD, and Linux
	#undef BROKEN_SEMAPHORES
#endif

#if defined(_DEBUG_BUILD_)
	#define DEBUG_CALL(call) call
#else
	#define DEBUG_CALL(call)
#endif

#include <sys/types.h>
#include <stdlib.h>
#include <stdio.h>
#include <assert.h>

// Every system except Win32 closes sockets with a call to close()
#ifndef WIN32
#define closesocket close
#define O_BINARY 0 // Win32 need O_BINARY else it opens files in textmode
#endif

// Threading Model
#if defined(WIN32)
	#define USE_WIN32THREADS 1
#else
	#define USE_PTHREADS 1
#endif

// including this slows down compile time a bit, but its needed for MSG_NOSIGNAL
#if !defined(WIN32)
#include <sys/socket.h>
#endif

#if !defined(MSG_NOSIGNAL)
    //#if !defined(SO_NOSIGPIPE)
        // FreeBSD 4.x, Solaris, and possibly other systems don't support either of these
        // so I am forced to still ignore SIGPIPE, which may still cause a problem
    //#else
        // Darwin has the sockopt SO_NOSIGPIPE instead of this flag to send()
        #define MSG_NOSIGNAL 0
    //#endif
#endif

#ifdef __cplusplus
#include <iostream>
#endif

#ifndef PACKED
#ifdef __GNUC__
    #define PACKED __attribute__((__packed__))
#else
    #define PACKED
#endif
#endif

#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
    #define ZERO_SIZE_ARRAY_SIZE	0
#else
    #define ZERO_SIZE_ARRAY_SIZE	1
#endif

#ifndef WORDS_BIGENDIAN
#if defined(__BIG_ENDIAN__)
    #define WORDS_BIGENDIAN 1
#endif
#endif

#if defined(WORDS_BIGENDIAN)
	#define htonll(n) n
	#define ntohll(n) n
#else
	#define htonll(n) ((((unsigned long long)htonl(n)) << 32) + htonl(n >> 32))
	#define ntohll(n) ((((unsigned long long)ntohl(n)) << 32) + ntohl(n >> 32))
#endif

#endif // PREFIX_H
