﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace WitchPaper
{
    public partial class Form1 : Form
    {
        private com.ast8.fw.forms.CustomClipboardIF m_clip = new com.ast8.fw.forms.WitchClip();
        public Form1()
        {
            InitializeComponent();
            witchPaper1.Clipboard = m_clip;
            this.witchPaper1.SelectModeChanged += new com.ast8.fw.forms.SelectModeChangedEventHandler(this.witchPaper1_SelectModeChanged);
            this.witchPaper1.CursorModeChanged += new com.ast8.fw.forms.CursorModeChangedEventHandler(this.witchPaper1_CursorModeChanged);
            this.witchPaper1.InputModeChanged += new com.ast8.fw.forms.InputModeChangedEventHandler(this.witchPaper1_InputModeChanged);
            foreach (ToolStripMenuItem parentItem in menuStrip1.Items)
            {
                parentItem.DropDownOpening += new EventHandler(hook);
            }
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            refreshAll();
        }

        private void addLog(string log)
        {
            listBox1.Items.Add(log);
            listBox1.SelectedIndex = listBox1.Items.Count - 1;
        }   
        private void addLog(object log)
        {
            addLog(log.ToString());
        }
        private void clearLog()
        {
            listBox1.Items.Clear();
        }
        private void listBox1_DoubleClick(object sender, EventArgs e)
        {
            clearLog();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            witchPaper1.Refresh();
        }

        private void Form1_Resize(object sender, EventArgs e)
        {
            witchPaper1.Width = this.ClientSize.Width - witchPaper1.Left;
        }

        private void numericUpDown1_ValueChanged(object sender, EventArgs e)
        {
            witchPaper1.Font = new Font(witchPaper1.Font.FontFamily, decimal.ToSingle(numericUpDown1.Value));
        }

        private void listBox1_SelectedIndexChanged(object sender, EventArgs e)
        {

        }

        private void splitContainer1_Panel1_Paint(object sender, PaintEventArgs e)
        {

        }

        private void timer1_Tick(object sender, EventArgs e)
        {
        }

        private void witchPaper1_Click(object sender, EventArgs e)
        {

        }

        private void copyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            witchPaper1.Copy();
            witchPaper1.Refresh();
        }

        private void cutToolStripMenuItem_Click(object sender, EventArgs e)
        {
            witchPaper1.Cut();
            witchPaper1.Refresh();
        }

        private void deleteToolStripMenuItem_Click(object sender, EventArgs e)
        {
            witchPaper1.Delete();
            witchPaper1.Refresh();
        }

        private void pasteToolStripMenuItem_Click(object sender, EventArgs e)
        {
            witchPaper1.Paste();
            witchPaper1.Refresh();
        }

        private void allSelectToolStripMenuItem_Click(object sender, EventArgs e)
        {
            // なんてやらんでもSelectAllでも可
            Point p1 = witchPaper1.GetFirstXY();
            Point p2 = witchPaper1.GetLastXY();
            witchPaper1.SelectMode = com.ast8.fw.forms.SelectMode.Normal;
            witchPaper1.SelectionArea = new com.ast8.fw.forms.TextSelectionArea(
                p2.X, p2.Y,
                p1.X, p1.Y,
                p2.X, p2.Y
                );
            witchPaper1.ScrollToCaret();
            witchPaper1.Refresh();
        }

        private void endToolStripMenuItem_Click(object sender, EventArgs e)
        {
            // なんてやらんでもSelectionStart = 0, SelectionLength = Text.Lengthでも可。
            // ただし上記コードは遅い！！
            Point p = witchPaper1.GetLastXY();
            witchPaper1.SelectionArea = new com.ast8.fw.forms.TextSelectionArea(
                p.X, p.Y,
                witchPaper1.SelectionArea.StartX,
                witchPaper1.SelectionArea.StartY,
                p.X, p.Y
                );
            witchPaper1.ScrollToCaret();
            witchPaper1.Refresh();
        }

        private void homeToolStripMenuItem_Click(object sender, EventArgs e)
        {
            // なんてやらんでもSelectionStart = 0でも可。
            // これだと選択領域がクリアされちゃうのでSelectionLengthの指定しなおしは必要。
            // int length = SelectionStart+1, SelectionStart = 0, SelectionLength = length;
            // かな？でも遅いぞ。
            Point p = witchPaper1.GetFirstXY();
            witchPaper1.SelectionArea = new com.ast8.fw.forms.TextSelectionArea(
                p.X, p.Y, 
                witchPaper1.SelectionArea.StartX,
                witchPaper1.SelectionArea.StartY, 
                p.X, p.Y
                );
            witchPaper1.ScrollToCaret();
            witchPaper1.Refresh();
        }

        private void backColorToolStripMenuItem_Click(object sender, EventArgs e)
        {
            colorDialog1.Color = witchPaper1.BackColor;
            if (colorDialog1.ShowDialog() == DialogResult.Cancel)
                return;
            witchPaper1.BackColor = colorDialog1.Color;
        }

        private void fontToolStripMenuItem_Click(object sender, EventArgs e)
        {
            fontDialog1.Color = witchPaper1.ForeColor;
            fontDialog1.Font = witchPaper1.Font;
            fontDialog1.FixedPitchOnly = true;
            fontDialog1.ShowColor = true;
            if (fontDialog1.ShowDialog() == DialogResult.Cancel)
                return;
            witchPaper1.Font = fontDialog1.Font;
            witchPaper1.ForeColor = fontDialog1.Color;
        }

        private void appendToolStripMenuItem_Click(object sender, EventArgs e)
        {
            witchPaper1.InputMode = com.ast8.fw.forms.TextInputMode.Append;
        }

        private void insertToolStripMenuItem_Click(object sender, EventArgs e)
        {
            witchPaper1.InputMode = com.ast8.fw.forms.TextInputMode.Insert;
        }

        private void overwriteToolStripMenuItem_Click(object sender, EventArgs e)
        {
            witchPaper1.InputMode = com.ast8.fw.forms.TextInputMode.Overwrite;
        }

        private void unknownToolStripMenuItem_Click(object sender, EventArgs e)
        {
            witchPaper1.InputMode = com.ast8.fw.forms.TextInputMode.Unknown;
        }

        private void noneToolStripMenuItem_Click(object sender, EventArgs e)
        {
            witchPaper1.LineNumberMode = com.ast8.fw.forms.LineNumberMode.None;
        }

        private void visibleToolStripMenuItem_Click(object sender, EventArgs e)
        {
            witchPaper1.LineNumberMode = com.ast8.fw.forms.LineNumberMode.Visible;
        }

        private void physycalToolStripMenuItem_Click(object sender, EventArgs e)
        {
            witchPaper1.LineNumberMode = com.ast8.fw.forms.LineNumberMode.Physical;
        }

        private void normalToolStripMenuItem_Click(object sender, EventArgs e)
        {
            witchPaper1.CursorMode = com.ast8.fw.forms.CursorMode.Normal;
        }

        private void freeToolStripMenuItem_Click(object sender, EventArgs e)
        {
            witchPaper1.CursorMode = com.ast8.fw.forms.CursorMode.Free;
        }

        private void noneToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            witchPaper1.SelectMode = com.ast8.fw.forms.SelectMode.None;
        }

        private void normalToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            witchPaper1.SelectMode = com.ast8.fw.forms.SelectMode.Normal;
        }

        private void rectangleToolStripMenuItem_Click(object sender, EventArgs e)
        {
            witchPaper1.SelectMode = com.ast8.fw.forms.SelectMode.Rectangle;
        }

        private void autoTextTurnPointToolStripMenuItem_Click(object sender, EventArgs e)
        {
            witchPaper1.AutoTextTurnPoint = !witchPaper1.AutoTextTurnPoint;
        }

        private void textTurnPointToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string retValue = InputBox.Show("InputBox", "TextTurnPointプロパティの値を入力してください", witchPaper1.TextTurnPoint.ToString());
            try
            {
                witchPaper1.TextTurnPoint = ushort.Parse(retValue);
            }
            catch(Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void autoInputModeToolStripMenuItem_Click(object sender, EventArgs e)
        {
            witchPaper1.AutoInputMode = !witchPaper1.AutoInputMode;
        }

        private void readOnlyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            witchPaper1.ReadOnly = !witchPaper1.ReadOnly;
        }

        private void currentLineToolStripMenuItem_Click(object sender, EventArgs e)
        {
            witchPaper1.ShowLines.CurrentLine = !witchPaper1.ShowLines.CurrentLine;
            witchPaper1.Refresh();
        }

        private void textTurnPointToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            witchPaper1.ShowLines.TextTurnPoint = !witchPaper1.ShowLines.TextTurnPoint;
            witchPaper1.Refresh();
        }

        private void visibleToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            witchPaper1.Visible = !witchPaper1.Visible;
        }

        private void enabledToolStripMenuItem_Click(object sender, EventArgs e)
        {
            witchPaper1.Enabled = !witchPaper1.Enabled;
        }

        private void hook(object sender, EventArgs e)
        {
            refreshAll();
        }

        private void refreshAll()
        {
            autoInputModeToolStripMenuItem.Checked = witchPaper1.AutoInputMode;
            
            appendToolStripMenuItem.Checked = (witchPaper1.InputMode == com.ast8.fw.forms.TextInputMode.Append);
            insertToolStripMenuItem.Checked = (witchPaper1.InputMode == com.ast8.fw.forms.TextInputMode.Insert);
            overwriteToolStripMenuItem.Checked = (witchPaper1.InputMode == com.ast8.fw.forms.TextInputMode.Overwrite);
            unknownToolStripMenuItem.Checked = (witchPaper1.InputMode == com.ast8.fw.forms.TextInputMode.Unknown);
            
            noneToolStripMenuItem1.Checked = (witchPaper1.SelectMode == com.ast8.fw.forms.SelectMode.None);
            normalToolStripMenuItem1.Checked = (witchPaper1.SelectMode == com.ast8.fw.forms.SelectMode.Normal);
            rectangleToolStripMenuItem.Checked = (witchPaper1.SelectMode == com.ast8.fw.forms.SelectMode.Rectangle);
            
            currentLineToolStripMenuItem.Checked = witchPaper1.ShowLines.CurrentLine;
            textTurnPointToolStripMenuItem1.Checked = witchPaper1.ShowLines.TextTurnPoint;
            
            readOnlyToolStripMenuItem.Checked = witchPaper1.ReadOnly;
            
            autoTextTurnPointToolStripMenuItem.Checked = witchPaper1.AutoTextTurnPoint;
            
            textTurnPointToolStripMenuItem.Text = "TextTurnPoint(" + witchPaper1.TextTurnPoint + ")";
            
            normalToolStripMenuItem.Checked = (witchPaper1.CursorMode == com.ast8.fw.forms.CursorMode.Normal);
            freeToolStripMenuItem.Checked = (witchPaper1.CursorMode == com.ast8.fw.forms.CursorMode.Free);

            noneToolStripMenuItem.Checked = (witchPaper1.LineNumberMode == com.ast8.fw.forms.LineNumberMode.None);
            visibleToolStripMenuItem.Checked = (witchPaper1.LineNumberMode == com.ast8.fw.forms.LineNumberMode.Visible);
            physycalToolStripMenuItem.Checked = (witchPaper1.LineNumberMode == com.ast8.fw.forms.LineNumberMode.Physical);

            tabSpaceToolStripMenuItem.Text = "TabSpace(" + witchPaper1.TabSpace + ")";

            enabledToolStripMenuItem.Checked = witchPaper1.Enabled;
            visibleToolStripMenuItem1.Checked = witchPaper1.Visible;
        }

        private void witchPaper1_BeforeTextChanged(object sender, com.ast8.fw.forms.BeforeTextChangedEventArgs e)
        {
            addLog(string.Format("BeforeTextChanged:{0} {1}",
                e.Operation.ToString(),
                (string.IsNullOrEmpty(e.InputString) ? "" : e.InputString)
            ));
        }

        private void witchPaper1_InputModeChanged(object sender, com.ast8.fw.forms.OldValueCancelEventArgs<com.ast8.fw.forms.TextInputMode> e)
        {
            addLog("InputModeChanged"+witchPaper1.InputMode.ToString());
        }

        private void witchPaper1_SelectModeChanged(object sender, com.ast8.fw.forms.OldValueCancelEventArgs<com.ast8.fw.forms.SelectMode> e)
        {
            addLog("SelectModeChanged:" + witchPaper1.SelectMode.ToString());
        }

        private void witchPaper1_TextChanged(object sender, EventArgs e)
        {
            addLog("TextChanged");
        }

        private void witchPaper1_CursorModeChanged(object sender, com.ast8.fw.forms.OldValueCancelEventArgs<com.ast8.fw.forms.CursorMode> e)
        {
            addLog("CursorModeChanged:" + witchPaper1.CursorMode.ToString());
        }

        private void listBox1_DoubleClick_1(object sender, EventArgs e)
        {
            listBox1.Items.Clear();
        }

        private void loadToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog() == DialogResult.Cancel)
                return;
            if (System.IO.File.Exists(openFileDialog1.FileName) == false)
            {
                MessageBox.Show("ファイルが存在しません");
                return;
            }
            System.IO.Stream s = null;
            System.IO.StreamReader reader = null;
            try
            {
                // utf8のみ対応ッス
                s = System.IO.File.Open(openFileDialog1.FileName, System.IO.FileMode.Open, System.IO.FileAccess.Read, System.IO.FileShare.Read);
                reader = new System.IO.StreamReader(s);
                witchPaper1.Text = reader.ReadToEnd();
                witchPaper1.Refresh();
            }
            catch (System.IO.IOException ex)
            {
                MessageBox.Show(ex.ToString());
            }
            finally
            {
                // ここの例外はもういいや
                if (s != null)
                    s.Close();
                if (reader != null)
                    reader.Close();
            }
        }

        private void saveToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (saveFileDialog1.ShowDialog() == DialogResult.Cancel)
                return;
            System.IO.Stream s = null;
            try
            {
                s = System.IO.File.Open(saveFileDialog1.FileName, System.IO.FileMode.Create, System.IO.FileAccess.Write, System.IO.FileShare.Read);
                byte[] by = Encoding.UTF8.GetBytes(witchPaper1.Text);
                s.Write(by, 0, by.Length);
            }
            catch (System.IO.IOException ex)
            {
                MessageBox.Show(ex.ToString());
            }
            finally
            {
                // ここの例外はもういいや
                if (s != null)
                {
                    s.Close();
                }
            }
        }

        private WitchMonitor m_monitor = new WitchMonitor();
        private void monitorToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (m_monitor.Visible)
                m_monitor.Show();
            else
            {
                m_monitor.Dispose();
                m_monitor = new WitchMonitor();
                m_monitor.init(witchPaper1);
                m_monitor.Show();
            }
        }
        private WitchTextMonitor m_textMonitor = new WitchTextMonitor();
        private void toolStripMenuItem5_Click(object sender, EventArgs e)
        {
            if (m_textMonitor.Visible)
                m_textMonitor.Show();
            else
            {
                m_textMonitor.Dispose();
                m_textMonitor = new WitchTextMonitor();
                m_textMonitor.init(witchPaper1);
                m_textMonitor.Show();
            }
        }

        private void multiRunningToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Form1 frm = new Form1();
            frm.Show();
        }

        protected override void OnKeyDown(KeyEventArgs e)
        {
            base.OnKeyDown(e);
            // shift補正の自作ショートカット
            if (e.Control)
            {
                if (e.Shift)
                {
                    if ((e.KeyCode & Keys.Home) == Keys.Home)
                    {
                        homeToolStripMenuItem_Click(this, new EventArgs());
                    }
                    else if ((e.KeyCode & Keys.End) == Keys.End)
                    {
                        endToolStripMenuItem_Click(this, new EventArgs());
                    }
                    else if ((e.KeyCode & Keys.A) == Keys.A)
                    {
                        allSelectToolStripMenuItem_Click(this, new EventArgs());
                    }

                }
            }
        }

        private void tabSpaceToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string retValue = InputBox.Show("InputBox", "TabSpaceプロパティの値を入力してください", witchPaper1.TextTurnPoint.ToString());
            try
            {
                witchPaper1.TabSpace = ushort.Parse(retValue);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }
    }
}